"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const worker_1 = require("threads/worker");
const conf_1 = require("@lingui/conf");
const extractors_1 = __importDefault(require("../api/extractors"));
let linguiConfig;
const extractWorker = async (filename, linguiConfigPath) => {
    if (!linguiConfig) {
        // initialize config once per worker, speed up workers follow execution
        linguiConfig = (0, conf_1.getConfig)({
            configPath: linguiConfigPath,
            skipValidation: true,
        });
    }
    const messages = [];
    const success = await (0, extractors_1.default)(filename, (msg) => {
        messages.push(msg);
    }, linguiConfig);
    return { success, messages };
};
(0, worker_1.expose)(extractWorker);
