"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const worker_1 = require("threads/worker");
const conf_1 = require("@lingui/conf");
const extractFromBundleAndWrite_1 = require("../extractFromBundleAndWrite");
const formats_1 = require("../../api/formats");
let linguiConfig;
let format;
const extractWorker = async (linguiConfigPath, entryPoint, bundleFile, outputPattern, template, locales, clean, overwrite) => {
    if (!linguiConfig) {
        // initialize config once per worker, speed up workers follow execution
        linguiConfig = (0, conf_1.getConfig)({
            configPath: linguiConfigPath,
            skipValidation: true,
        });
    }
    if (!format) {
        format = await (0, formats_1.getFormat)(linguiConfig.format, linguiConfig.formatOptions, linguiConfig.sourceLocale);
    }
    return await (0, extractFromBundleAndWrite_1.extractFromBundleAndWrite)({
        entryPoint,
        bundleFile,
        outputPattern,
        format,
        linguiConfig,
        locales,
        overwrite,
        clean,
        template,
    });
};
(0, worker_1.expose)(extractWorker);
