"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractFromBundleAndWrite = extractFromBundleAndWrite;
const extractFromFiles_1 = require("../api/catalog/extractFromFiles");
const writeCatalogs_1 = require("./writeCatalogs");
const promises_1 = __importDefault(require("fs/promises"));
const babel_1 = require("../api/extractors/babel");
async function extractFromBundle(filename, linguiConfig) {
    const messages = {};
    let success;
    try {
        const file = await promises_1.default.readFile(filename);
        const parserOptions = linguiConfig.extractorParserOptions;
        await (0, babel_1.extractFromFileWithBabel)(filename, file.toString(), (msg) => {
            (0, extractFromFiles_1.mergeExtractedMessage)(msg, messages, linguiConfig);
        }, {
            linguiConfig,
        }, {
            plugins: (0, babel_1.getBabelParserOptions)(filename, parserOptions),
        }, true);
        success = true;
    }
    catch (e) {
        console.error(`Cannot process file ${filename} ${e.message}`);
        console.error(e.stack);
        success = false;
    }
    return { success, messages };
}
async function extractFromBundleAndWrite(params) {
    const { linguiConfig, entryPoint, format, outputPattern, locales, overwrite, clean, template, } = params;
    const { messages, success } = await extractFromBundle(params.bundleFile, params.linguiConfig);
    if (!success) {
        return { success: false };
    }
    let stat;
    if (template) {
        stat = (await (0, writeCatalogs_1.writeTemplate)({
            linguiConfig,
            clean,
            format,
            messages,
            entryPoint,
            outputPattern,
        })).statMessage;
    }
    else {
        stat = (await (0, writeCatalogs_1.writeCatalogs)({
            locales,
            linguiConfig,
            clean,
            format,
            messages,
            entryPoint,
            overwrite,
            outputPattern,
        })).statMessage;
    }
    return { success: true, stat };
}
