"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildIncludeDepsFilter = buildIncludeDepsFilter;
function createPackageRegExp(packageName) {
    return new RegExp("^" + packageName + "(?:\\/.+)?");
}
function buildIncludeDepsFilter(includeDeps) {
    const include = includeDeps.map(createPackageRegExp);
    return (id) => include.some((regExp) => regExp.test(id));
}
