"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStats = getStats;
exports.printStats = printStats;
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
const cli_table_1 = __importDefault(require("cli-table"));
const picocolors_1 = __importDefault(require("picocolors"));
function getStats(catalog) {
    return [
        Object.keys(catalog).length,
        Object.keys(catalog).filter((key) => !catalog[key].translation).length,
    ];
}
function printStats(config, catalogs) {
    const table = new cli_table_1.default({
        head: ["Language", "Total count", "Missing"],
        colAligns: ["left", "middle", "middle"],
        style: {
            head: ["green"],
            border: [],
            compact: true,
        },
    });
    Object.keys(catalogs)
        .sort((a, b) => {
        if (a === config.sourceLocale && b !== config.sourceLocale)
            return -1;
        if (b === config.sourceLocale && a !== config.sourceLocale)
            return 1;
        return a.localeCompare(b);
    })
        .forEach((locale) => {
        if (locale === config.pseudoLocale)
            return; // skip pseudo locale
        const catalog = catalogs[locale];
        // catalog is null if no catalog exists on disk and the locale
        // was not extracted due to a `--locale` filter
        const [all, translated] = catalog ? getStats(catalog) : ["-", "-"];
        if (config.sourceLocale === locale) {
            table.push({ [`${picocolors_1.default.bold(locale)} (source)`]: [all, "-"] });
        }
        else {
            table.push({ [locale]: [all, translated] });
        }
    });
    return table;
}
