"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = extract;
const promises_1 = __importDefault(require("fs/promises"));
const babel_1 = __importDefault(require("./babel"));
const DEFAULT_EXTRACTORS = [babel_1.default];
async function extract(filename, onMessageExtracted, linguiConfig) {
    var _a;
    const extractorsToExtract = (_a = linguiConfig.extractors) !== null && _a !== void 0 ? _a : DEFAULT_EXTRACTORS;
    for (const ext of extractorsToExtract) {
        if (!ext.match(filename))
            continue;
        try {
            const file = await promises_1.default.readFile(filename);
            await ext.extract(filename, file.toString(), onMessageExtracted, {
                linguiConfig,
            });
            return true;
        }
        catch (e) {
            console.error(`Cannot process file ${filename} ${e.message}`);
            console.error(e.stack);
            return false;
        }
    }
    return true;
}
