import { LinguiConfigNormalized, OrderBy } from "@lingui/conf";
import { FormatterWrapper } from "./formats";
import { CompiledCatalogNamespace } from "./compile";
import { GetTranslationsOptions } from "./catalog/getTranslationsForCatalog";
import { AllCatalogsType, CatalogType, ExtractedCatalogType } from "./types";
import { ExtractWorkerPool } from "./extractWorkerPool";
export type MakeOptions = {
    files?: string[];
    clean: boolean;
    overwrite: boolean;
    locale: string[];
    orderBy?: OrderBy;
    workerPool?: ExtractWorkerPool;
};
export type MakeTemplateOptions = {
    files?: string[];
    orderBy?: OrderBy;
    workerPool?: ExtractWorkerPool;
};
export type MergeOptions = {
    overwrite?: boolean;
    files?: string[];
};
export type CatalogProps = {
    name?: string;
    path: string;
    include: Array<string>;
    exclude?: Array<string>;
    templatePath?: string;
    format: FormatterWrapper;
};
export declare class Catalog {
    config: LinguiConfigNormalized;
    name?: string;
    path: string;
    include: Array<string>;
    exclude: Array<string>;
    format: FormatterWrapper;
    templateFile?: string;
    constructor({ name, path, include, templatePath, format, exclude }: CatalogProps, config: LinguiConfigNormalized);
    getFilename(locale: string): string;
    make(options: MakeOptions): Promise<AllCatalogsType | false>;
    makeTemplate(options: MakeTemplateOptions): Promise<CatalogType | false>;
    /**
     * Collect messages from source paths. Return a raw message catalog as JSON.
     */
    collect(options?: {
        files?: string[];
        workerPool?: ExtractWorkerPool;
    }): Promise<ExtractedCatalogType | undefined>;
    merge(prevCatalogs: AllCatalogsType, nextCatalog: ExtractedCatalogType, options: MergeOptions): {
        [k: string]: CatalogType;
    };
    getTranslations(locale: string, options: GetTranslationsOptions): Promise<{
        missing: import("./catalog/getTranslationsForCatalog").TranslationMissingEvent[];
        messages: {
            [id: string]: string;
        };
    }>;
    write(locale: string, messages: CatalogType): Promise<[created: boolean, filename: string]>;
    writeTemplate(messages: CatalogType): Promise<void>;
    read(locale: string): Promise<CatalogType>;
    readAll(locales?: string[]): Promise<AllCatalogsType>;
    readTemplate(): Promise<CatalogType>;
    get sourcePaths(): string[];
    get localeDir(): string;
    get locales(): string[];
}
export declare function cleanObsolete<T extends ExtractedCatalogType>(messages: T): T;
export declare function order<T extends ExtractedCatalogType>(by: OrderBy, catalog: T): T;
export declare function writeCompiled(path: string, locale: string, compiledCatalog: string, namespace?: CompiledCatalogNamespace): Promise<string>;
export declare function orderByMessage<T extends ExtractedCatalogType>(messages: T): T;
