<h1><a href="https://play.tessel.at/"><img src="assets/logo/logo-with-tile.svg" width="250" alt="Tessel – A tile game"/></a></h1>

<a href="https://play.tessel.at/"><img src="assets/social/play-now-badge.png" alt="Play now!" height="60"></a>
<a href="https://f-droid.org/packages/net.vantulder.tessel"><img src="assets/social/fdroid-badge.png" alt="Get it on F-Droid" height="60"></a>
<a href="https://play.google.com/store/apps/details?id=net.vantulder.tessel"><img src="assets/social/google-play.png" alt="Get it on Google Play" height="60"></a>
<a href="https://apps.apple.com/app/tessel/id6754282700"><img src="assets/social/apple-app-store.png" alt="Download on the App Store" height="60"></a>

_A game by <a href="https://www.vantulder.net/">Gijs van Tulder</a>_

**[Play online!]** • [Tilings] • [Settings] • [Custom game] • [Translations] • [Development]

[Play online!]: https://play.tessel.at/
[Tilings]: #tilings
[Settings]: #settings
[Custom game]: #play-a-custom-game
[Translations]: #translations
[Development]: #development

Place tiles with matching colors to make shapes and fill the board.

<img src="assets/screenshots/wide-01-main-menu.png" width="200"/> <img src="assets/screenshots/wide-03-square.png" width="200"/> <img src="assets/screenshots/wide-05-paint-triangle.png" width="200"/> <img src="assets/screenshots/wide-04-setup.png" width="200"/>

## Tilings

Play one of the nine tiling patterns:

| <img src="docs/images/setup-option-square.png" height="50"><br/>Square | <img src="docs/images/setup-option-triangle.png" height="50"><br/>Triangle | <img src="docs/images/setup-option-rhombus.png" height="50"><br/>Rhombus |
| ---------------------------------------------------------------------- | -------------------------------------------------------------------------- | ------------------------------------------------------------------------ |
| <img src="docs/images/example-square-grid.png" height="140">           | <img src="docs/images/example-triangle-grid.png" height="140">             | <img src="docs/images/example-rhombus-grid.png" height="140">            |
| [Wikipedia](https://en.wikipedia.org/wiki/Square_tiling)               | [Wikipedia](https://en.wikipedia.org/wiki/Triangular_tiling)               | [Wikipedia](https://en.wikipedia.org/wiki/Rhombille_tiling)              |

| <img src="docs/images/setup-option-pentagon.png" height="50"><br/>Cairo pentagonal | <img src="docs/images/setup-option-hexagon.png" height="50"><br/>Hexagonal | <img src="docs/images/setup-option-deltotrihex.png" height="50"> <br/> Deltoidal-trihexagonal      |
| ---------------------------------------------------------------------------------- | -------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------- |
| <img src="docs/images/example-pentagon-grid.png" height="140">                     | <img src="docs/images/example-hexagon-grid.png" height="140">              | <img src="docs/images/example-deltotrihex-grid.png" height="140">                                  |
| [Wikipedia](https://en.wikipedia.org/wiki/Cairo_pentagonal_tiling)                 | [Wikipedia](https://en.wikipedia.org/wiki/Hexagonal_tiling)                | [Wikipedia](https://en.wikipedia.org/wiki/Rhombitrihexagonal_tiling#Deltoidal_trihexagonal_tiling) |

| <img src="docs/images/setup-option-penrose.png" height="50"> <br/>Penrose P3    | <img src="docs/images/setup-option-snubsquare.png" height="50"> <br/>Snub square | <img src="docs/images/setup-option-ammannbeenker.png" height="50"> <br/> Ammann-Beenker |
| ------------------------------------------------------------------------------- | -------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------- |
| <img src="docs/images/example-penrose-grid.png" height="140">                   | <img src="docs/images/example-snubsquare-grid.png" height="140">                 | <img src="docs/images/example-ammannbeenker-grid.png" height="140">                     |
| [Wikipedia](<https://en.wikipedia.org/wiki/Penrose_tiling#Rhombus_tiling_(P3)>) | [Wikipedia](https://en.wikipedia.org/wiki/Snub_square_tiling)                    | [Wikipedia](https://en.wikipedia.org/wiki/Ammann%E2%80%93Beenker_tiling)                |

## Settings

Click the hamburger menu to change the settings of the current game:

<img src="docs/images/settings-full-menu.png" height="200"/>

| Option                                                               | Action                                        |
| -------------------------------------------------------------------- | --------------------------------------------- |
| <img src="docs/images/settings-backtomenu.png" height="30"/>         | Return to the main menu.                      |
| <img src="docs/images/settings-setup.png" height="30"/>              | Choose a custom tiling and rules.             |
| <img src="docs/images/settings-restart.png" height="30"/>            | Restart the current game.                     |
| <img src="docs/images/settings-toggle-placeholder.png" height="30"/> | Show all tile outlines.                       |
| <img src="docs/images/settings-toggle-check.png" height="30"/>       | Show where the current tile can be placed.    |
| <img src="docs/images/settings-toggle-autorotate.png" height="30"/>  | Automatically rotate the tile to make it fit. |
| <img src="docs/images/settings-toggle-snap.png" height="30"/>        | Snap tiles into place while dragging.         |

## Play a custom game

Customize shapes and colors in the design menu:

<img src="assets/screenshots/wide-04-setup.png" width="300"/>

### Tiling

| <img src="docs/images/setup-option-square.png" height="50"> | <img src="docs/images/setup-option-triangle.png" height="50"> | <img src="docs/images/setup-option-rhombus.png" height="50"> | <img src="docs/images/setup-option-pentagon.png" height="50"> | <img src="docs/images/setup-option-hexagon.png" height="50"> |
| ----------------------------------------------------------- | ------------------------------------------------------------- | ------------------------------------------------------------ | ------------------------------------------------------------- | ------------------------------------------------------------ |
| Square                                                      | Triangle                                                      | Rhombus                                                      | Pentagon                                                      | Hexagon                                                      |

| <img src="docs/images/setup-option-deltotrihex.png" height="50"> | <img src="docs/images/setup-option-penrose.png" height="50"> | <img src="docs/images/setup-option-snubsquare.png" height="50"> | <img src="docs/images/setup-option-ammannbeenker.png" height="50"> |
| ---------------------------------------------------------------- | ------------------------------------------------------------ | --------------------------------------------------------------- | ------------------------------------------------------------------ |
| Deltoidal-<br/>trihexagonal                                      | Penrose                                                      | Snub<br/>square                                                 | Ammann-<br/>Beenker                                                |

### Number of colors

| <img src="docs/images/setup-option-six-colors.png" height="70"> | <img src="docs/images/setup-option-five-colors.png" height="70"> | <img src="docs/images/setup-option-four-colors.png" height="70"> | <img src="docs/images/setup-option-three-colors.png" height="70"> | <img src="docs/images/setup-option-two-colors.png" height="70"> |
| --------------------------------------------------------------- | ---------------------------------------------------------------- | ---------------------------------------------------------------- | ----------------------------------------------------------------- | --------------------------------------------------------------- |
| Six                                                             | Five                                                             | Four                                                             | Three                                                             | Two                                                             |

### Tile colorings

| <img src="docs/images/setup-option-tile-color-all.png" height="70"> | <img src="docs/images/setup-option-tile-color-unique.png" height="70"> | <img src="docs/images/setup-option-tile-color-two.png" height="70"> | <img src="docs/images/setup-option-tile-color-single.png" height="70"> |
| ------------------------------------------------------------------- | ---------------------------------------------------------------------- | ------------------------------------------------------------------- | ---------------------------------------------------------------------- |
| Mixed                                                               | All unique                                                             | Two colors                                                          | Single color                                                           |

### Matching rule

| <img src="docs/images/setup-option-rule-same-color.png" height="70"> | <img src="docs/images/setup-option-rule-different-color.png" height="70"> |
| -------------------------------------------------------------------- | ------------------------------------------------------------------------- |
| Touching tiles<br/>must have the <br/>same color                     | Touching tiles <br/>must have <br/>different colors                       |

### Scoring rule

| <img src="docs/images/setup-option-score-connected.png" height="70"> | <img src="docs/images/setup-option-score-single-tile.png" height="70"> | <img src="docs/images/setup-option-score-convex-shape.png" height="70"> | <img src="docs/images/setup-option-score-full-vertex.png" height="70"> | <img src="docs/images/setup-option-score-holes.png" height="70"> |
| -------------------------------------------------------------------- | ---------------------------------------------------------------------- | ----------------------------------------------------------------------- | ---------------------------------------------------------------------- | ---------------------------------------------------------------- |
| Closed area                                                          | Single tile                                                            | Convex shape                                                            | Full vertex                                                            | Holes                                                            |

## Translations

Contribute to the translation of this game via [Weblate](https://hosted.weblate.org/projects/tessel/).

## Development

[![GitHub Version](https://img.shields.io/github/v/release/gvtulder/tessel.svg?logo=github&label=GitHub)](https://github.com/gvtulder/tessel/releases)
[![F-Droid Version](https://img.shields.io/f-droid/v/net.vantulder.tessel.svg?logo=f-droid&label=F-Droid)](https://f-droid.org/packages/net.vantulder.tessel/)
[![Google Play Version](https://img.shields.io/endpoint?logo=google-play&color=blue&url=https%3A%2F%2Fplay.cuzi.workers.dev%2Fplay%3Fi%3Dnet.vantulder.tessel%26gl%3DUS%26hl%3Den%26l%3DAndroid%26m%3Dv%24version)](https://play.google.com/store/apps/details?id=net.vantulder.tessel)
[![iOS Version](https://img.shields.io/itunes/v/6754282700?logo=Apple&label=iOS)](https://apps.apple.com/app/tessel/id6754282700)
[![Web Version](https://play.tessel.at/badge.svg)](https://play.tessel.at/)

Tessel is written in TypeScript and uses HTML, SVG and CSS. It can be built using a recent Node version (tested for 20+). It can be played directly in the browser or installed as a Progressive Web App.

### Building for web / PWA

The plain HTML/JS/CSS version can be built using [Parcel](https://parceljs.org/).

```
# install dependencies
npm ci
# run all tests
npm run test
# run a local development server
npm run serve
# or build JavaScript and HTML in dist/
npm run build
```

### Building for Android

An Android application can be built with [Capacitor](https://capacitorjs.com/). In addition to the standard Node/NPM dependencies, Capacitor requires the Android SDK. [See the instructions on the Capacitor website.](https://capacitorjs.com/docs/getting-started/environment-setup#android-requirements)

```
# install dependencies
npm ci
# build Capacitor-ready JavaScript and HTML in dist-capacitor/
npm run build-cap-html
# build and run in the Android emulator
npx cap run android
# or build the Android app for release
npx cap build android --androidreleasetype APK --signing-type apksigner
# (this will ask for the parameters to your signing keys)
```

## License

Copyright © 2025 by [Gijs van Tulder](https://www.vantulder.net/).

The source code of this game is licensed under the [GPL-3.0 license](LICENSE.md).
