declare module "poly-decomp-es" {
    export type Point = [number, number];
    export type Polygon = Point[];
    export function makeCCW(polygon: Polygon): boolean;
    export function decomp(polygon: Polygon): Polygon[] | false;
    export function isSimple(polygon: Polygon): boolean;
    export function quickDecomp(polygon: Polygon, result?: Polygon[], reflexVertices?: Point[], steinerPoints?: Point[], delta?: number, maxlevel?: number, level?: number): Polygon[];
    export function removeCollinearPoints(polygon: Polygon, thresholdAngle?: number): number;
    export function removeDuplicatePoints(polygon: Polygon, precision?: number): void;
}
