"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Config = void 0;
var _logger = require("@parcel/logger");
var _path = _interopRequireDefault(require("path"));
var _fs = _interopRequireDefault(require("fs"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var PACKAGE_JSON_SECTION = "parcel-namer-rewrite";
var Config = exports.Config = /*#__PURE__*/function () {
  function Config() {
    _classCallCheck(this, Config);
    _defineProperty(this, "profileEnvKeyDeprecated", 'PARCEL-NAMER-REWRITE-PROFILE');
    _defineProperty(this, "profileEnvKey", 'PARCEL_NAMER_REWRITE_PROFILE');
    _defineProperty(this, "rules", void 0);
    _defineProperty(this, "chain", void 0);
    /**
     * Disable in development
     */
    _defineProperty(this, "disable", false);
    /**
     * Name hashing
     */
    _defineProperty(this, "hashing", '');
    // "never", "always"
    /**
     * Disable logging names
     */
    _defineProperty(this, "silent", false);
    /**
     * Use file name hashes from parcel
     */
    _defineProperty(this, "useParcelHash", true);
    /**
     * The targets that the namer will not apply to
     */
    _defineProperty(this, "skipTargets", []);
    this.rules = [];
    this.chain = '@parcel/namer-default';
  }
  _createClass(Config, [{
    key: "loadFromPackageFolder",
    value: function loadFromPackageFolder(rootFolder, env, defaultProfiles, logger) {
      var _this = this;
      var packageJson = _fs["default"].readFileSync(_path["default"].join(rootFolder, 'package.json')).toString();
      var packageInfo = JSON.parse(packageJson);
      var packageSection = packageInfo[PACKAGE_JSON_SECTION];
      if (!packageSection) {
        logger.warn({
          message: "no \"".concat(PACKAGE_JSON_SECTION, "\" section in package.json. Use no-rules config")
        });
        return;
      }
      this._loadFromPackageSection(packageSection, logger);
      var profileNames = '';
      if (defaultProfiles) profileNames += ',' + defaultProfiles;
      if (this.profileEnvKeyDeprecated in env) {
        logger.warn({
          message: "You are using deprecated environment variable ".concat(this.profileEnvKeyDeprecated, ". Consider switch to ").concat(this.profileEnvKey)
        });
        profileNames += ',' + env[this.profileEnvKeyDeprecated];
      }
      if (this.profileEnvKey in env) profileNames += ',' + env[this.profileEnvKey];
      var profileSections = packageSection['profiles'];
      if (profileSections) {
        profileNames.split(/[,]/).map(function (profile) {
          return profileSections[profile];
        }).filter(function (profile) {
          return !!profile;
        }).forEach(function (profile) {
          _this._loadFromPackageSection(profile, logger);
        });
      }
    }
  }, {
    key: "_loadFromPackageSection",
    value: function _loadFromPackageSection(section, logger) {
      var _this2 = this;
      if (!section) return;
      if ('profile-env-key' in section) {
        this.profileEnvKey = section['profile-env-key'];
      }
      if ('chain' in section) {
        this.chain = section.chain;
      }
      if ('neverHashing' in section) {
        this.neverHashing = !!section.neverHashing;
      }
      this.silent = 'silent' in section && section.silent;
      if ('useParcelHash' in section) {
        this.useParcelHash = !!section.useParcelHash;
      }
      if ('rules' in section) {
        Object.keys(section.rules).forEach(function (k) {
          var ruleData = section.rules[k];
          var ruleTo = typeof ruleData === 'string' ? ruleData : null;
          if (ruleTo === null) {
            logger.warn("No \"to\" rule for test \"".concat(k, "\" "));
            return;
          }
          _this2.rules.push({
            test: new RegExp(k),
            to: ruleTo
          });
        });
      }
      if ('developmentHashing' in section) {
        throw Error("The \"developmentHashing\" option is not supported any more. Add \"development\" profile and set {\"hashing\": \"never\"} there. See documentation for details here: https://github.com/ol-loginov/parcel-namer-rewrite");
      }
      if ('developmentDisable' in section) {
        throw Error("The \"developmentDisable\" option is not supported any more. Add \"development\" profile and set {\"disable\": false} there. See documentation for details here: https://github.com/ol-loginov/parcel-namer-rewrite");
      }
      if ('hashing' in section) {
        this.hashing = section['hashing'];
      }
      if ('disable' in section) {
        this.disable = !!section['disable'];
      }
      if ('skipTargets' in section) {
        this.skipTargets = section['skipTargets'];
      }
    }
  }, {
    key: "selectRule",
    value: function selectRule(name) {
      var matches = this.rules.map(function (rule) {
        return rule.test.test(name) ? rule : null;
      }).filter(function (rule) {
        return rule != null;
      });
      if (matches.length > 0) {
        return matches[0];
      }
      return null;
    }
  }]);
  return Config;
}();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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