"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rule = exports.name = void 0;
const utils_1 = require("@typescript-eslint/utils");
const helpers_1 = require("../helpers");
const create_rule_1 = require("../create-rule");
exports.name = 'text-restrictions';
exports.rule = (0, create_rule_1.createRule)({
    name: exports.name,
    meta: {
        docs: {
            description: 'Text restrictions',
            recommended: 'error',
        },
        messages: {
            default: '{{ message }}',
        },
        schema: [
            {
                type: 'object',
                properties: {
                    rules: {
                        type: 'array',
                        items: {
                            type: 'object',
                            properties: {
                                patterns: {
                                    type: 'array',
                                    items: {
                                        type: 'string',
                                    },
                                },
                                flags: {
                                    type: 'string',
                                },
                                message: {
                                    type: 'string',
                                },
                            },
                        },
                    },
                },
                additionalProperties: false,
            },
        ],
        type: 'problem',
    },
    defaultOptions: [],
    create: function (context) {
        var _a;
        const { options: [option], } = context;
        if (!((_a = option === null || option === void 0 ? void 0 : option.rules) === null || _a === void 0 ? void 0 : _a.length)) {
            return {};
        }
        const { rules } = option;
        const rulePatterns = rules.map(({ patterns, message, flags }) => ({
            patterns: patterns.map((item) => new RegExp(item, flags)),
            message,
        }));
        return {
            [`${helpers_1.LinguiTaggedTemplateExpressionMessageQuery}, ${helpers_1.LinguiCallExpressionMessageQuery}, ${helpers_1.LinguiTransQuery} JSXText`](node) {
                const text = (0, helpers_1.getText)(node, node.type === utils_1.TSESTree.AST_NODE_TYPES.JSXText);
                rulePatterns.forEach(({ patterns, message }) => {
                    if (patterns.some((item) => item.test(text))) {
                        context.report({ node, messageId: 'default', data: { message: message } });
                    }
                });
                return;
            },
        };
    },
});
//# sourceMappingURL=text-restrictions.js.map