"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rule = exports.name = exports.hasAncestorScope = void 0;
const create_rule_1 = require("../create-rule");
function hasAncestorScope(node, types) {
    let current = node;
    while (current) {
        if (types.includes(current.type)) {
            return true;
        }
        current = current.upper;
    }
    return false;
}
exports.hasAncestorScope = hasAncestorScope;
exports.name = 't-call-in-function';
exports.rule = (0, create_rule_1.createRule)({
    name: exports.name,
    meta: {
        docs: {
            description: 'allow t call only inside functions',
            recommended: 'error',
        },
        messages: {
            default: 't`` and t() call should be inside function',
        },
        schema: [
            {
                type: 'object',
                properties: {},
                additionalProperties: false,
            },
        ],
        type: 'problem',
    },
    defaultOptions: [],
    create: (context) => {
        var _a;
        const sourceCode = (_a = context.sourceCode) !== null && _a !== void 0 ? _a : context.getSourceCode();
        return {
            'TaggedTemplateExpression[tag.name=t], CallExpression[callee.name=t]'(node) {
                const scope = sourceCode.getScope
                    ? // available from ESLint v8.37.0
                        sourceCode.getScope(node)
                    : // deprecated and remove in V9
                        context.getScope();
                if (!hasAncestorScope(scope, ['function', 'class-field-initializer'])) {
                    context.report({
                        node,
                        messageId: 'default',
                    });
                }
            },
        };
    },
});
//# sourceMappingURL=t-call-in-function.js.map