import * as noUnlocalizedStringsRule from './rules/no-unlocalized-strings';
import * as textRestrictionsRule from './rules/text-restrictions';
import { ESLint, Linter } from 'eslint';
import { FlatConfig, RuleModule } from '@typescript-eslint/utils/ts-eslint';
declare const plugin: {
    meta: {
        name: string;
    };
    configs: {
        recommended: ESLint.ConfigData;
        'flat/recommended': Linter.FlatConfig;
    };
    rules: {
        "no-expression-in-message": RuleModule<"default" | "multiplePlaceholders", any[], import("./create-rule").ExtraRuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-unlocalized-strings": RuleModule<string, noUnlocalizedStringsRule.Option[], import("./create-rule").ExtraRuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-single-tag-to-translate": RuleModule<"default", any[], import("./create-rule").ExtraRuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-single-variables-to-translate": RuleModule<"asJsx" | "asFunction", any[], import("./create-rule").ExtraRuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "t-call-in-function": RuleModule<"default", any[], import("./create-rule").ExtraRuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "text-restrictions": RuleModule<string, textRestrictionsRule.Option[], import("./create-rule").ExtraRuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "no-trans-inside-trans": RuleModule<"default", any[], import("./create-rule").ExtraRuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
        "consistent-plural-format": RuleModule<"hashRequired" | "templateRequired", [{
            style?: "template" | "hash";
        }], import("./create-rule").ExtraRuleDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener>;
    };
};
export = plugin;
