"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const worker_1 = require("threads/worker");
const compileLocale_1 = require("../api/compile/compileLocale");
const conf_1 = require("@lingui/conf");
const workerLogger_1 = require("../api/workerLogger");
const ProgramExit_1 = require("../api/ProgramExit");
const getCatalogs_1 = require("../api/catalog/getCatalogs");
let linguiConfig;
let catalogs;
const compileWorker = {
    compileLocale: async (locale, options, doMerge, linguiConfigPath) => {
        if (!linguiConfig) {
            // initialize config once per worker, speed up workers follow execution
            linguiConfig = (0, conf_1.getConfig)({
                configPath: linguiConfigPath,
                skipValidation: true,
            });
        }
        if (!catalogs) {
            // catalogs holds path to the files and message catalogs, so it's kinda configuration object
            // it depends only on the config, so we can initialize it once per program execution
            catalogs = await (0, getCatalogs_1.getCatalogs)(linguiConfig);
        }
        const logger = new workerLogger_1.WorkerLogger();
        try {
            await (0, compileLocale_1.compileLocale)(catalogs, locale, options, linguiConfig, doMerge, logger);
        }
        catch (error) {
            return {
                logs: logger.flush(),
                error,
                exitProgram: error instanceof ProgramExit_1.ProgramExit,
            };
        }
        return { logs: logger.flush() };
    },
};
(0, worker_1.expose)(compileWorker);
