"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveWorkersOptions = resolveWorkersOptions;
const node_os_1 = __importDefault(require("node:os"));
function resolveWorkersOptions(opts) {
    const cores = node_os_1.default.availableParallelism();
    if (Number(opts.workers) <= 1 || cores === 1) {
        return { poolSize: 0 };
    }
    if (!opts.workers) {
        if (cores <= 2) {
            return { poolSize: cores }; // on tiny machines, use all
        }
        // on big machines cap to 8, to avoid trashing
        return { poolSize: Math.min(cores - 1, 8) };
    }
    return { poolSize: Number(opts.workers) };
}
