"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCompiledCatalog = createCompiledCatalog;
exports.compile = compile;
const t = __importStar(require("@babel/types"));
const generator_1 = __importDefault(require("@babel/generator"));
const compileMessage_1 = require("@lingui/message-utils/compileMessage");
const pseudoLocalize_1 = __importDefault(require("./pseudoLocalize"));
function createCompiledCatalog(locale, messages, options) {
    const { strict = false, namespace = "cjs", pseudoLocale, compilerBabelOptions = {}, outputPrefix = "/*eslint-disable*/", } = options;
    const shouldPseudolocalize = locale === pseudoLocale;
    const errors = [];
    const compiledMessages = Object.keys(messages)
        .sort()
        .reduce((obj, key) => {
        // Don't use `key` as a fallback translation in strict mode.
        const translation = (messages[key] || (!strict ? key : ""));
        try {
            obj[key] = compile(translation, shouldPseudolocalize);
        }
        catch (e) {
            errors.push({
                id: key,
                source: translation,
                error: e,
            });
        }
        return obj;
    }, {});
    if (namespace === "json") {
        return { source: JSON.stringify({ messages: compiledMessages }), errors };
    }
    const ast = buildExportStatement(
    //build JSON.parse(<compiledMessages>) statement
    t.callExpression(t.memberExpression(t.identifier("JSON"), t.identifier("parse")), [t.stringLiteral(JSON.stringify(compiledMessages))]), namespace);
    const code = (0, generator_1.default)(ast, Object.assign({ minified: true, jsescOption: {
            minimal: true,
        } }, compilerBabelOptions)).code;
    return { source: `${outputPrefix}` + code, errors };
}
function buildExportStatement(expression, namespace) {
    if (namespace === "ts") {
        // import type { Messages } from "@lingui/core";
        const importMessagesTypeDeclaration = t.importDeclaration([t.importSpecifier(t.identifier("Messages"), t.identifier("Messages"))], t.stringLiteral("@lingui/core"));
        importMessagesTypeDeclaration.importKind = "type";
        // Cast the expression to `Messages`
        const castExpression = t.tsAsExpression(expression, t.tsTypeReference(t.identifier("Messages")));
        // export const messages = ({ message: "Translation" } as Messages)
        const exportDeclaration = t.exportNamedDeclaration(t.variableDeclaration("const", [
            t.variableDeclarator(t.identifier("messages"), castExpression),
        ]));
        return t.program([importMessagesTypeDeclaration, exportDeclaration]);
    }
    else if (namespace === "es") {
        // export const messages = { message: "Translation" }
        return t.exportNamedDeclaration(t.variableDeclaration("const", [
            t.variableDeclarator(t.identifier("messages"), expression),
        ]));
    }
    else {
        let exportExpression = null;
        const matches = namespace.match(/^(window|global)\.([^.\s]+)$/);
        if (namespace === "cjs") {
            // module.exports.messages = { message: "Translation" }
            exportExpression = t.memberExpression(t.identifier("module"), t.identifier("exports"));
        }
        else if (matches) {
            // window.i18nMessages = { messages: { message: "Translation" }}
            exportExpression = t.memberExpression(t.identifier(matches[1]), t.identifier(matches[2]));
        }
        else {
            throw new Error(`Invalid namespace param: "${namespace}"`);
        }
        return t.expressionStatement(t.assignmentExpression("=", exportExpression, t.objectExpression([
            t.objectProperty(t.identifier("messages"), expression),
        ])));
    }
}
/**
 * Compile string message into AST tree. Message format is parsed/compiled into
 * JS arrays, which are handled in client.
 */
function compile(message, shouldPseudolocalize = false) {
    return (0, compileMessage_1.compileMessageOrThrow)(message, (value) => shouldPseudolocalize ? (0, pseudoLocalize_1.default)(value) : value);
}
