import { GeneratorOptions } from "@babel/generator";
import { CompiledMessage } from "@lingui/message-utils/compileMessage";
export type CompiledCatalogNamespace = "cjs" | "es" | "ts" | "json" | string;
type CompiledCatalogType = {
    [msgId: string]: string;
};
export type CreateCompileCatalogOptions = {
    strict?: boolean;
    namespace?: CompiledCatalogNamespace;
    pseudoLocale?: string;
    compilerBabelOptions?: GeneratorOptions;
    outputPrefix?: string;
};
export type MessageCompilationError = {
    /**
     * ID of the message in the Catalog
     */
    id: string;
    /**
     * Message itself
     */
    source: string;
    /**
     * Error associated with this message
     */
    error: Error;
};
export declare function createCompiledCatalog(locale: string, messages: CompiledCatalogType, options: CreateCompileCatalogOptions): {
    source: string;
    errors: MessageCompilationError[];
};
/**
 * Compile string message into AST tree. Message format is parsed/compiled into
 * JS arrays, which are handled in client.
 */
export declare function compile(message: string, shouldPseudolocalize?: boolean): CompiledMessage;
export {};
