package net.turtton.ytalarm.database.dao

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Transaction
import androidx.room.Update
import kotlinx.coroutines.flow.Flow
import net.turtton.ytalarm.database.structure.Alarm

@Dao
interface AlarmDao {
    @Query("SELECT * FROM alarms")
    fun getAll(): Flow<List<Alarm>>

    @Query("SELECT * FROM alarms")
    suspend fun getAllSync(): List<Alarm>

    @Query("SELECT * FROM alarms WHERE id = :id")
    suspend fun getFromIdSync(id: Long): Alarm?

    @Query("SELECT * FROM alarms WHERE repeatType = :repeatType")
    suspend fun getMatchedSync(repeatType: Alarm.RepeatType): List<Alarm>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(alarm: Alarm): Long

    @Update
    suspend fun update(alarm: Alarm)

    @Delete
    suspend fun delete(alarm: Alarm)

    @Transaction
    @Query("DELETE FROM alarms")
    suspend fun deleteAll()
}