/*
 * This file is part of GNU Taler
 * (C) 2024 Taler Systems S.A.
 *
 * GNU Taler is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3, or (at your option) any later version.
 *
 * GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

package net.taler.wallet.compose

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Button
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp

@Composable
fun BottomButtonBox(
    modifier: Modifier = Modifier,
    heading: (@Composable ColumnScope.() -> Unit)? = null,
    leading: (@Composable () -> Unit)? = null,
    trailing: (@Composable () -> Unit)? = null,
) {
    Column(modifier = modifier
        .background(MaterialTheme.colorScheme.surfaceContainerHigh)
        .padding(12.dp),
        horizontalAlignment = Alignment.End,
    ) {
        if (heading != null) {
            Column(
                modifier = Modifier.padding(bottom = 6.dp),
                horizontalAlignment = Alignment.End,
                content = heading,
            )
        }

        Row(verticalAlignment = Alignment.Bottom) {
            leading?.let {
                Box(
                    modifier = Modifier.weight(1f),
                    contentAlignment = Alignment.CenterStart,
                ) { it() }
            }

            trailing?.let {
                Box(
                    modifier = Modifier.weight(1f),
                    contentAlignment = Alignment.CenterEnd,
                ) { it() }
            }
        }
    }
}

@Preview
@Composable
fun BottomButtonBoxPreview() {
    TalerSurface {
        Column {
            Spacer(Modifier.height(100.dp))

            BottomButtonBox(
                modifier = Modifier.fillMaxWidth(),
                heading = {
                    Text("Something, something")
                },
                leading = {
                    Button(onClick = {}) {
                        Text("Back")
                    }
                },
                trailing = {
                    Button(onClick = {}) {
                        Text("Continue")
                    }
                }
            )
        }
    }
}