package net.retiolus.osm2gmaps.utils.maps.converters

import java.math.BigDecimal
import org.junit.Assert.assertEquals
import org.junit.Test

class OrganicMapsConverterTest {

    @Test
    fun extractsComapsShortCodeFromDeepLink() {
        val code = getComapsShortCode("cm://o4B4pYZsRs/Zoo_Zurich")
        assertEquals("o4B4pYZsRs", code)
    }

    @Test
    fun ignoresMapPathWhenLookingForShortCode() {
        val code = getComapsShortCode("https://comaps.at/map?v=1&ll=22.17319,-159.65687")
        assertEquals("", code)
    }

    @Test
    fun buildsComapsMapLink() {
        val link = createComapsLink(BigDecimal("22.17319"), BigDecimal("-159.65687"), java.math.BigInteger.ONE)
        assertEquals("https://comaps.at/map?v=1&ll=22.17319,-159.65687", link)
    }
}
