package net.retiolus.osm2gmaps.utils.maps

import org.junit.Assert.assertEquals
import org.junit.Test

class MapUtilsTest {

    @Test
    fun extractsDecimalDegreesWithDegreeSymbols() {
        val coordinates = extractCoordinates("27.712° -5°") ?: error("Coordinates not parsed")
        assertEquals(27.712, coordinates.first, 0.0000001)
        assertEquals(-5.0, coordinates.second, 0.0000001)
    }

    @Test
    fun extractsDecimalDegreesWithLeadingPlus() {
        val coordinates = extractCoordinates("+27.712° -5°") ?: error("Coordinates not parsed")
        assertEquals(27.712, coordinates.first, 0.0000001)
        assertEquals(-5.0, coordinates.second, 0.0000001)
    }

    @Test
    fun extractsDmsCoordinates() {
        val coordinates = extractCoordinates("40°26'46\"N 79°58'56\"W") ?: error("Coordinates not parsed")
        assertEquals(40.446111, coordinates.first, 0.000001)
        assertEquals(-79.982222, coordinates.second, 0.000001)
    }
}
