import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/shared/data_sources/source_spec.dart';

void main() {
  group('SourceSpec', () {
    const specJson = '''
    {
      "sources": [
        {
          "id": "api",
          "dataset": "natinf",
          "name": "Infractions NATINFo",
          "type": "api",
          "uri": "https://example.com",
          "scope": "natinf",
          "priority": 1,
          "requiredAtBuild": false,
          "requiresNetwork": true,
          "schemaVersion": 1,
          "license": "Licence Ouverte 2.0",
          "checksum": null,
          "checksumAlgo": null
        },
        {
          "id": "asset",
          "dataset": "natinf",
          "name": "Infractions NATINFo",
          "type": "asset",
          "uri": "asset://natinf.json",
          "scope": "natinf",
          "priority": 2,
          "requiredAtBuild": false,
          "requiresNetwork": false,
          "schemaVersion": 1,
          "checksum": null,
          "checksumAlgo": null
        }
      ]
    }
''';

    test('parses list from JSON string', () {
      final specs = SourceSpec.listFromJsonString(specJson);
      expect(specs, hasLength(2));
      expect(specs.first.type, SourceType.api);
      expect(specs.first.name, 'Infractions NATINFo');
      expect(specs.first.license, 'Licence Ouverte 2.0');
      expect(specs.last.requiresNetwork, isFalse);
      expect(specs.first.uri.toString(), 'https://example.com');
    });

    test('throws for missing required fields', () {
      const invalidJson = '''
      { "sources": [ { "id": "missing-fields" } ] }
      ''';
      expect(
        () => SourceSpec.listFromJsonString(invalidJson),
        throwsFormatException,
      );
    });
  });
}
