import 'package:flutter/widgets.dart';

/// Adds a `safeSetState` helper that silently no-ops when the [State] has
/// already been unmounted, preventing `setState` exceptions from async work.
mixin MountedSetStateMixin<T extends StatefulWidget> on State<T> {
  /// Calls [setState] only when the widget is still mounted.
  @protected
  void safeSetState(VoidCallback fn) {
    if (!mounted) return;
    setState(fn);
  }
}
