import 'package:flutter/material.dart';
import 'package:qr_flutter/qr_flutter.dart';

class NatinfShareDialog extends StatelessWidget {
  final String numero;
  final String url;
  final Future<void> Function() onCopyLink;

  const NatinfShareDialog({
    super.key,
    required this.numero,
    required this.url,
    required this.onCopyLink,
  });

  @override
  Widget build(BuildContext context) {
    final theme = Theme.of(context);
    return AlertDialog(
      title: Text('Partager NATINF $numero'),
      content: Column(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          DecoratedBox(
            decoration: BoxDecoration(
              color: theme.colorScheme.surface,
              borderRadius: BorderRadius.circular(12),
            ),
            child: Padding(
              padding: const EdgeInsets.all(12),
              child: SizedBox(
                width: 180,
                height: 180,
                child: QrImageView(
                  data: url,
                  version: QrVersions.auto,
                  backgroundColor: Colors.white,
                ),
              ),
            ),
          ),
          const SizedBox(height: 16),
          SelectableText(url, textAlign: TextAlign.center),
        ],
      ),
      actions: [
        TextButton(
          onPressed: () => Navigator.of(context).pop(),
          child: const Text('Fermer'),
        ),
        TextButton.icon(
          onPressed: () async {
            await onCopyLink();
          },
          icon: const Icon(Icons.copy),
          label: const Text('Copier le lien'),
        ),
      ],
    );
  }
}
