/// Types of failures encountered while downloading the initial NATINF dataset.
enum NatinfDownloadIssueType { network, parsing, storage, unknown }

/// Error surfaced when the initial dataset download fails in a diagnosable way.
class NatinfDownloadException implements Exception {
  const NatinfDownloadException({
    required this.type,
    required this.message,
    this.cause,
    this.stackTrace,
  });

  /// High-level failure category (network, parsing, storage…).
  final NatinfDownloadIssueType type;

  /// Human-readable description of what went wrong.
  final String message;

  /// Optional underlying error.
  final Object? cause;

  /// Optional stack trace associated with [cause].
  final StackTrace? stackTrace;

  @override
  String toString() {
    final buffer = StringBuffer('NatinfDownloadException(${type.name}): ');
    buffer.write(message);
    if (cause != null) {
      buffer.write(' (cause: $cause)');
    }
    return buffer.toString();
  }
}
