// ignore_for_file: type=lint

import 'package:json_annotation/json_annotation.dart';
import 'package:json_annotation/json_annotation.dart' as json;
import 'package:collection/collection.dart';
import 'dart:convert';

import 'package:chopper/chopper.dart';

import 'client_mapping.dart';
import 'dart:async';
import 'package:http/http.dart' as http;
import 'package:http/http.dart' show MultipartFile;
import 'package:chopper/chopper.dart' as chopper;
import 'swagger.enums.swagger.dart' as enums;
export 'swagger.enums.swagger.dart';

part 'swagger.swagger.chopper.dart';
part 'swagger.swagger.g.dart';

// **************************************************************************
// SwaggerChopperGenerator
// **************************************************************************

@ChopperApi()
abstract class Swagger extends ChopperService {
  static Swagger create({
    ChopperClient? client,
    http.Client? httpClient,
    Authenticator? authenticator,
    ErrorConverter? errorConverter,
    Converter? converter,
    Uri? baseUrl,
    List<Interceptor>? interceptors,
  }) {
    if (client != null) {
      return _$Swagger(client);
    }

    final newClient = ChopperClient(
      services: [_$Swagger()],
      converter: converter ?? $JsonSerializableConverter(),
      interceptors: interceptors ?? [],
      client: httpClient,
      authenticator: authenticator,
      errorConverter: errorConverter,
      baseUrl: baseUrl ?? Uri.parse('https://natinfo.app/api'),
    );
    return _$Swagger(newClient);
  }

  ///Obtenir un couple access/refresh JWT.
  ///@param data
  Future<chopper.Response<APITokenObtainPair>> authLoginPost({
    required APITokenObtainPair? data,
  }) {
    generatedMapping.putIfAbsent(
      APITokenObtainPair,
      () => APITokenObtainPair.fromJsonFactory,
    );

    return _authLoginPost(data: data);
  }

  ///Obtenir un couple access/refresh JWT.
  ///@param data
  @POST(path: '/auth/login/')
  Future<chopper.Response<APITokenObtainPair>> _authLoginPost({
    @Body() required APITokenObtainPair? data,
  });

  ///Révoquer le refresh token courant côté serveur.
  Future<chopper.Response> authLogoutPost() {
    return _authLogoutPost();
  }

  ///Révoquer le refresh token courant côté serveur.
  @POST(path: '/auth/logout/', optionalBody: true)
  Future<chopper.Response> _authLogoutPost();

  ///Obtenir les informations du compte authentifié.
  Future<chopper.Response<AuthMe>> authMeGet() {
    generatedMapping.putIfAbsent(AuthMe, () => AuthMe.fromJsonFactory);

    return _authMeGet();
  }

  ///Obtenir les informations du compte authentifié.
  @GET(path: '/auth/me/')
  Future<chopper.Response<AuthMe>> _authMeGet();

  ///Renouveler un access token avec un refresh JWT.
  ///@param data
  Future<chopper.Response<APITokenRefresh>> authRefreshPost({
    required APITokenRefresh? data,
  }) {
    generatedMapping.putIfAbsent(
      APITokenRefresh,
      () => APITokenRefresh.fromJsonFactory,
    );

    return _authRefreshPost(data: data);
  }

  ///Renouveler un access token avec un refresh JWT.
  ///@param data
  @POST(path: '/auth/refresh/')
  Future<chopper.Response<APITokenRefresh>> _authRefreshPost({
    @Body() required APITokenRefresh? data,
  });

  ///Lister toutes les catégories de classement NATINF.
  Future<chopper.Response<List<Category>>> categoriesGet() {
    generatedMapping.putIfAbsent(Category, () => Category.fromJsonFactory);

    return _categoriesGet();
  }

  ///Lister toutes les catégories de classement NATINF.
  @GET(path: '/categories/')
  Future<chopper.Response<List<Category>>> _categoriesGet();

  ///Consulter le détail d'une catégorie et ses NATINF associés.
  Future<chopper.Response<Category>> categoriesCategoryIdGet({
    required String? categoryId,
  }) {
    generatedMapping.putIfAbsent(Category, () => Category.fromJsonFactory);

    return _categoriesCategoryIdGet(categoryId: categoryId);
  }

  ///Consulter le détail d'une catégorie et ses NATINF associés.
  @GET(path: '/categories/{category_id}/')
  Future<chopper.Response<Category>> _categoriesCategoryIdGet({
    @Path('category_id') required String? categoryId,
  });

  ///Obtenir le contenu détaillé d'un article Legifrance par identifiant.
  ///@param article_id Unique identifier of the Legifrance article.
  Future<chopper.Response<LegifranceArticleGet$Response>> legifranceArticleGet({
    String? articleId,
  }) {
    generatedMapping.putIfAbsent(
      LegifranceArticleGet$Response,
      () => LegifranceArticleGet$Response.fromJsonFactory,
    );

    return _legifranceArticleGet(articleId: articleId);
  }

  ///Obtenir le contenu détaillé d'un article Legifrance par identifiant.
  ///@param article_id Unique identifier of the Legifrance article.
  @GET(path: '/legifrance/article/')
  Future<chopper.Response<LegifranceArticleGet$Response>>
  _legifranceArticleGet({@Query('article_id') String? articleId});

  ///Obtenir un article précis via son identifiant de texte et son numéro.
  ///@param id Identifier of the text containing the article.
  ///@param num Article number within the text.
  Future<chopper.Response<Object>> legifranceConsultGetArticleWithIdAndNumGet({
    String? id,
    String? $num,
  }) {
    return _legifranceConsultGetArticleWithIdAndNumGet(id: id, $num: $num);
  }

  ///Obtenir un article précis via son identifiant de texte et son numéro.
  ///@param id Identifier of the text containing the article.
  ///@param num Article number within the text.
  @GET(path: '/legifrance/consult/getArticleWithIdAndNum')
  Future<chopper.Response<Object>> _legifranceConsultGetArticleWithIdAndNumGet({
    @Query('id') String? id,
    @Query('num') String? $num,
  });

  ///Rechercher une loi ou un décret dans Legifrance.
  ///@param searched_string String to search for.
  ///@param date Reference date (timestamp).
  ///@param text_id Identifier of the text to search in.
  Future<chopper.Response<Object>> legifranceConsultLawDecreeGet({
    String? searchedString,
    String? date,
    String? textId,
  }) {
    return _legifranceConsultLawDecreeGet(
      searchedString: searchedString,
      date: date,
      textId: textId,
    );
  }

  ///Rechercher une loi ou un décret dans Legifrance.
  ///@param searched_string String to search for.
  ///@param date Reference date (timestamp).
  ///@param text_id Identifier of the text to search in.
  @GET(path: '/legifrance/consult/lawDecree')
  Future<chopper.Response<Object>> _legifranceConsultLawDecreeGet({
    @Query('searched_string') String? searchedString,
    @Query('date') String? date,
    @Query('text_id') String? textId,
  });

  ///Obtenir l'identifiant Legifrance associé à un article.
  ///@param article_number The number of the legal article to look up.
  ///@param code_name The code name where the article is defined.
  Future<chopper.Response<LegifranceIdGet$Response>> legifranceIdGet({
    String? articleNumber,
    String? codeName,
  }) {
    generatedMapping.putIfAbsent(
      LegifranceIdGet$Response,
      () => LegifranceIdGet$Response.fromJsonFactory,
    );

    return _legifranceIdGet(articleNumber: articleNumber, codeName: codeName);
  }

  ///Obtenir l'identifiant Legifrance associé à un article.
  ///@param article_number The number of the legal article to look up.
  ///@param code_name The code name where the article is defined.
  @GET(path: '/legifrance/id/')
  Future<chopper.Response<LegifranceIdGet$Response>> _legifranceIdGet({
    @Query('article_number') String? articleNumber,
    @Query('code_name') String? codeName,
  });

  ///Lister les codes juridiques exposés par Legifrance.
  Future<chopper.Response<Object>> legifranceListCodeGet() {
    return _legifranceListCodeGet();
  }

  ///Lister les codes juridiques exposés par Legifrance.
  @GET(path: '/legifrance/list/code')
  Future<chopper.Response<Object>> _legifranceListCodeGet();

  ///Proposer des suggestions d'articles Legifrance pour un texte donné.
  ///@param search_text Query for suggestion results.
  Future<chopper.Response<List<dynamic>>> legifranceSuggestGet({
    String? searchText,
  }) {
    return _legifranceSuggestGet(searchText: searchText);
  }

  ///Proposer des suggestions d'articles Legifrance pour un texte donné.
  ///@param search_text Query for suggestion results.
  @GET(path: '/legifrance/suggest/')
  Future<chopper.Response<List<dynamic>>> _legifranceSuggestGet({
    @Query('search_text') String? searchText,
  });

  ///Lister toutes les fiches NATINF publiques.
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour choisir une version officielle.
  Future<chopper.Response<List<Natinf>>> natinfoGet({String? referenceDate}) {
    generatedMapping.putIfAbsent(Natinf, () => Natinf.fromJsonFactory);

    return _natinfoGet(referenceDate: referenceDate);
  }

  ///Lister toutes les fiches NATINF publiques.
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour choisir une version officielle.
  @GET(path: '/natinfo/')
  Future<chopper.Response<List<Natinf>>> _natinfoGet({
    @Query('reference_date') String? referenceDate,
  });

  ///Proposer des suggestions de recherche NATINF.
  ///@param q Search prefix for autocomplete
  Future<chopper.Response> natinfoAutocompleteGet({String? q}) {
    return _natinfoAutocompleteGet(q: q);
  }

  ///Proposer des suggestions de recherche NATINF.
  ///@param q Search prefix for autocomplete
  @GET(path: '/natinfo/autocomplete/')
  Future<chopper.Response> _natinfoAutocompleteGet({@Query('q') String? q});

  ///Accéder aux documents professionnels associés à un NATINF.
  ///@param numero_natinf Unique NATINF number.
  Future<chopper.Response<List<NatinfDocPro>>> natinfoDocProGet({
    required String? numeroNatinf,
  }) {
    generatedMapping.putIfAbsent(
      NatinfDocPro,
      () => NatinfDocPro.fromJsonFactory,
    );

    return _natinfoDocProGet(numeroNatinf: numeroNatinf);
  }

  ///Accéder aux documents professionnels associés à un NATINF.
  ///@param numero_natinf Unique NATINF number.
  @GET(path: '/natinfo/doc-pro/')
  Future<chopper.Response<List<NatinfDocPro>>> _natinfoDocProGet({
    @Query('numero_natinf') required String? numeroNatinf,
  });

  ///Mettre à jour ou enrichir une fiche NATINF existante.
  ///@param data
  Future<chopper.Response<Natinf>> natinfoNatinfEditPost({
    required NatinfUpdate? data,
  }) {
    generatedMapping.putIfAbsent(
      NatinfUpdate,
      () => NatinfUpdate.fromJsonFactory,
    );
    generatedMapping.putIfAbsent(Natinf, () => Natinf.fromJsonFactory);

    return _natinfoNatinfEditPost(data: data);
  }

  ///Mettre à jour ou enrichir une fiche NATINF existante.
  ///@param data
  @POST(path: '/natinfo/natinf/edit/')
  Future<chopper.Response<Natinf>> _natinfoNatinfEditPost({
    @Body() required NatinfUpdate? data,
  });

  ///Extraire les articles juridiques référencés par un NATINF.
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour sélectionner une version officielle.
  Future<chopper.Response<NatinfoNatinfNumeroNatinfArticlesGet$Response>>
  natinfoNatinfNumeroNatinfArticlesGet({
    String? referenceDate,
    required String? numeroNatinf,
  }) {
    generatedMapping.putIfAbsent(
      NatinfoNatinfNumeroNatinfArticlesGet$Response,
      () => NatinfoNatinfNumeroNatinfArticlesGet$Response.fromJsonFactory,
    );

    return _natinfoNatinfNumeroNatinfArticlesGet(
      referenceDate: referenceDate,
      numeroNatinf: numeroNatinf,
    );
  }

  ///Extraire les articles juridiques référencés par un NATINF.
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour sélectionner une version officielle.
  @GET(path: '/natinfo/natinf/{numero_natinf}/articles/')
  Future<chopper.Response<NatinfoNatinfNumeroNatinfArticlesGet$Response>>
  _natinfoNatinfNumeroNatinfArticlesGet({
    @Query('reference_date') String? referenceDate,
    @Path('numero_natinf') required String? numeroNatinf,
  });

  ///Accéder aux documents professionnels associés à un NATINF.
  ///@param numero_natinf Unique NATINF number.
  Future<chopper.Response<List<NatinfDocPro>>>
  natinfoNatinfNumeroNatinfDocProGet({
    required String? numeroNatinf,
    required String? numeroNatinf$,
  }) {
    generatedMapping.putIfAbsent(
      NatinfDocPro,
      () => NatinfDocPro.fromJsonFactory,
    );

    return _natinfoNatinfNumeroNatinfDocProGet(
      numeroNatinf: numeroNatinf,
      numeroNatinf$: numeroNatinf$,
    );
  }

  ///Accéder aux documents professionnels associés à un NATINF.
  ///@param numero_natinf Unique NATINF number.
  @GET(path: '/natinfo/natinf/{numero_natinf}/doc-pro/')
  Future<chopper.Response<List<NatinfDocPro>>>
  _natinfoNatinfNumeroNatinfDocProGet({
    @Query('numero_natinf') required String? numeroNatinf,
    @Path('numero_natinf') required String? numeroNatinf$,
  });

  ///Mettre à jour ou enrichir une fiche NATINF existante.
  ///@param data
  Future<chopper.Response<Natinf>> natinfoNatinfNumeroNatinfEditPost({
    required NatinfUpdate? data,
    required String? numeroNatinf,
  }) {
    generatedMapping.putIfAbsent(
      NatinfUpdate,
      () => NatinfUpdate.fromJsonFactory,
    );
    generatedMapping.putIfAbsent(Natinf, () => Natinf.fromJsonFactory);

    return _natinfoNatinfNumeroNatinfEditPost(
      data: data,
      numeroNatinf: numeroNatinf,
    );
  }

  ///Mettre à jour ou enrichir une fiche NATINF existante.
  ///@param data
  @POST(path: '/natinfo/natinf/{numero_natinf}/edit/')
  Future<chopper.Response<Natinf>> _natinfoNatinfNumeroNatinfEditPost({
    @Body() required NatinfUpdate? data,
    @Path('numero_natinf') required String? numeroNatinf,
  });

  ///Lister les références d'une fiche NATINF donnée.
  ///@param numero_natinf Unique NATINF number.
  Future<chopper.Response<List<NatinfReference>>>
  natinfoNatinfNumeroNatinfReferencesGet({
    required String? numeroNatinf,
    required String? numeroNatinf$,
  }) {
    generatedMapping.putIfAbsent(
      NatinfReference,
      () => NatinfReference.fromJsonFactory,
    );

    return _natinfoNatinfNumeroNatinfReferencesGet(
      numeroNatinf: numeroNatinf,
      numeroNatinf$: numeroNatinf$,
    );
  }

  ///Lister les références d'une fiche NATINF donnée.
  ///@param numero_natinf Unique NATINF number.
  @GET(path: '/natinfo/natinf/{numero_natinf}/references/')
  Future<chopper.Response<List<NatinfReference>>>
  _natinfoNatinfNumeroNatinfReferencesGet({
    @Query('numero_natinf') required String? numeroNatinf,
    @Path('numero_natinf') required String? numeroNatinf$,
  });

  ///Lister les références d'une fiche NATINF donnée.
  ///@param numero_natinf Unique NATINF number.
  Future<chopper.Response<List<NatinfReference>>> natinfoReferencesGet({
    required String? numeroNatinf,
  }) {
    generatedMapping.putIfAbsent(
      NatinfReference,
      () => NatinfReference.fromJsonFactory,
    );

    return _natinfoReferencesGet(numeroNatinf: numeroNatinf);
  }

  ///Lister les références d'une fiche NATINF donnée.
  ///@param numero_natinf Unique NATINF number.
  @GET(path: '/natinfo/references/')
  Future<chopper.Response<List<NatinfReference>>> _natinfoReferencesGet({
    @Query('numero_natinf') required String? numeroNatinf,
  });

  ///Rechercher des fiches NATINF par mots-clés.
  ///@param q Search query string (keywords, code, article, etc.)
  ///@param paginate Enable pagination (true/false)
  ///@param page Page number (optional, only if paginate=true, defaults to 1)
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour sélectionner une version officielle.
  Future<chopper.Response<List<NatinfSearch>>> natinfoSearchGet({
    String? q,
    bool? paginate,
    int? page,
    String? referenceDate,
  }) {
    generatedMapping.putIfAbsent(
      NatinfSearch,
      () => NatinfSearch.fromJsonFactory,
    );

    return _natinfoSearchGet(
      q: q,
      paginate: paginate,
      page: page,
      referenceDate: referenceDate,
    );
  }

  ///Rechercher des fiches NATINF par mots-clés.
  ///@param q Search query string (keywords, code, article, etc.)
  ///@param paginate Enable pagination (true/false)
  ///@param page Page number (optional, only if paginate=true, defaults to 1)
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour sélectionner une version officielle.
  @GET(path: '/natinfo/search/')
  Future<chopper.Response<List<NatinfSearch>>> _natinfoSearchGet({
    @Query('q') String? q,
    @Query('paginate') bool? paginate,
    @Query('page') int? page,
    @Query('reference_date') String? referenceDate,
  });

  ///
  ///@param abreviation Normalized abbreviation for the text type (punctuation/case insensitive).
  ///@param libelle The displayed label (case and whitespace insensitive).
  ///@param libelle_legifrance_api Label used in the Legifrance API (case and whitespace insensitive).
  Future<chopper.Response<NatinfoTexteTypeLibelleGet$Response>>
  natinfoTexteTypeLibelleGet({
    String? abreviation,
    String? libelle,
    String? libelleLegifranceApi,
  }) {
    generatedMapping.putIfAbsent(
      NatinfoTexteTypeLibelleGet$Response,
      () => NatinfoTexteTypeLibelleGet$Response.fromJsonFactory,
    );

    return _natinfoTexteTypeLibelleGet(
      abreviation: abreviation,
      libelle: libelle,
      libelleLegifranceApi: libelleLegifranceApi,
    );
  }

  ///
  ///@param abreviation Normalized abbreviation for the text type (punctuation/case insensitive).
  ///@param libelle The displayed label (case and whitespace insensitive).
  ///@param libelle_legifrance_api Label used in the Legifrance API (case and whitespace insensitive).
  @GET(path: '/natinfo/texte-type-libelle/')
  Future<chopper.Response<NatinfoTexteTypeLibelleGet$Response>>
  _natinfoTexteTypeLibelleGet({
    @Query('abreviation') String? abreviation,
    @Query('libelle') String? libelle,
    @Query('libelle_legifrance_api') String? libelleLegifranceApi,
  });

  ///Lister toutes les fiches NATINF publiques.
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour choisir une version officielle.
  Future<chopper.Response<List<Natinf>>> natinfsGet({String? referenceDate}) {
    generatedMapping.putIfAbsent(Natinf, () => Natinf.fromJsonFactory);

    return _natinfsGet(referenceDate: referenceDate);
  }

  ///Lister toutes les fiches NATINF publiques.
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour choisir une version officielle.
  @GET(path: '/natinfs/')
  Future<chopper.Response<List<Natinf>>> _natinfsGet({
    @Query('reference_date') String? referenceDate,
  });

  ///Proposer des suggestions de recherche NATINF.
  ///@param q Search prefix for autocomplete
  Future<chopper.Response> natinfsAutocompleteGet({String? q}) {
    return _natinfsAutocompleteGet(q: q);
  }

  ///Proposer des suggestions de recherche NATINF.
  ///@param q Search prefix for autocomplete
  @GET(path: '/natinfs/autocomplete/')
  Future<chopper.Response> _natinfsAutocompleteGet({@Query('q') String? q});

  ///Rechercher des fiches NATINF par mots-clés.
  ///@param q Search query string (keywords, code, article, etc.)
  ///@param paginate Enable pagination (true/false)
  ///@param page Page number (optional, only if paginate=true, defaults to 1)
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour sélectionner une version officielle.
  Future<chopper.Response<List<NatinfSearch>>> natinfsSearchGet({
    String? q,
    bool? paginate,
    int? page,
    String? referenceDate,
  }) {
    generatedMapping.putIfAbsent(
      NatinfSearch,
      () => NatinfSearch.fromJsonFactory,
    );

    return _natinfsSearchGet(
      q: q,
      paginate: paginate,
      page: page,
      referenceDate: referenceDate,
    );
  }

  ///Rechercher des fiches NATINF par mots-clés.
  ///@param q Search query string (keywords, code, article, etc.)
  ///@param paginate Enable pagination (true/false)
  ///@param page Page number (optional, only if paginate=true, defaults to 1)
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour sélectionner une version officielle.
  @GET(path: '/natinfs/search/')
  Future<chopper.Response<List<NatinfSearch>>> _natinfsSearchGet({
    @Query('q') String? q,
    @Query('paginate') bool? paginate,
    @Query('page') int? page,
    @Query('reference_date') String? referenceDate,
  });

  ///
  ///@param abreviation Normalized abbreviation for the text type (punctuation/case insensitive).
  ///@param libelle The displayed label (case and whitespace insensitive).
  ///@param libelle_legifrance_api Label used in the Legifrance API (case and whitespace insensitive).
  Future<chopper.Response<NatinfsTexteTypeLibelleGet$Response>>
  natinfsTexteTypeLibelleGet({
    String? abreviation,
    String? libelle,
    String? libelleLegifranceApi,
  }) {
    generatedMapping.putIfAbsent(
      NatinfsTexteTypeLibelleGet$Response,
      () => NatinfsTexteTypeLibelleGet$Response.fromJsonFactory,
    );

    return _natinfsTexteTypeLibelleGet(
      abreviation: abreviation,
      libelle: libelle,
      libelleLegifranceApi: libelleLegifranceApi,
    );
  }

  ///
  ///@param abreviation Normalized abbreviation for the text type (punctuation/case insensitive).
  ///@param libelle The displayed label (case and whitespace insensitive).
  ///@param libelle_legifrance_api Label used in the Legifrance API (case and whitespace insensitive).
  @GET(path: '/natinfs/texte-type-libelle/')
  Future<chopper.Response<NatinfsTexteTypeLibelleGet$Response>>
  _natinfsTexteTypeLibelleGet({
    @Query('abreviation') String? abreviation,
    @Query('libelle') String? libelle,
    @Query('libelle_legifrance_api') String? libelleLegifranceApi,
  });

  ///Extraire les articles juridiques référencés par un NATINF.
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour sélectionner une version officielle.
  Future<chopper.Response<NatinfsNumeroNatinfArticlesGet$Response>>
  natinfsNumeroNatinfArticlesGet({
    String? referenceDate,
    required String? numeroNatinf,
  }) {
    generatedMapping.putIfAbsent(
      NatinfsNumeroNatinfArticlesGet$Response,
      () => NatinfsNumeroNatinfArticlesGet$Response.fromJsonFactory,
    );

    return _natinfsNumeroNatinfArticlesGet(
      referenceDate: referenceDate,
      numeroNatinf: numeroNatinf,
    );
  }

  ///Extraire les articles juridiques référencés par un NATINF.
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour sélectionner une version officielle.
  @GET(path: '/natinfs/{numero_natinf}/articles/')
  Future<chopper.Response<NatinfsNumeroNatinfArticlesGet$Response>>
  _natinfsNumeroNatinfArticlesGet({
    @Query('reference_date') String? referenceDate,
    @Path('numero_natinf') required String? numeroNatinf,
  });

  ///Accéder aux documents professionnels associés à un NATINF.
  ///@param numero_natinf Unique NATINF number.
  Future<chopper.Response<List<NatinfDocPro>>> natinfsNumeroNatinfDocProGet({
    required String? numeroNatinf,
    required String? numeroNatinf$,
  }) {
    generatedMapping.putIfAbsent(
      NatinfDocPro,
      () => NatinfDocPro.fromJsonFactory,
    );

    return _natinfsNumeroNatinfDocProGet(
      numeroNatinf: numeroNatinf,
      numeroNatinf$: numeroNatinf$,
    );
  }

  ///Accéder aux documents professionnels associés à un NATINF.
  ///@param numero_natinf Unique NATINF number.
  @GET(path: '/natinfs/{numero_natinf}/doc-pro/')
  Future<chopper.Response<List<NatinfDocPro>>> _natinfsNumeroNatinfDocProGet({
    @Query('numero_natinf') required String? numeroNatinf,
    @Path('numero_natinf') required String? numeroNatinf$,
  });

  ///Mettre à jour ou enrichir une fiche NATINF existante.
  ///@param data
  Future<chopper.Response<Natinf>> natinfsNumeroNatinfEditPost({
    required NatinfUpdate? data,
    required String? numeroNatinf,
  }) {
    generatedMapping.putIfAbsent(
      NatinfUpdate,
      () => NatinfUpdate.fromJsonFactory,
    );
    generatedMapping.putIfAbsent(Natinf, () => Natinf.fromJsonFactory);

    return _natinfsNumeroNatinfEditPost(data: data, numeroNatinf: numeroNatinf);
  }

  ///Mettre à jour ou enrichir une fiche NATINF existante.
  ///@param data
  @POST(path: '/natinfs/{numero_natinf}/edit/')
  Future<chopper.Response<Natinf>> _natinfsNumeroNatinfEditPost({
    @Body() required NatinfUpdate? data,
    @Path('numero_natinf') required String? numeroNatinf,
  });

  ///Lister les références d'une fiche NATINF donnée.
  ///@param numero_natinf Unique NATINF number.
  Future<chopper.Response<List<NatinfReference>>>
  natinfsNumeroNatinfReferencesGet({
    required String? numeroNatinf,
    required String? numeroNatinf$,
  }) {
    generatedMapping.putIfAbsent(
      NatinfReference,
      () => NatinfReference.fromJsonFactory,
    );

    return _natinfsNumeroNatinfReferencesGet(
      numeroNatinf: numeroNatinf,
      numeroNatinf$: numeroNatinf$,
    );
  }

  ///Lister les références d'une fiche NATINF donnée.
  ///@param numero_natinf Unique NATINF number.
  @GET(path: '/natinfs/{numero_natinf}/references/')
  Future<chopper.Response<List<NatinfReference>>>
  _natinfsNumeroNatinfReferencesGet({
    @Query('numero_natinf') required String? numeroNatinf,
    @Path('numero_natinf') required String? numeroNatinf$,
  });

  ///Consulter une classe NFI et ses sous-classes associées.
  Future<chopper.Response> nfiClassesClasseIdGet({required String? classeId}) {
    return _nfiClassesClasseIdGet(classeId: classeId);
  }

  ///Consulter une classe NFI et ses sous-classes associées.
  @GET(path: '/nfi/classes/{classe_id}/')
  Future<chopper.Response> _nfiClassesClasseIdGet({
    @Path('classe_id') required String? classeId,
  });

  ///Consulter une division NFI avec sa hiérarchie et ses groupes.
  Future<chopper.Response> nfiDivisionsDivisionIdGet({
    required String? divisionId,
  }) {
    return _nfiDivisionsDivisionIdGet(divisionId: divisionId);
  }

  ///Consulter une division NFI avec sa hiérarchie et ses groupes.
  @GET(path: '/nfi/divisions/{division_id}/')
  Future<chopper.Response> _nfiDivisionsDivisionIdGet({
    @Path('division_id') required String? divisionId,
  });

  ///Consulter un groupe NFI, sa division parente et ses classes.
  Future<chopper.Response> nfiGroupesGroupeIdGet({required String? groupeId}) {
    return _nfiGroupesGroupeIdGet(groupeId: groupeId);
  }

  ///Consulter un groupe NFI, sa division parente et ses classes.
  @GET(path: '/nfi/groupes/{groupe_id}/')
  Future<chopper.Response> _nfiGroupesGroupeIdGet({
    @Path('groupe_id') required String? groupeId,
  });

  ///Retourner la liste complète des sections NFI.
  Future<chopper.Response> nfiSectionsGet() {
    return _nfiSectionsGet();
  }

  ///Retourner la liste complète des sections NFI.
  @GET(path: '/nfi/sections/')
  Future<chopper.Response> _nfiSectionsGet();

  ///Consulter le détail d'une section NFI et ses divisions.
  Future<chopper.Response> nfiSectionsSectionIdGet({
    required String? sectionId,
  }) {
    return _nfiSectionsSectionIdGet(sectionId: sectionId);
  }

  ///Consulter le détail d'une section NFI et ses divisions.
  @GET(path: '/nfi/sections/{section_id}/')
  Future<chopper.Response> _nfiSectionsSectionIdGet({
    @Path('section_id') required String? sectionId,
  });

  ///Consulter le détail d'une sous-classe NFI.
  Future<chopper.Response> nfiSousClassesSousClasseIdGet({
    required String? sousClasseId,
  }) {
    return _nfiSousClassesSousClasseIdGet(sousClasseId: sousClasseId);
  }

  ///Consulter le détail d'une sous-classe NFI.
  @GET(path: '/nfi/sous-classes/{sous_classe_id}/')
  Future<chopper.Response> _nfiSousClassesSousClasseIdGet({
    @Path('sous_classe_id') required String? sousClasseId,
  });

  ///Créer un identifiant de sélection d'impression.
  ///@param data List of NATINF numbers to include in the print selection.
  Future<chopper.Response<PrintSelectionsPost$Response>> printSelectionsPost({
    required List<String>? data,
  }) {
    generatedMapping.putIfAbsent(
      PrintSelectionsPost$Response,
      () => PrintSelectionsPost$Response.fromJsonFactory,
    );

    return _printSelectionsPost(data: data);
  }

  ///Créer un identifiant de sélection d'impression.
  ///@param data List of NATINF numbers to include in the print selection.
  @POST(path: '/print-selections/')
  Future<chopper.Response<PrintSelectionsPost$Response>> _printSelectionsPost({
    @Body() required List<String>? data,
  });

  ///Récupérer le contenu d'une sélection d'impression.
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour sélectionner les versions officielles.
  Future<chopper.Response<List<PrintSelectionItem>>>
  printSelectionsSelectionIdGet({
    String? referenceDate,
    required String? selectionId,
  }) {
    generatedMapping.putIfAbsent(
      PrintSelectionItem,
      () => PrintSelectionItem.fromJsonFactory,
    );

    return _printSelectionsSelectionIdGet(
      referenceDate: referenceDate,
      selectionId: selectionId,
    );
  }

  ///Récupérer le contenu d'une sélection d'impression.
  ///@param reference_date Date de référence (AAAA-MM-JJ) pour sélectionner les versions officielles.
  @GET(path: '/print-selections/{selection_id}/')
  Future<chopper.Response<List<PrintSelectionItem>>>
  _printSelectionsSelectionIdGet({
    @Query('reference_date') String? referenceDate,
    @Path('selection_id') required String? selectionId,
  });
}

@JsonSerializable(explicitToJson: true)
class APITokenObtainPair {
  const APITokenObtainPair({
    this.tokenLabel,
    required this.username,
    required this.password,
  });

  factory APITokenObtainPair.fromJson(Map<String, dynamic> json) =>
      _$APITokenObtainPairFromJson(json);

  static const toJsonFactory = _$APITokenObtainPairToJson;
  Map<String, dynamic> toJson() => _$APITokenObtainPairToJson(this);

  @JsonKey(name: 'token_label')
  final String? tokenLabel;
  @JsonKey(name: 'username')
  final String username;
  @JsonKey(name: 'password')
  final String password;
  static const fromJsonFactory = _$APITokenObtainPairFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is APITokenObtainPair &&
            (identical(other.tokenLabel, tokenLabel) ||
                const DeepCollectionEquality().equals(
                  other.tokenLabel,
                  tokenLabel,
                )) &&
            (identical(other.username, username) ||
                const DeepCollectionEquality().equals(
                  other.username,
                  username,
                )) &&
            (identical(other.password, password) ||
                const DeepCollectionEquality().equals(
                  other.password,
                  password,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(tokenLabel) ^
      const DeepCollectionEquality().hash(username) ^
      const DeepCollectionEquality().hash(password) ^
      runtimeType.hashCode;
}

extension $APITokenObtainPairExtension on APITokenObtainPair {
  APITokenObtainPair copyWith({
    String? tokenLabel,
    String? username,
    String? password,
  }) {
    return APITokenObtainPair(
      tokenLabel: tokenLabel ?? this.tokenLabel,
      username: username ?? this.username,
      password: password ?? this.password,
    );
  }

  APITokenObtainPair copyWithWrapped({
    Wrapped<String?>? tokenLabel,
    Wrapped<String>? username,
    Wrapped<String>? password,
  }) {
    return APITokenObtainPair(
      tokenLabel: (tokenLabel != null ? tokenLabel.value : this.tokenLabel),
      username: (username != null ? username.value : this.username),
      password: (password != null ? password.value : this.password),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class AuthMe {
  const AuthMe({
    required this.username,
    required this.email,
    required this.groups,
    required this.hasDocPro,
    required this.accountVerified,
  });

  factory AuthMe.fromJson(Map<String, dynamic> json) => _$AuthMeFromJson(json);

  static const toJsonFactory = _$AuthMeToJson;
  Map<String, dynamic> toJson() => _$AuthMeToJson(this);

  @JsonKey(name: 'username')
  final String username;
  @JsonKey(name: 'email')
  final String email;
  @JsonKey(name: 'groups', defaultValue: <String>[])
  final List<String> groups;
  @JsonKey(name: 'has_doc_pro')
  final bool hasDocPro;
  @JsonKey(name: 'account_verified')
  final bool accountVerified;
  static const fromJsonFactory = _$AuthMeFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is AuthMe &&
            (identical(other.username, username) ||
                const DeepCollectionEquality().equals(
                  other.username,
                  username,
                )) &&
            (identical(other.email, email) ||
                const DeepCollectionEquality().equals(other.email, email)) &&
            (identical(other.groups, groups) ||
                const DeepCollectionEquality().equals(other.groups, groups)) &&
            (identical(other.hasDocPro, hasDocPro) ||
                const DeepCollectionEquality().equals(
                  other.hasDocPro,
                  hasDocPro,
                )) &&
            (identical(other.accountVerified, accountVerified) ||
                const DeepCollectionEquality().equals(
                  other.accountVerified,
                  accountVerified,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(username) ^
      const DeepCollectionEquality().hash(email) ^
      const DeepCollectionEquality().hash(groups) ^
      const DeepCollectionEquality().hash(hasDocPro) ^
      const DeepCollectionEquality().hash(accountVerified) ^
      runtimeType.hashCode;
}

extension $AuthMeExtension on AuthMe {
  AuthMe copyWith({
    String? username,
    String? email,
    List<String>? groups,
    bool? hasDocPro,
    bool? accountVerified,
  }) {
    return AuthMe(
      username: username ?? this.username,
      email: email ?? this.email,
      groups: groups ?? this.groups,
      hasDocPro: hasDocPro ?? this.hasDocPro,
      accountVerified: accountVerified ?? this.accountVerified,
    );
  }

  AuthMe copyWithWrapped({
    Wrapped<String>? username,
    Wrapped<String>? email,
    Wrapped<List<String>>? groups,
    Wrapped<bool>? hasDocPro,
    Wrapped<bool>? accountVerified,
  }) {
    return AuthMe(
      username: (username != null ? username.value : this.username),
      email: (email != null ? email.value : this.email),
      groups: (groups != null ? groups.value : this.groups),
      hasDocPro: (hasDocPro != null ? hasDocPro.value : this.hasDocPro),
      accountVerified:
          (accountVerified != null
              ? accountVerified.value
              : this.accountVerified),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class APITokenRefresh {
  const APITokenRefresh({required this.refresh, this.access});

  factory APITokenRefresh.fromJson(Map<String, dynamic> json) =>
      _$APITokenRefreshFromJson(json);

  static const toJsonFactory = _$APITokenRefreshToJson;
  Map<String, dynamic> toJson() => _$APITokenRefreshToJson(this);

  @JsonKey(name: 'refresh')
  final String refresh;
  @JsonKey(name: 'access')
  final String? access;
  static const fromJsonFactory = _$APITokenRefreshFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is APITokenRefresh &&
            (identical(other.refresh, refresh) ||
                const DeepCollectionEquality().equals(
                  other.refresh,
                  refresh,
                )) &&
            (identical(other.access, access) ||
                const DeepCollectionEquality().equals(other.access, access)));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(refresh) ^
      const DeepCollectionEquality().hash(access) ^
      runtimeType.hashCode;
}

extension $APITokenRefreshExtension on APITokenRefresh {
  APITokenRefresh copyWith({String? refresh, String? access}) {
    return APITokenRefresh(
      refresh: refresh ?? this.refresh,
      access: access ?? this.access,
    );
  }

  APITokenRefresh copyWithWrapped({
    Wrapped<String>? refresh,
    Wrapped<String?>? access,
  }) {
    return APITokenRefresh(
      refresh: (refresh != null ? refresh.value : this.refresh),
      access: (access != null ? access.value : this.access),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class CategoryBrief {
  const CategoryBrief({this.id, required this.name});

  factory CategoryBrief.fromJson(Map<String, dynamic> json) =>
      _$CategoryBriefFromJson(json);

  static const toJsonFactory = _$CategoryBriefToJson;
  Map<String, dynamic> toJson() => _$CategoryBriefToJson(this);

  @JsonKey(name: 'id')
  final int? id;
  @JsonKey(name: 'name')
  final String name;
  static const fromJsonFactory = _$CategoryBriefFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is CategoryBrief &&
            (identical(other.id, id) ||
                const DeepCollectionEquality().equals(other.id, id)) &&
            (identical(other.name, name) ||
                const DeepCollectionEquality().equals(other.name, name)));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(id) ^
      const DeepCollectionEquality().hash(name) ^
      runtimeType.hashCode;
}

extension $CategoryBriefExtension on CategoryBrief {
  CategoryBrief copyWith({int? id, String? name}) {
    return CategoryBrief(id: id ?? this.id, name: name ?? this.name);
  }

  CategoryBrief copyWithWrapped({Wrapped<int?>? id, Wrapped<String>? name}) {
    return CategoryBrief(
      id: (id != null ? id.value : this.id),
      name: (name != null ? name.value : this.name),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class Category {
  const Category({
    this.id,
    required this.name,
    this.description,
    this.parent,
    this.children,
    this.natinfs,
  });

  factory Category.fromJson(Map<String, dynamic> json) =>
      _$CategoryFromJson(json);

  static const toJsonFactory = _$CategoryToJson;
  Map<String, dynamic> toJson() => _$CategoryToJson(this);

  @JsonKey(name: 'id')
  final int? id;
  @JsonKey(name: 'name')
  final String name;
  @JsonKey(name: 'description')
  final String? description;
  @JsonKey(name: 'parent')
  final CategoryBrief? parent;
  @JsonKey(name: 'children', defaultValue: <CategoryBrief>[])
  final List<CategoryBrief>? children;
  @JsonKey(name: 'natinfs', defaultValue: <Object>[])
  final List<Object>? natinfs;
  static const fromJsonFactory = _$CategoryFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is Category &&
            (identical(other.id, id) ||
                const DeepCollectionEquality().equals(other.id, id)) &&
            (identical(other.name, name) ||
                const DeepCollectionEquality().equals(other.name, name)) &&
            (identical(other.description, description) ||
                const DeepCollectionEquality().equals(
                  other.description,
                  description,
                )) &&
            (identical(other.parent, parent) ||
                const DeepCollectionEquality().equals(other.parent, parent)) &&
            (identical(other.children, children) ||
                const DeepCollectionEquality().equals(
                  other.children,
                  children,
                )) &&
            (identical(other.natinfs, natinfs) ||
                const DeepCollectionEquality().equals(other.natinfs, natinfs)));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(id) ^
      const DeepCollectionEquality().hash(name) ^
      const DeepCollectionEquality().hash(description) ^
      const DeepCollectionEquality().hash(parent) ^
      const DeepCollectionEquality().hash(children) ^
      const DeepCollectionEquality().hash(natinfs) ^
      runtimeType.hashCode;
}

extension $CategoryExtension on Category {
  Category copyWith({
    int? id,
    String? name,
    String? description,
    CategoryBrief? parent,
    List<CategoryBrief>? children,
    List<Object>? natinfs,
  }) {
    return Category(
      id: id ?? this.id,
      name: name ?? this.name,
      description: description ?? this.description,
      parent: parent ?? this.parent,
      children: children ?? this.children,
      natinfs: natinfs ?? this.natinfs,
    );
  }

  Category copyWithWrapped({
    Wrapped<int?>? id,
    Wrapped<String>? name,
    Wrapped<String?>? description,
    Wrapped<CategoryBrief?>? parent,
    Wrapped<List<CategoryBrief>?>? children,
    Wrapped<List<Object>?>? natinfs,
  }) {
    return Category(
      id: (id != null ? id.value : this.id),
      name: (name != null ? name.value : this.name),
      description: (description != null ? description.value : this.description),
      parent: (parent != null ? parent.value : this.parent),
      children: (children != null ? children.value : this.children),
      natinfs: (natinfs != null ? natinfs.value : this.natinfs),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfReference {
  const NatinfReference({
    this.id,
    this.natinf,
    this.title,
    required this.url,
    this.publicationDate,
    this.addedOn,
    this.description,
  });

  factory NatinfReference.fromJson(Map<String, dynamic> json) =>
      _$NatinfReferenceFromJson(json);

  static const toJsonFactory = _$NatinfReferenceToJson;
  Map<String, dynamic> toJson() => _$NatinfReferenceToJson(this);

  @JsonKey(name: 'id')
  final int? id;
  @JsonKey(name: 'natinf')
  final String? natinf;
  @JsonKey(name: 'title')
  final String? title;
  @JsonKey(name: 'url')
  final String url;
  @JsonKey(name: 'publication_date', toJson: _dateToJson)
  final DateTime? publicationDate;
  @JsonKey(name: 'added_on')
  final DateTime? addedOn;
  @JsonKey(name: 'description')
  final String? description;
  static const fromJsonFactory = _$NatinfReferenceFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is NatinfReference &&
            (identical(other.id, id) ||
                const DeepCollectionEquality().equals(other.id, id)) &&
            (identical(other.natinf, natinf) ||
                const DeepCollectionEquality().equals(other.natinf, natinf)) &&
            (identical(other.title, title) ||
                const DeepCollectionEquality().equals(other.title, title)) &&
            (identical(other.url, url) ||
                const DeepCollectionEquality().equals(other.url, url)) &&
            (identical(other.publicationDate, publicationDate) ||
                const DeepCollectionEquality().equals(
                  other.publicationDate,
                  publicationDate,
                )) &&
            (identical(other.addedOn, addedOn) ||
                const DeepCollectionEquality().equals(
                  other.addedOn,
                  addedOn,
                )) &&
            (identical(other.description, description) ||
                const DeepCollectionEquality().equals(
                  other.description,
                  description,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(id) ^
      const DeepCollectionEquality().hash(natinf) ^
      const DeepCollectionEquality().hash(title) ^
      const DeepCollectionEquality().hash(url) ^
      const DeepCollectionEquality().hash(publicationDate) ^
      const DeepCollectionEquality().hash(addedOn) ^
      const DeepCollectionEquality().hash(description) ^
      runtimeType.hashCode;
}

extension $NatinfReferenceExtension on NatinfReference {
  NatinfReference copyWith({
    int? id,
    String? natinf,
    String? title,
    String? url,
    DateTime? publicationDate,
    DateTime? addedOn,
    String? description,
  }) {
    return NatinfReference(
      id: id ?? this.id,
      natinf: natinf ?? this.natinf,
      title: title ?? this.title,
      url: url ?? this.url,
      publicationDate: publicationDate ?? this.publicationDate,
      addedOn: addedOn ?? this.addedOn,
      description: description ?? this.description,
    );
  }

  NatinfReference copyWithWrapped({
    Wrapped<int?>? id,
    Wrapped<String?>? natinf,
    Wrapped<String?>? title,
    Wrapped<String>? url,
    Wrapped<DateTime?>? publicationDate,
    Wrapped<DateTime?>? addedOn,
    Wrapped<String?>? description,
  }) {
    return NatinfReference(
      id: (id != null ? id.value : this.id),
      natinf: (natinf != null ? natinf.value : this.natinf),
      title: (title != null ? title.value : this.title),
      url: (url != null ? url.value : this.url),
      publicationDate:
          (publicationDate != null
              ? publicationDate.value
              : this.publicationDate),
      addedOn: (addedOn != null ? addedOn.value : this.addedOn),
      description: (description != null ? description.value : this.description),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfPenalty {
  const NatinfPenalty({
    this.id,
    this.template,
    this.templateLabel,
    this.category,
    this.durationValue,
    this.durationUnit,
    this.durationUnitDisplay,
    this.durationOperator,
    this.durationOperatorDisplay,
    this.canDurationDefinitive,
    this.amountValue,
    this.amountCurrency,
    this.amountCurrencyDisplay,
    this.notes,
    this.article,
    this.ordering,
  });

  factory NatinfPenalty.fromJson(Map<String, dynamic> json) =>
      _$NatinfPenaltyFromJson(json);

  static const toJsonFactory = _$NatinfPenaltyToJson;
  Map<String, dynamic> toJson() => _$NatinfPenaltyToJson(this);

  @JsonKey(name: 'id')
  final int? id;
  @JsonKey(name: 'template')
  final String? template;
  @JsonKey(name: 'template_label')
  final String? templateLabel;
  @JsonKey(name: 'category')
  final String? category;
  @JsonKey(name: 'duration_value')
  final int? durationValue;
  @JsonKey(
    name: 'duration_unit',
    toJson: natinfPenaltyDurationUnitNullableToJson,
    fromJson: natinfPenaltyDurationUnitNullableFromJson,
  )
  final enums.NatinfPenaltyDurationUnit? durationUnit;
  @JsonKey(name: 'duration_unit_display')
  final String? durationUnitDisplay;
  @JsonKey(
    name: 'duration_operator',
    toJson: natinfPenaltyDurationOperatorNullableToJson,
    fromJson: natinfPenaltyDurationOperatorNullableFromJson,
  )
  final enums.NatinfPenaltyDurationOperator? durationOperator;
  @JsonKey(name: 'duration_operator_display')
  final String? durationOperatorDisplay;
  @JsonKey(name: 'can_duration_definitive')
  final bool? canDurationDefinitive;
  @JsonKey(name: 'amount_value')
  final String? amountValue;
  @JsonKey(
    name: 'amount_currency',
    toJson: natinfPenaltyAmountCurrencyNullableToJson,
    fromJson: natinfPenaltyAmountCurrencyNullableFromJson,
  )
  final enums.NatinfPenaltyAmountCurrency? amountCurrency;
  @JsonKey(name: 'amount_currency_display')
  final String? amountCurrencyDisplay;
  @JsonKey(name: 'notes')
  final String? notes;
  @JsonKey(name: 'article')
  final String? article;
  @JsonKey(name: 'ordering')
  final int? ordering;
  static const fromJsonFactory = _$NatinfPenaltyFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is NatinfPenalty &&
            (identical(other.id, id) ||
                const DeepCollectionEquality().equals(other.id, id)) &&
            (identical(other.template, template) ||
                const DeepCollectionEquality().equals(
                  other.template,
                  template,
                )) &&
            (identical(other.templateLabel, templateLabel) ||
                const DeepCollectionEquality().equals(
                  other.templateLabel,
                  templateLabel,
                )) &&
            (identical(other.category, category) ||
                const DeepCollectionEquality().equals(
                  other.category,
                  category,
                )) &&
            (identical(other.durationValue, durationValue) ||
                const DeepCollectionEquality().equals(
                  other.durationValue,
                  durationValue,
                )) &&
            (identical(other.durationUnit, durationUnit) ||
                const DeepCollectionEquality().equals(
                  other.durationUnit,
                  durationUnit,
                )) &&
            (identical(other.durationUnitDisplay, durationUnitDisplay) ||
                const DeepCollectionEquality().equals(
                  other.durationUnitDisplay,
                  durationUnitDisplay,
                )) &&
            (identical(other.durationOperator, durationOperator) ||
                const DeepCollectionEquality().equals(
                  other.durationOperator,
                  durationOperator,
                )) &&
            (identical(
                  other.durationOperatorDisplay,
                  durationOperatorDisplay,
                ) ||
                const DeepCollectionEquality().equals(
                  other.durationOperatorDisplay,
                  durationOperatorDisplay,
                )) &&
            (identical(other.canDurationDefinitive, canDurationDefinitive) ||
                const DeepCollectionEquality().equals(
                  other.canDurationDefinitive,
                  canDurationDefinitive,
                )) &&
            (identical(other.amountValue, amountValue) ||
                const DeepCollectionEquality().equals(
                  other.amountValue,
                  amountValue,
                )) &&
            (identical(other.amountCurrency, amountCurrency) ||
                const DeepCollectionEquality().equals(
                  other.amountCurrency,
                  amountCurrency,
                )) &&
            (identical(other.amountCurrencyDisplay, amountCurrencyDisplay) ||
                const DeepCollectionEquality().equals(
                  other.amountCurrencyDisplay,
                  amountCurrencyDisplay,
                )) &&
            (identical(other.notes, notes) ||
                const DeepCollectionEquality().equals(other.notes, notes)) &&
            (identical(other.article, article) ||
                const DeepCollectionEquality().equals(
                  other.article,
                  article,
                )) &&
            (identical(other.ordering, ordering) ||
                const DeepCollectionEquality().equals(
                  other.ordering,
                  ordering,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(id) ^
      const DeepCollectionEquality().hash(template) ^
      const DeepCollectionEquality().hash(templateLabel) ^
      const DeepCollectionEquality().hash(category) ^
      const DeepCollectionEquality().hash(durationValue) ^
      const DeepCollectionEquality().hash(durationUnit) ^
      const DeepCollectionEquality().hash(durationUnitDisplay) ^
      const DeepCollectionEquality().hash(durationOperator) ^
      const DeepCollectionEquality().hash(durationOperatorDisplay) ^
      const DeepCollectionEquality().hash(canDurationDefinitive) ^
      const DeepCollectionEquality().hash(amountValue) ^
      const DeepCollectionEquality().hash(amountCurrency) ^
      const DeepCollectionEquality().hash(amountCurrencyDisplay) ^
      const DeepCollectionEquality().hash(notes) ^
      const DeepCollectionEquality().hash(article) ^
      const DeepCollectionEquality().hash(ordering) ^
      runtimeType.hashCode;
}

extension $NatinfPenaltyExtension on NatinfPenalty {
  NatinfPenalty copyWith({
    int? id,
    String? template,
    String? templateLabel,
    String? category,
    int? durationValue,
    enums.NatinfPenaltyDurationUnit? durationUnit,
    String? durationUnitDisplay,
    enums.NatinfPenaltyDurationOperator? durationOperator,
    String? durationOperatorDisplay,
    bool? canDurationDefinitive,
    String? amountValue,
    enums.NatinfPenaltyAmountCurrency? amountCurrency,
    String? amountCurrencyDisplay,
    String? notes,
    String? article,
    int? ordering,
  }) {
    return NatinfPenalty(
      id: id ?? this.id,
      template: template ?? this.template,
      templateLabel: templateLabel ?? this.templateLabel,
      category: category ?? this.category,
      durationValue: durationValue ?? this.durationValue,
      durationUnit: durationUnit ?? this.durationUnit,
      durationUnitDisplay: durationUnitDisplay ?? this.durationUnitDisplay,
      durationOperator: durationOperator ?? this.durationOperator,
      durationOperatorDisplay:
          durationOperatorDisplay ?? this.durationOperatorDisplay,
      canDurationDefinitive:
          canDurationDefinitive ?? this.canDurationDefinitive,
      amountValue: amountValue ?? this.amountValue,
      amountCurrency: amountCurrency ?? this.amountCurrency,
      amountCurrencyDisplay:
          amountCurrencyDisplay ?? this.amountCurrencyDisplay,
      notes: notes ?? this.notes,
      article: article ?? this.article,
      ordering: ordering ?? this.ordering,
    );
  }

  NatinfPenalty copyWithWrapped({
    Wrapped<int?>? id,
    Wrapped<String?>? template,
    Wrapped<String?>? templateLabel,
    Wrapped<String?>? category,
    Wrapped<int?>? durationValue,
    Wrapped<enums.NatinfPenaltyDurationUnit?>? durationUnit,
    Wrapped<String?>? durationUnitDisplay,
    Wrapped<enums.NatinfPenaltyDurationOperator?>? durationOperator,
    Wrapped<String?>? durationOperatorDisplay,
    Wrapped<bool?>? canDurationDefinitive,
    Wrapped<String?>? amountValue,
    Wrapped<enums.NatinfPenaltyAmountCurrency?>? amountCurrency,
    Wrapped<String?>? amountCurrencyDisplay,
    Wrapped<String?>? notes,
    Wrapped<String?>? article,
    Wrapped<int?>? ordering,
  }) {
    return NatinfPenalty(
      id: (id != null ? id.value : this.id),
      template: (template != null ? template.value : this.template),
      templateLabel:
          (templateLabel != null ? templateLabel.value : this.templateLabel),
      category: (category != null ? category.value : this.category),
      durationValue:
          (durationValue != null ? durationValue.value : this.durationValue),
      durationUnit:
          (durationUnit != null ? durationUnit.value : this.durationUnit),
      durationUnitDisplay:
          (durationUnitDisplay != null
              ? durationUnitDisplay.value
              : this.durationUnitDisplay),
      durationOperator:
          (durationOperator != null
              ? durationOperator.value
              : this.durationOperator),
      durationOperatorDisplay:
          (durationOperatorDisplay != null
              ? durationOperatorDisplay.value
              : this.durationOperatorDisplay),
      canDurationDefinitive:
          (canDurationDefinitive != null
              ? canDurationDefinitive.value
              : this.canDurationDefinitive),
      amountValue: (amountValue != null ? amountValue.value : this.amountValue),
      amountCurrency:
          (amountCurrency != null ? amountCurrency.value : this.amountCurrency),
      amountCurrencyDisplay:
          (amountCurrencyDisplay != null
              ? amountCurrencyDisplay.value
              : this.amountCurrencyDisplay),
      notes: (notes != null ? notes.value : this.notes),
      article: (article != null ? article.value : this.article),
      ordering: (ordering != null ? ordering.value : this.ordering),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class Natinf {
  const Natinf({
    this.id,
    this.natureInfraction,
    this.qualificationInfraction,
    this.definiePar,
    this.reprimeePar,
    this.references,
    this.categories,
    this.peinesPrincipales,
    this.peinesComplementaires,
    this.numeroNatinf,
    this.sanctionsEncourues,
    this.tentative,
    this.amendeCategory,
    this.montantAfMin,
    this.montantAf,
    this.montantAfMaj,
    this.montantAfdMin,
    this.montantAfd,
    this.montantAfdMaj,
    this.controleAlcoolemie,
    this.depistageImpregnationAlcoolique,
    this.depistageStupefiants,
    this.retraitPoints,
    this.retentionPermisConduire,
    this.immobilisationVehicule,
    this.miseEnFourriere,
    this.elementMateriel,
    this.elementMoral,
    this.mesuresComplementaires,
    this.observations,
    this.lastEdited,
    this.obsoleteDate,
    required this.dacgSource,
    this.nfiSection,
    this.nfiDivision,
    this.nfiGroupe,
    this.nfiClasse,
    this.nfiSousClasse,
    this.modesProcesVerbal,
  });

  factory Natinf.fromJson(Map<String, dynamic> json) => _$NatinfFromJson(json);

  static const toJsonFactory = _$NatinfToJson;
  Map<String, dynamic> toJson() => _$NatinfToJson(this);

  @JsonKey(name: 'id')
  final int? id;
  @JsonKey(name: 'nature_infraction')
  final String? natureInfraction;
  @JsonKey(name: 'qualification_infraction')
  final String? qualificationInfraction;
  @JsonKey(name: 'definie_par')
  final String? definiePar;
  @JsonKey(name: 'reprimee_par')
  final String? reprimeePar;
  @JsonKey(name: 'references', defaultValue: <NatinfReference>[])
  final List<NatinfReference>? references;
  @JsonKey(name: 'categories', defaultValue: <Category>[])
  final List<Category>? categories;
  @JsonKey(name: 'peines_principales', defaultValue: <NatinfPenalty>[])
  final List<NatinfPenalty>? peinesPrincipales;
  @JsonKey(name: 'peines_complementaires', defaultValue: <NatinfPenalty>[])
  final List<NatinfPenalty>? peinesComplementaires;
  @JsonKey(name: 'numero_natinf')
  final String? numeroNatinf;
  @JsonKey(name: 'sanctions_encourues')
  final String? sanctionsEncourues;
  @JsonKey(name: 'tentative')
  final bool? tentative;
  @JsonKey(
    name: 'amende_category',
    toJson: natinfAmendeCategoryNullableToJson,
    fromJson: natinfAmendeCategoryNullableFromJson,
  )
  final enums.NatinfAmendeCategory? amendeCategory;
  @JsonKey(name: 'montant_af_min')
  final String? montantAfMin;
  @JsonKey(name: 'montant_af')
  final String? montantAf;
  @JsonKey(name: 'montant_af_maj')
  final String? montantAfMaj;
  @JsonKey(name: 'montant_afd_min')
  final String? montantAfdMin;
  @JsonKey(name: 'montant_afd')
  final String? montantAfd;
  @JsonKey(name: 'montant_afd_maj')
  final String? montantAfdMaj;
  @JsonKey(
    name: 'controle_alcoolemie',
    toJson: natinfControleAlcoolemieNullableToJson,
    fromJson: natinfControleAlcoolemieNullableFromJson,
  )
  final enums.NatinfControleAlcoolemie? controleAlcoolemie;
  @JsonKey(
    name: 'depistage_impregnation_alcoolique',
    toJson: natinfDepistageImpregnationAlcooliqueNullableToJson,
    fromJson: natinfDepistageImpregnationAlcooliqueNullableFromJson,
  )
  final enums.NatinfDepistageImpregnationAlcoolique?
  depistageImpregnationAlcoolique;
  @JsonKey(
    name: 'depistage_stupefiants',
    toJson: natinfDepistageStupefiantsNullableToJson,
    fromJson: natinfDepistageStupefiantsNullableFromJson,
  )
  final enums.NatinfDepistageStupefiants? depistageStupefiants;
  @JsonKey(name: 'retrait_points')
  final int? retraitPoints;
  @JsonKey(
    name: 'retention_permis_conduire',
    toJson: natinfRetentionPermisConduireNullableToJson,
    fromJson: natinfRetentionPermisConduireNullableFromJson,
  )
  final enums.NatinfRetentionPermisConduire? retentionPermisConduire;
  @JsonKey(
    name: 'immobilisation_vehicule',
    toJson: natinfImmobilisationVehiculeNullableToJson,
    fromJson: natinfImmobilisationVehiculeNullableFromJson,
  )
  final enums.NatinfImmobilisationVehicule? immobilisationVehicule;
  @JsonKey(
    name: 'mise_en_fourriere',
    toJson: natinfMiseEnFourriereNullableToJson,
    fromJson: natinfMiseEnFourriereNullableFromJson,
  )
  final enums.NatinfMiseEnFourriere? miseEnFourriere;
  @JsonKey(name: 'element_materiel')
  final String? elementMateriel;
  @JsonKey(name: 'element_moral')
  final String? elementMoral;
  @JsonKey(name: 'mesures_complementaires')
  final String? mesuresComplementaires;
  @JsonKey(name: 'observations')
  final String? observations;
  @JsonKey(name: 'last_edited')
  final DateTime? lastEdited;
  @JsonKey(name: 'obsolete_date', toJson: _dateToJson)
  final DateTime? obsoleteDate;
  @JsonKey(name: 'dacg_source')
  final int dacgSource;
  @JsonKey(name: 'nfi_section')
  final String? nfiSection;
  @JsonKey(name: 'nfi_division')
  final String? nfiDivision;
  @JsonKey(name: 'nfi_groupe')
  final String? nfiGroupe;
  @JsonKey(name: 'nfi_classe')
  final String? nfiClasse;
  @JsonKey(name: 'nfi_sous_classe')
  final String? nfiSousClasse;
  @JsonKey(name: 'modes_proces_verbal', defaultValue: <int>[])
  final List<int>? modesProcesVerbal;
  static const fromJsonFactory = _$NatinfFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is Natinf &&
            (identical(other.id, id) ||
                const DeepCollectionEquality().equals(other.id, id)) &&
            (identical(other.natureInfraction, natureInfraction) ||
                const DeepCollectionEquality().equals(
                  other.natureInfraction,
                  natureInfraction,
                )) &&
            (identical(
                  other.qualificationInfraction,
                  qualificationInfraction,
                ) ||
                const DeepCollectionEquality().equals(
                  other.qualificationInfraction,
                  qualificationInfraction,
                )) &&
            (identical(other.definiePar, definiePar) ||
                const DeepCollectionEquality().equals(
                  other.definiePar,
                  definiePar,
                )) &&
            (identical(other.reprimeePar, reprimeePar) ||
                const DeepCollectionEquality().equals(
                  other.reprimeePar,
                  reprimeePar,
                )) &&
            (identical(other.references, references) ||
                const DeepCollectionEquality().equals(
                  other.references,
                  references,
                )) &&
            (identical(other.categories, categories) ||
                const DeepCollectionEquality().equals(
                  other.categories,
                  categories,
                )) &&
            (identical(other.peinesPrincipales, peinesPrincipales) ||
                const DeepCollectionEquality().equals(
                  other.peinesPrincipales,
                  peinesPrincipales,
                )) &&
            (identical(other.peinesComplementaires, peinesComplementaires) ||
                const DeepCollectionEquality().equals(
                  other.peinesComplementaires,
                  peinesComplementaires,
                )) &&
            (identical(other.numeroNatinf, numeroNatinf) ||
                const DeepCollectionEquality().equals(
                  other.numeroNatinf,
                  numeroNatinf,
                )) &&
            (identical(other.sanctionsEncourues, sanctionsEncourues) ||
                const DeepCollectionEquality().equals(
                  other.sanctionsEncourues,
                  sanctionsEncourues,
                )) &&
            (identical(other.tentative, tentative) ||
                const DeepCollectionEquality().equals(
                  other.tentative,
                  tentative,
                )) &&
            (identical(other.amendeCategory, amendeCategory) ||
                const DeepCollectionEquality().equals(
                  other.amendeCategory,
                  amendeCategory,
                )) &&
            (identical(other.montantAfMin, montantAfMin) ||
                const DeepCollectionEquality().equals(
                  other.montantAfMin,
                  montantAfMin,
                )) &&
            (identical(other.montantAf, montantAf) ||
                const DeepCollectionEquality().equals(
                  other.montantAf,
                  montantAf,
                )) &&
            (identical(other.montantAfMaj, montantAfMaj) ||
                const DeepCollectionEquality().equals(
                  other.montantAfMaj,
                  montantAfMaj,
                )) &&
            (identical(other.montantAfdMin, montantAfdMin) ||
                const DeepCollectionEquality().equals(
                  other.montantAfdMin,
                  montantAfdMin,
                )) &&
            (identical(other.montantAfd, montantAfd) ||
                const DeepCollectionEquality().equals(
                  other.montantAfd,
                  montantAfd,
                )) &&
            (identical(other.montantAfdMaj, montantAfdMaj) ||
                const DeepCollectionEquality().equals(
                  other.montantAfdMaj,
                  montantAfdMaj,
                )) &&
            (identical(other.controleAlcoolemie, controleAlcoolemie) ||
                const DeepCollectionEquality().equals(
                  other.controleAlcoolemie,
                  controleAlcoolemie,
                )) &&
            (identical(
                  other.depistageImpregnationAlcoolique,
                  depistageImpregnationAlcoolique,
                ) ||
                const DeepCollectionEquality().equals(
                  other.depistageImpregnationAlcoolique,
                  depistageImpregnationAlcoolique,
                )) &&
            (identical(other.depistageStupefiants, depistageStupefiants) ||
                const DeepCollectionEquality().equals(
                  other.depistageStupefiants,
                  depistageStupefiants,
                )) &&
            (identical(other.retraitPoints, retraitPoints) ||
                const DeepCollectionEquality().equals(
                  other.retraitPoints,
                  retraitPoints,
                )) &&
            (identical(
                  other.retentionPermisConduire,
                  retentionPermisConduire,
                ) ||
                const DeepCollectionEquality().equals(
                  other.retentionPermisConduire,
                  retentionPermisConduire,
                )) &&
            (identical(other.immobilisationVehicule, immobilisationVehicule) ||
                const DeepCollectionEquality().equals(
                  other.immobilisationVehicule,
                  immobilisationVehicule,
                )) &&
            (identical(other.miseEnFourriere, miseEnFourriere) ||
                const DeepCollectionEquality().equals(
                  other.miseEnFourriere,
                  miseEnFourriere,
                )) &&
            (identical(other.elementMateriel, elementMateriel) ||
                const DeepCollectionEquality().equals(
                  other.elementMateriel,
                  elementMateriel,
                )) &&
            (identical(other.elementMoral, elementMoral) ||
                const DeepCollectionEquality().equals(
                  other.elementMoral,
                  elementMoral,
                )) &&
            (identical(other.mesuresComplementaires, mesuresComplementaires) ||
                const DeepCollectionEquality().equals(
                  other.mesuresComplementaires,
                  mesuresComplementaires,
                )) &&
            (identical(other.observations, observations) ||
                const DeepCollectionEquality().equals(
                  other.observations,
                  observations,
                )) &&
            (identical(other.lastEdited, lastEdited) ||
                const DeepCollectionEquality().equals(
                  other.lastEdited,
                  lastEdited,
                )) &&
            (identical(other.obsoleteDate, obsoleteDate) ||
                const DeepCollectionEquality().equals(
                  other.obsoleteDate,
                  obsoleteDate,
                )) &&
            (identical(other.dacgSource, dacgSource) ||
                const DeepCollectionEquality().equals(
                  other.dacgSource,
                  dacgSource,
                )) &&
            (identical(other.nfiSection, nfiSection) ||
                const DeepCollectionEquality().equals(
                  other.nfiSection,
                  nfiSection,
                )) &&
            (identical(other.nfiDivision, nfiDivision) ||
                const DeepCollectionEquality().equals(
                  other.nfiDivision,
                  nfiDivision,
                )) &&
            (identical(other.nfiGroupe, nfiGroupe) ||
                const DeepCollectionEquality().equals(
                  other.nfiGroupe,
                  nfiGroupe,
                )) &&
            (identical(other.nfiClasse, nfiClasse) ||
                const DeepCollectionEquality().equals(
                  other.nfiClasse,
                  nfiClasse,
                )) &&
            (identical(other.nfiSousClasse, nfiSousClasse) ||
                const DeepCollectionEquality().equals(
                  other.nfiSousClasse,
                  nfiSousClasse,
                )) &&
            (identical(other.modesProcesVerbal, modesProcesVerbal) ||
                const DeepCollectionEquality().equals(
                  other.modesProcesVerbal,
                  modesProcesVerbal,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(id) ^
      const DeepCollectionEquality().hash(natureInfraction) ^
      const DeepCollectionEquality().hash(qualificationInfraction) ^
      const DeepCollectionEquality().hash(definiePar) ^
      const DeepCollectionEquality().hash(reprimeePar) ^
      const DeepCollectionEquality().hash(references) ^
      const DeepCollectionEquality().hash(categories) ^
      const DeepCollectionEquality().hash(peinesPrincipales) ^
      const DeepCollectionEquality().hash(peinesComplementaires) ^
      const DeepCollectionEquality().hash(numeroNatinf) ^
      const DeepCollectionEquality().hash(sanctionsEncourues) ^
      const DeepCollectionEquality().hash(tentative) ^
      const DeepCollectionEquality().hash(amendeCategory) ^
      const DeepCollectionEquality().hash(montantAfMin) ^
      const DeepCollectionEquality().hash(montantAf) ^
      const DeepCollectionEquality().hash(montantAfMaj) ^
      const DeepCollectionEquality().hash(montantAfdMin) ^
      const DeepCollectionEquality().hash(montantAfd) ^
      const DeepCollectionEquality().hash(montantAfdMaj) ^
      const DeepCollectionEquality().hash(controleAlcoolemie) ^
      const DeepCollectionEquality().hash(depistageImpregnationAlcoolique) ^
      const DeepCollectionEquality().hash(depistageStupefiants) ^
      const DeepCollectionEquality().hash(retraitPoints) ^
      const DeepCollectionEquality().hash(retentionPermisConduire) ^
      const DeepCollectionEquality().hash(immobilisationVehicule) ^
      const DeepCollectionEquality().hash(miseEnFourriere) ^
      const DeepCollectionEquality().hash(elementMateriel) ^
      const DeepCollectionEquality().hash(elementMoral) ^
      const DeepCollectionEquality().hash(mesuresComplementaires) ^
      const DeepCollectionEquality().hash(observations) ^
      const DeepCollectionEquality().hash(lastEdited) ^
      const DeepCollectionEquality().hash(obsoleteDate) ^
      const DeepCollectionEquality().hash(dacgSource) ^
      const DeepCollectionEquality().hash(nfiSection) ^
      const DeepCollectionEquality().hash(nfiDivision) ^
      const DeepCollectionEquality().hash(nfiGroupe) ^
      const DeepCollectionEquality().hash(nfiClasse) ^
      const DeepCollectionEquality().hash(nfiSousClasse) ^
      const DeepCollectionEquality().hash(modesProcesVerbal) ^
      runtimeType.hashCode;
}

extension $NatinfExtension on Natinf {
  Natinf copyWith({
    int? id,
    String? natureInfraction,
    String? qualificationInfraction,
    String? definiePar,
    String? reprimeePar,
    List<NatinfReference>? references,
    List<Category>? categories,
    List<NatinfPenalty>? peinesPrincipales,
    List<NatinfPenalty>? peinesComplementaires,
    String? numeroNatinf,
    String? sanctionsEncourues,
    bool? tentative,
    enums.NatinfAmendeCategory? amendeCategory,
    String? montantAfMin,
    String? montantAf,
    String? montantAfMaj,
    String? montantAfdMin,
    String? montantAfd,
    String? montantAfdMaj,
    enums.NatinfControleAlcoolemie? controleAlcoolemie,
    enums.NatinfDepistageImpregnationAlcoolique?
    depistageImpregnationAlcoolique,
    enums.NatinfDepistageStupefiants? depistageStupefiants,
    int? retraitPoints,
    enums.NatinfRetentionPermisConduire? retentionPermisConduire,
    enums.NatinfImmobilisationVehicule? immobilisationVehicule,
    enums.NatinfMiseEnFourriere? miseEnFourriere,
    String? elementMateriel,
    String? elementMoral,
    String? mesuresComplementaires,
    String? observations,
    DateTime? lastEdited,
    DateTime? obsoleteDate,
    int? dacgSource,
    String? nfiSection,
    String? nfiDivision,
    String? nfiGroupe,
    String? nfiClasse,
    String? nfiSousClasse,
    List<int>? modesProcesVerbal,
  }) {
    return Natinf(
      id: id ?? this.id,
      natureInfraction: natureInfraction ?? this.natureInfraction,
      qualificationInfraction:
          qualificationInfraction ?? this.qualificationInfraction,
      definiePar: definiePar ?? this.definiePar,
      reprimeePar: reprimeePar ?? this.reprimeePar,
      references: references ?? this.references,
      categories: categories ?? this.categories,
      peinesPrincipales: peinesPrincipales ?? this.peinesPrincipales,
      peinesComplementaires:
          peinesComplementaires ?? this.peinesComplementaires,
      numeroNatinf: numeroNatinf ?? this.numeroNatinf,
      sanctionsEncourues: sanctionsEncourues ?? this.sanctionsEncourues,
      tentative: tentative ?? this.tentative,
      amendeCategory: amendeCategory ?? this.amendeCategory,
      montantAfMin: montantAfMin ?? this.montantAfMin,
      montantAf: montantAf ?? this.montantAf,
      montantAfMaj: montantAfMaj ?? this.montantAfMaj,
      montantAfdMin: montantAfdMin ?? this.montantAfdMin,
      montantAfd: montantAfd ?? this.montantAfd,
      montantAfdMaj: montantAfdMaj ?? this.montantAfdMaj,
      controleAlcoolemie: controleAlcoolemie ?? this.controleAlcoolemie,
      depistageImpregnationAlcoolique:
          depistageImpregnationAlcoolique ??
          this.depistageImpregnationAlcoolique,
      depistageStupefiants: depistageStupefiants ?? this.depistageStupefiants,
      retraitPoints: retraitPoints ?? this.retraitPoints,
      retentionPermisConduire:
          retentionPermisConduire ?? this.retentionPermisConduire,
      immobilisationVehicule:
          immobilisationVehicule ?? this.immobilisationVehicule,
      miseEnFourriere: miseEnFourriere ?? this.miseEnFourriere,
      elementMateriel: elementMateriel ?? this.elementMateriel,
      elementMoral: elementMoral ?? this.elementMoral,
      mesuresComplementaires:
          mesuresComplementaires ?? this.mesuresComplementaires,
      observations: observations ?? this.observations,
      lastEdited: lastEdited ?? this.lastEdited,
      obsoleteDate: obsoleteDate ?? this.obsoleteDate,
      dacgSource: dacgSource ?? this.dacgSource,
      nfiSection: nfiSection ?? this.nfiSection,
      nfiDivision: nfiDivision ?? this.nfiDivision,
      nfiGroupe: nfiGroupe ?? this.nfiGroupe,
      nfiClasse: nfiClasse ?? this.nfiClasse,
      nfiSousClasse: nfiSousClasse ?? this.nfiSousClasse,
      modesProcesVerbal: modesProcesVerbal ?? this.modesProcesVerbal,
    );
  }

  Natinf copyWithWrapped({
    Wrapped<int?>? id,
    Wrapped<String?>? natureInfraction,
    Wrapped<String?>? qualificationInfraction,
    Wrapped<String?>? definiePar,
    Wrapped<String?>? reprimeePar,
    Wrapped<List<NatinfReference>?>? references,
    Wrapped<List<Category>?>? categories,
    Wrapped<List<NatinfPenalty>?>? peinesPrincipales,
    Wrapped<List<NatinfPenalty>?>? peinesComplementaires,
    Wrapped<String?>? numeroNatinf,
    Wrapped<String?>? sanctionsEncourues,
    Wrapped<bool?>? tentative,
    Wrapped<enums.NatinfAmendeCategory?>? amendeCategory,
    Wrapped<String?>? montantAfMin,
    Wrapped<String?>? montantAf,
    Wrapped<String?>? montantAfMaj,
    Wrapped<String?>? montantAfdMin,
    Wrapped<String?>? montantAfd,
    Wrapped<String?>? montantAfdMaj,
    Wrapped<enums.NatinfControleAlcoolemie?>? controleAlcoolemie,
    Wrapped<enums.NatinfDepistageImpregnationAlcoolique?>?
    depistageImpregnationAlcoolique,
    Wrapped<enums.NatinfDepistageStupefiants?>? depistageStupefiants,
    Wrapped<int?>? retraitPoints,
    Wrapped<enums.NatinfRetentionPermisConduire?>? retentionPermisConduire,
    Wrapped<enums.NatinfImmobilisationVehicule?>? immobilisationVehicule,
    Wrapped<enums.NatinfMiseEnFourriere?>? miseEnFourriere,
    Wrapped<String?>? elementMateriel,
    Wrapped<String?>? elementMoral,
    Wrapped<String?>? mesuresComplementaires,
    Wrapped<String?>? observations,
    Wrapped<DateTime?>? lastEdited,
    Wrapped<DateTime?>? obsoleteDate,
    Wrapped<int>? dacgSource,
    Wrapped<String?>? nfiSection,
    Wrapped<String?>? nfiDivision,
    Wrapped<String?>? nfiGroupe,
    Wrapped<String?>? nfiClasse,
    Wrapped<String?>? nfiSousClasse,
    Wrapped<List<int>?>? modesProcesVerbal,
  }) {
    return Natinf(
      id: (id != null ? id.value : this.id),
      natureInfraction:
          (natureInfraction != null
              ? natureInfraction.value
              : this.natureInfraction),
      qualificationInfraction:
          (qualificationInfraction != null
              ? qualificationInfraction.value
              : this.qualificationInfraction),
      definiePar: (definiePar != null ? definiePar.value : this.definiePar),
      reprimeePar: (reprimeePar != null ? reprimeePar.value : this.reprimeePar),
      references: (references != null ? references.value : this.references),
      categories: (categories != null ? categories.value : this.categories),
      peinesPrincipales:
          (peinesPrincipales != null
              ? peinesPrincipales.value
              : this.peinesPrincipales),
      peinesComplementaires:
          (peinesComplementaires != null
              ? peinesComplementaires.value
              : this.peinesComplementaires),
      numeroNatinf:
          (numeroNatinf != null ? numeroNatinf.value : this.numeroNatinf),
      sanctionsEncourues:
          (sanctionsEncourues != null
              ? sanctionsEncourues.value
              : this.sanctionsEncourues),
      tentative: (tentative != null ? tentative.value : this.tentative),
      amendeCategory:
          (amendeCategory != null ? amendeCategory.value : this.amendeCategory),
      montantAfMin:
          (montantAfMin != null ? montantAfMin.value : this.montantAfMin),
      montantAf: (montantAf != null ? montantAf.value : this.montantAf),
      montantAfMaj:
          (montantAfMaj != null ? montantAfMaj.value : this.montantAfMaj),
      montantAfdMin:
          (montantAfdMin != null ? montantAfdMin.value : this.montantAfdMin),
      montantAfd: (montantAfd != null ? montantAfd.value : this.montantAfd),
      montantAfdMaj:
          (montantAfdMaj != null ? montantAfdMaj.value : this.montantAfdMaj),
      controleAlcoolemie:
          (controleAlcoolemie != null
              ? controleAlcoolemie.value
              : this.controleAlcoolemie),
      depistageImpregnationAlcoolique:
          (depistageImpregnationAlcoolique != null
              ? depistageImpregnationAlcoolique.value
              : this.depistageImpregnationAlcoolique),
      depistageStupefiants:
          (depistageStupefiants != null
              ? depistageStupefiants.value
              : this.depistageStupefiants),
      retraitPoints:
          (retraitPoints != null ? retraitPoints.value : this.retraitPoints),
      retentionPermisConduire:
          (retentionPermisConduire != null
              ? retentionPermisConduire.value
              : this.retentionPermisConduire),
      immobilisationVehicule:
          (immobilisationVehicule != null
              ? immobilisationVehicule.value
              : this.immobilisationVehicule),
      miseEnFourriere:
          (miseEnFourriere != null
              ? miseEnFourriere.value
              : this.miseEnFourriere),
      elementMateriel:
          (elementMateriel != null
              ? elementMateriel.value
              : this.elementMateriel),
      elementMoral:
          (elementMoral != null ? elementMoral.value : this.elementMoral),
      mesuresComplementaires:
          (mesuresComplementaires != null
              ? mesuresComplementaires.value
              : this.mesuresComplementaires),
      observations:
          (observations != null ? observations.value : this.observations),
      lastEdited: (lastEdited != null ? lastEdited.value : this.lastEdited),
      obsoleteDate:
          (obsoleteDate != null ? obsoleteDate.value : this.obsoleteDate),
      dacgSource: (dacgSource != null ? dacgSource.value : this.dacgSource),
      nfiSection: (nfiSection != null ? nfiSection.value : this.nfiSection),
      nfiDivision: (nfiDivision != null ? nfiDivision.value : this.nfiDivision),
      nfiGroupe: (nfiGroupe != null ? nfiGroupe.value : this.nfiGroupe),
      nfiClasse: (nfiClasse != null ? nfiClasse.value : this.nfiClasse),
      nfiSousClasse:
          (nfiSousClasse != null ? nfiSousClasse.value : this.nfiSousClasse),
      modesProcesVerbal:
          (modesProcesVerbal != null
              ? modesProcesVerbal.value
              : this.modesProcesVerbal),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfDocPro {
  const NatinfDocPro({
    this.id,
    this.natinf,
    this.title,
    required this.url,
    this.publicationDate,
    this.addedOn,
    this.description,
  });

  factory NatinfDocPro.fromJson(Map<String, dynamic> json) =>
      _$NatinfDocProFromJson(json);

  static const toJsonFactory = _$NatinfDocProToJson;
  Map<String, dynamic> toJson() => _$NatinfDocProToJson(this);

  @JsonKey(name: 'id')
  final int? id;
  @JsonKey(name: 'natinf')
  final String? natinf;
  @JsonKey(name: 'title')
  final String? title;
  @JsonKey(name: 'url')
  final String url;
  @JsonKey(name: 'publication_date', toJson: _dateToJson)
  final DateTime? publicationDate;
  @JsonKey(name: 'added_on')
  final DateTime? addedOn;
  @JsonKey(name: 'description')
  final String? description;
  static const fromJsonFactory = _$NatinfDocProFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is NatinfDocPro &&
            (identical(other.id, id) ||
                const DeepCollectionEquality().equals(other.id, id)) &&
            (identical(other.natinf, natinf) ||
                const DeepCollectionEquality().equals(other.natinf, natinf)) &&
            (identical(other.title, title) ||
                const DeepCollectionEquality().equals(other.title, title)) &&
            (identical(other.url, url) ||
                const DeepCollectionEquality().equals(other.url, url)) &&
            (identical(other.publicationDate, publicationDate) ||
                const DeepCollectionEquality().equals(
                  other.publicationDate,
                  publicationDate,
                )) &&
            (identical(other.addedOn, addedOn) ||
                const DeepCollectionEquality().equals(
                  other.addedOn,
                  addedOn,
                )) &&
            (identical(other.description, description) ||
                const DeepCollectionEquality().equals(
                  other.description,
                  description,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(id) ^
      const DeepCollectionEquality().hash(natinf) ^
      const DeepCollectionEquality().hash(title) ^
      const DeepCollectionEquality().hash(url) ^
      const DeepCollectionEquality().hash(publicationDate) ^
      const DeepCollectionEquality().hash(addedOn) ^
      const DeepCollectionEquality().hash(description) ^
      runtimeType.hashCode;
}

extension $NatinfDocProExtension on NatinfDocPro {
  NatinfDocPro copyWith({
    int? id,
    String? natinf,
    String? title,
    String? url,
    DateTime? publicationDate,
    DateTime? addedOn,
    String? description,
  }) {
    return NatinfDocPro(
      id: id ?? this.id,
      natinf: natinf ?? this.natinf,
      title: title ?? this.title,
      url: url ?? this.url,
      publicationDate: publicationDate ?? this.publicationDate,
      addedOn: addedOn ?? this.addedOn,
      description: description ?? this.description,
    );
  }

  NatinfDocPro copyWithWrapped({
    Wrapped<int?>? id,
    Wrapped<String?>? natinf,
    Wrapped<String?>? title,
    Wrapped<String>? url,
    Wrapped<DateTime?>? publicationDate,
    Wrapped<DateTime?>? addedOn,
    Wrapped<String?>? description,
  }) {
    return NatinfDocPro(
      id: (id != null ? id.value : this.id),
      natinf: (natinf != null ? natinf.value : this.natinf),
      title: (title != null ? title.value : this.title),
      url: (url != null ? url.value : this.url),
      publicationDate:
          (publicationDate != null
              ? publicationDate.value
              : this.publicationDate),
      addedOn: (addedOn != null ? addedOn.value : this.addedOn),
      description: (description != null ? description.value : this.description),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfPenaltyInput {
  const NatinfPenaltyInput({
    this.id,
    required this.template,
    this.durationValue,
    this.durationUnit,
    this.durationOperator,
    this.amountValue,
    this.amountCurrency,
    this.notes,
    this.ordering,
    this.category,
    this.canDurationDefinitive,
    this.article,
  });

  factory NatinfPenaltyInput.fromJson(Map<String, dynamic> json) =>
      _$NatinfPenaltyInputFromJson(json);

  static const toJsonFactory = _$NatinfPenaltyInputToJson;
  Map<String, dynamic> toJson() => _$NatinfPenaltyInputToJson(this);

  @JsonKey(name: 'id')
  final int? id;
  @JsonKey(name: 'template')
  final String template;
  @JsonKey(name: 'duration_value')
  final int? durationValue;
  @JsonKey(
    name: 'duration_unit',
    toJson: natinfPenaltyInputDurationUnitNullableToJson,
    fromJson: natinfPenaltyInputDurationUnitNullableFromJson,
  )
  final enums.NatinfPenaltyInputDurationUnit? durationUnit;
  @JsonKey(
    name: 'duration_operator',
    toJson: natinfPenaltyInputDurationOperatorNullableToJson,
    fromJson: natinfPenaltyInputDurationOperatorNullableFromJson,
  )
  final enums.NatinfPenaltyInputDurationOperator? durationOperator;
  @JsonKey(name: 'amount_value')
  final String? amountValue;
  @JsonKey(
    name: 'amount_currency',
    toJson: natinfPenaltyInputAmountCurrencyNullableToJson,
    fromJson: natinfPenaltyInputAmountCurrencyNullableFromJson,
  )
  final enums.NatinfPenaltyInputAmountCurrency? amountCurrency;
  @JsonKey(name: 'notes')
  final String? notes;
  @JsonKey(name: 'ordering')
  final int? ordering;
  @JsonKey(name: 'category')
  final String? category;
  @JsonKey(name: 'can_duration_definitive')
  final bool? canDurationDefinitive;
  @JsonKey(name: 'article')
  final String? article;
  static const fromJsonFactory = _$NatinfPenaltyInputFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is NatinfPenaltyInput &&
            (identical(other.id, id) ||
                const DeepCollectionEquality().equals(other.id, id)) &&
            (identical(other.template, template) ||
                const DeepCollectionEquality().equals(
                  other.template,
                  template,
                )) &&
            (identical(other.durationValue, durationValue) ||
                const DeepCollectionEquality().equals(
                  other.durationValue,
                  durationValue,
                )) &&
            (identical(other.durationUnit, durationUnit) ||
                const DeepCollectionEquality().equals(
                  other.durationUnit,
                  durationUnit,
                )) &&
            (identical(other.durationOperator, durationOperator) ||
                const DeepCollectionEquality().equals(
                  other.durationOperator,
                  durationOperator,
                )) &&
            (identical(other.amountValue, amountValue) ||
                const DeepCollectionEquality().equals(
                  other.amountValue,
                  amountValue,
                )) &&
            (identical(other.amountCurrency, amountCurrency) ||
                const DeepCollectionEquality().equals(
                  other.amountCurrency,
                  amountCurrency,
                )) &&
            (identical(other.notes, notes) ||
                const DeepCollectionEquality().equals(other.notes, notes)) &&
            (identical(other.ordering, ordering) ||
                const DeepCollectionEquality().equals(
                  other.ordering,
                  ordering,
                )) &&
            (identical(other.category, category) ||
                const DeepCollectionEquality().equals(
                  other.category,
                  category,
                )) &&
            (identical(other.canDurationDefinitive, canDurationDefinitive) ||
                const DeepCollectionEquality().equals(
                  other.canDurationDefinitive,
                  canDurationDefinitive,
                )) &&
            (identical(other.article, article) ||
                const DeepCollectionEquality().equals(other.article, article)));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(id) ^
      const DeepCollectionEquality().hash(template) ^
      const DeepCollectionEquality().hash(durationValue) ^
      const DeepCollectionEquality().hash(durationUnit) ^
      const DeepCollectionEquality().hash(durationOperator) ^
      const DeepCollectionEquality().hash(amountValue) ^
      const DeepCollectionEquality().hash(amountCurrency) ^
      const DeepCollectionEquality().hash(notes) ^
      const DeepCollectionEquality().hash(ordering) ^
      const DeepCollectionEquality().hash(category) ^
      const DeepCollectionEquality().hash(canDurationDefinitive) ^
      const DeepCollectionEquality().hash(article) ^
      runtimeType.hashCode;
}

extension $NatinfPenaltyInputExtension on NatinfPenaltyInput {
  NatinfPenaltyInput copyWith({
    int? id,
    String? template,
    int? durationValue,
    enums.NatinfPenaltyInputDurationUnit? durationUnit,
    enums.NatinfPenaltyInputDurationOperator? durationOperator,
    String? amountValue,
    enums.NatinfPenaltyInputAmountCurrency? amountCurrency,
    String? notes,
    int? ordering,
    String? category,
    bool? canDurationDefinitive,
    String? article,
  }) {
    return NatinfPenaltyInput(
      id: id ?? this.id,
      template: template ?? this.template,
      durationValue: durationValue ?? this.durationValue,
      durationUnit: durationUnit ?? this.durationUnit,
      durationOperator: durationOperator ?? this.durationOperator,
      amountValue: amountValue ?? this.amountValue,
      amountCurrency: amountCurrency ?? this.amountCurrency,
      notes: notes ?? this.notes,
      ordering: ordering ?? this.ordering,
      category: category ?? this.category,
      canDurationDefinitive:
          canDurationDefinitive ?? this.canDurationDefinitive,
      article: article ?? this.article,
    );
  }

  NatinfPenaltyInput copyWithWrapped({
    Wrapped<int?>? id,
    Wrapped<String>? template,
    Wrapped<int?>? durationValue,
    Wrapped<enums.NatinfPenaltyInputDurationUnit?>? durationUnit,
    Wrapped<enums.NatinfPenaltyInputDurationOperator?>? durationOperator,
    Wrapped<String?>? amountValue,
    Wrapped<enums.NatinfPenaltyInputAmountCurrency?>? amountCurrency,
    Wrapped<String?>? notes,
    Wrapped<int?>? ordering,
    Wrapped<String?>? category,
    Wrapped<bool?>? canDurationDefinitive,
    Wrapped<String?>? article,
  }) {
    return NatinfPenaltyInput(
      id: (id != null ? id.value : this.id),
      template: (template != null ? template.value : this.template),
      durationValue:
          (durationValue != null ? durationValue.value : this.durationValue),
      durationUnit:
          (durationUnit != null ? durationUnit.value : this.durationUnit),
      durationOperator:
          (durationOperator != null
              ? durationOperator.value
              : this.durationOperator),
      amountValue: (amountValue != null ? amountValue.value : this.amountValue),
      amountCurrency:
          (amountCurrency != null ? amountCurrency.value : this.amountCurrency),
      notes: (notes != null ? notes.value : this.notes),
      ordering: (ordering != null ? ordering.value : this.ordering),
      category: (category != null ? category.value : this.category),
      canDurationDefinitive:
          (canDurationDefinitive != null
              ? canDurationDefinitive.value
              : this.canDurationDefinitive),
      article: (article != null ? article.value : this.article),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfUpdate {
  const NatinfUpdate({
    required this.numeroNatinf,
    required this.changementsCommentaires,
    this.penalties,
    this.modesProcesVerbal,
    this.sanctionsEncourues,
    this.tentative,
    this.amendeCategory,
    this.montantAfMin,
    this.montantAf,
    this.montantAfMaj,
    this.montantAfdMin,
    this.montantAfd,
    this.montantAfdMaj,
    this.controleAlcoolemie,
    this.depistageImpregnationAlcoolique,
    this.depistageStupefiants,
    this.retraitPoints,
    this.retentionPermisConduire,
    this.immobilisationVehicule,
    this.miseEnFourriere,
    this.elementMateriel,
    this.elementMoral,
    this.mesuresComplementaires,
    this.observations,
    this.nfiSection,
    this.nfiDivision,
    this.nfiGroupe,
    this.nfiClasse,
    this.nfiSousClasse,
  });

  factory NatinfUpdate.fromJson(Map<String, dynamic> json) =>
      _$NatinfUpdateFromJson(json);

  static const toJsonFactory = _$NatinfUpdateToJson;
  Map<String, dynamic> toJson() => _$NatinfUpdateToJson(this);

  @JsonKey(name: 'numero_natinf')
  final String numeroNatinf;
  @JsonKey(name: 'changements_commentaires')
  final String changementsCommentaires;
  @JsonKey(name: 'penalties', defaultValue: <NatinfPenaltyInput>[])
  final List<NatinfPenaltyInput>? penalties;
  @JsonKey(name: 'modes_proces_verbal', defaultValue: <int>[])
  final List<int>? modesProcesVerbal;
  @JsonKey(name: 'sanctions_encourues')
  final String? sanctionsEncourues;
  @JsonKey(name: 'tentative')
  final bool? tentative;
  @JsonKey(
    name: 'amende_category',
    toJson: natinfUpdateAmendeCategoryNullableToJson,
    fromJson: natinfUpdateAmendeCategoryNullableFromJson,
  )
  final enums.NatinfUpdateAmendeCategory? amendeCategory;
  @JsonKey(name: 'montant_af_min')
  final String? montantAfMin;
  @JsonKey(name: 'montant_af')
  final String? montantAf;
  @JsonKey(name: 'montant_af_maj')
  final String? montantAfMaj;
  @JsonKey(name: 'montant_afd_min')
  final String? montantAfdMin;
  @JsonKey(name: 'montant_afd')
  final String? montantAfd;
  @JsonKey(name: 'montant_afd_maj')
  final String? montantAfdMaj;
  @JsonKey(
    name: 'controle_alcoolemie',
    toJson: natinfUpdateControleAlcoolemieNullableToJson,
    fromJson: natinfUpdateControleAlcoolemieNullableFromJson,
  )
  final enums.NatinfUpdateControleAlcoolemie? controleAlcoolemie;
  @JsonKey(
    name: 'depistage_impregnation_alcoolique',
    toJson: natinfUpdateDepistageImpregnationAlcooliqueNullableToJson,
    fromJson: natinfUpdateDepistageImpregnationAlcooliqueNullableFromJson,
  )
  final enums.NatinfUpdateDepistageImpregnationAlcoolique?
  depistageImpregnationAlcoolique;
  @JsonKey(
    name: 'depistage_stupefiants',
    toJson: natinfUpdateDepistageStupefiantsNullableToJson,
    fromJson: natinfUpdateDepistageStupefiantsNullableFromJson,
  )
  final enums.NatinfUpdateDepistageStupefiants? depistageStupefiants;
  @JsonKey(name: 'retrait_points')
  final int? retraitPoints;
  @JsonKey(
    name: 'retention_permis_conduire',
    toJson: natinfUpdateRetentionPermisConduireNullableToJson,
    fromJson: natinfUpdateRetentionPermisConduireNullableFromJson,
  )
  final enums.NatinfUpdateRetentionPermisConduire? retentionPermisConduire;
  @JsonKey(
    name: 'immobilisation_vehicule',
    toJson: natinfUpdateImmobilisationVehiculeNullableToJson,
    fromJson: natinfUpdateImmobilisationVehiculeNullableFromJson,
  )
  final enums.NatinfUpdateImmobilisationVehicule? immobilisationVehicule;
  @JsonKey(
    name: 'mise_en_fourriere',
    toJson: natinfUpdateMiseEnFourriereNullableToJson,
    fromJson: natinfUpdateMiseEnFourriereNullableFromJson,
  )
  final enums.NatinfUpdateMiseEnFourriere? miseEnFourriere;
  @JsonKey(name: 'element_materiel')
  final String? elementMateriel;
  @JsonKey(name: 'element_moral')
  final String? elementMoral;
  @JsonKey(name: 'mesures_complementaires')
  final String? mesuresComplementaires;
  @JsonKey(name: 'observations')
  final String? observations;
  @JsonKey(name: 'nfi_section')
  final String? nfiSection;
  @JsonKey(name: 'nfi_division')
  final String? nfiDivision;
  @JsonKey(name: 'nfi_groupe')
  final String? nfiGroupe;
  @JsonKey(name: 'nfi_classe')
  final String? nfiClasse;
  @JsonKey(name: 'nfi_sous_classe')
  final String? nfiSousClasse;
  static const fromJsonFactory = _$NatinfUpdateFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is NatinfUpdate &&
            (identical(other.numeroNatinf, numeroNatinf) ||
                const DeepCollectionEquality().equals(
                  other.numeroNatinf,
                  numeroNatinf,
                )) &&
            (identical(
                  other.changementsCommentaires,
                  changementsCommentaires,
                ) ||
                const DeepCollectionEquality().equals(
                  other.changementsCommentaires,
                  changementsCommentaires,
                )) &&
            (identical(other.penalties, penalties) ||
                const DeepCollectionEquality().equals(
                  other.penalties,
                  penalties,
                )) &&
            (identical(other.modesProcesVerbal, modesProcesVerbal) ||
                const DeepCollectionEquality().equals(
                  other.modesProcesVerbal,
                  modesProcesVerbal,
                )) &&
            (identical(other.sanctionsEncourues, sanctionsEncourues) ||
                const DeepCollectionEquality().equals(
                  other.sanctionsEncourues,
                  sanctionsEncourues,
                )) &&
            (identical(other.tentative, tentative) ||
                const DeepCollectionEquality().equals(
                  other.tentative,
                  tentative,
                )) &&
            (identical(other.amendeCategory, amendeCategory) ||
                const DeepCollectionEquality().equals(
                  other.amendeCategory,
                  amendeCategory,
                )) &&
            (identical(other.montantAfMin, montantAfMin) ||
                const DeepCollectionEquality().equals(
                  other.montantAfMin,
                  montantAfMin,
                )) &&
            (identical(other.montantAf, montantAf) ||
                const DeepCollectionEquality().equals(
                  other.montantAf,
                  montantAf,
                )) &&
            (identical(other.montantAfMaj, montantAfMaj) ||
                const DeepCollectionEquality().equals(
                  other.montantAfMaj,
                  montantAfMaj,
                )) &&
            (identical(other.montantAfdMin, montantAfdMin) ||
                const DeepCollectionEquality().equals(
                  other.montantAfdMin,
                  montantAfdMin,
                )) &&
            (identical(other.montantAfd, montantAfd) ||
                const DeepCollectionEquality().equals(
                  other.montantAfd,
                  montantAfd,
                )) &&
            (identical(other.montantAfdMaj, montantAfdMaj) ||
                const DeepCollectionEquality().equals(
                  other.montantAfdMaj,
                  montantAfdMaj,
                )) &&
            (identical(other.controleAlcoolemie, controleAlcoolemie) ||
                const DeepCollectionEquality().equals(
                  other.controleAlcoolemie,
                  controleAlcoolemie,
                )) &&
            (identical(
                  other.depistageImpregnationAlcoolique,
                  depistageImpregnationAlcoolique,
                ) ||
                const DeepCollectionEquality().equals(
                  other.depistageImpregnationAlcoolique,
                  depistageImpregnationAlcoolique,
                )) &&
            (identical(other.depistageStupefiants, depistageStupefiants) ||
                const DeepCollectionEquality().equals(
                  other.depistageStupefiants,
                  depistageStupefiants,
                )) &&
            (identical(other.retraitPoints, retraitPoints) ||
                const DeepCollectionEquality().equals(
                  other.retraitPoints,
                  retraitPoints,
                )) &&
            (identical(
                  other.retentionPermisConduire,
                  retentionPermisConduire,
                ) ||
                const DeepCollectionEquality().equals(
                  other.retentionPermisConduire,
                  retentionPermisConduire,
                )) &&
            (identical(other.immobilisationVehicule, immobilisationVehicule) ||
                const DeepCollectionEquality().equals(
                  other.immobilisationVehicule,
                  immobilisationVehicule,
                )) &&
            (identical(other.miseEnFourriere, miseEnFourriere) ||
                const DeepCollectionEquality().equals(
                  other.miseEnFourriere,
                  miseEnFourriere,
                )) &&
            (identical(other.elementMateriel, elementMateriel) ||
                const DeepCollectionEquality().equals(
                  other.elementMateriel,
                  elementMateriel,
                )) &&
            (identical(other.elementMoral, elementMoral) ||
                const DeepCollectionEquality().equals(
                  other.elementMoral,
                  elementMoral,
                )) &&
            (identical(other.mesuresComplementaires, mesuresComplementaires) ||
                const DeepCollectionEquality().equals(
                  other.mesuresComplementaires,
                  mesuresComplementaires,
                )) &&
            (identical(other.observations, observations) ||
                const DeepCollectionEquality().equals(
                  other.observations,
                  observations,
                )) &&
            (identical(other.nfiSection, nfiSection) ||
                const DeepCollectionEquality().equals(
                  other.nfiSection,
                  nfiSection,
                )) &&
            (identical(other.nfiDivision, nfiDivision) ||
                const DeepCollectionEquality().equals(
                  other.nfiDivision,
                  nfiDivision,
                )) &&
            (identical(other.nfiGroupe, nfiGroupe) ||
                const DeepCollectionEquality().equals(
                  other.nfiGroupe,
                  nfiGroupe,
                )) &&
            (identical(other.nfiClasse, nfiClasse) ||
                const DeepCollectionEquality().equals(
                  other.nfiClasse,
                  nfiClasse,
                )) &&
            (identical(other.nfiSousClasse, nfiSousClasse) ||
                const DeepCollectionEquality().equals(
                  other.nfiSousClasse,
                  nfiSousClasse,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(numeroNatinf) ^
      const DeepCollectionEquality().hash(changementsCommentaires) ^
      const DeepCollectionEquality().hash(penalties) ^
      const DeepCollectionEquality().hash(modesProcesVerbal) ^
      const DeepCollectionEquality().hash(sanctionsEncourues) ^
      const DeepCollectionEquality().hash(tentative) ^
      const DeepCollectionEquality().hash(amendeCategory) ^
      const DeepCollectionEquality().hash(montantAfMin) ^
      const DeepCollectionEquality().hash(montantAf) ^
      const DeepCollectionEquality().hash(montantAfMaj) ^
      const DeepCollectionEquality().hash(montantAfdMin) ^
      const DeepCollectionEquality().hash(montantAfd) ^
      const DeepCollectionEquality().hash(montantAfdMaj) ^
      const DeepCollectionEquality().hash(controleAlcoolemie) ^
      const DeepCollectionEquality().hash(depistageImpregnationAlcoolique) ^
      const DeepCollectionEquality().hash(depistageStupefiants) ^
      const DeepCollectionEquality().hash(retraitPoints) ^
      const DeepCollectionEquality().hash(retentionPermisConduire) ^
      const DeepCollectionEquality().hash(immobilisationVehicule) ^
      const DeepCollectionEquality().hash(miseEnFourriere) ^
      const DeepCollectionEquality().hash(elementMateriel) ^
      const DeepCollectionEquality().hash(elementMoral) ^
      const DeepCollectionEquality().hash(mesuresComplementaires) ^
      const DeepCollectionEquality().hash(observations) ^
      const DeepCollectionEquality().hash(nfiSection) ^
      const DeepCollectionEquality().hash(nfiDivision) ^
      const DeepCollectionEquality().hash(nfiGroupe) ^
      const DeepCollectionEquality().hash(nfiClasse) ^
      const DeepCollectionEquality().hash(nfiSousClasse) ^
      runtimeType.hashCode;
}

extension $NatinfUpdateExtension on NatinfUpdate {
  NatinfUpdate copyWith({
    String? numeroNatinf,
    String? changementsCommentaires,
    List<NatinfPenaltyInput>? penalties,
    List<int>? modesProcesVerbal,
    String? sanctionsEncourues,
    bool? tentative,
    enums.NatinfUpdateAmendeCategory? amendeCategory,
    String? montantAfMin,
    String? montantAf,
    String? montantAfMaj,
    String? montantAfdMin,
    String? montantAfd,
    String? montantAfdMaj,
    enums.NatinfUpdateControleAlcoolemie? controleAlcoolemie,
    enums.NatinfUpdateDepistageImpregnationAlcoolique?
    depistageImpregnationAlcoolique,
    enums.NatinfUpdateDepistageStupefiants? depistageStupefiants,
    int? retraitPoints,
    enums.NatinfUpdateRetentionPermisConduire? retentionPermisConduire,
    enums.NatinfUpdateImmobilisationVehicule? immobilisationVehicule,
    enums.NatinfUpdateMiseEnFourriere? miseEnFourriere,
    String? elementMateriel,
    String? elementMoral,
    String? mesuresComplementaires,
    String? observations,
    String? nfiSection,
    String? nfiDivision,
    String? nfiGroupe,
    String? nfiClasse,
    String? nfiSousClasse,
  }) {
    return NatinfUpdate(
      numeroNatinf: numeroNatinf ?? this.numeroNatinf,
      changementsCommentaires:
          changementsCommentaires ?? this.changementsCommentaires,
      penalties: penalties ?? this.penalties,
      modesProcesVerbal: modesProcesVerbal ?? this.modesProcesVerbal,
      sanctionsEncourues: sanctionsEncourues ?? this.sanctionsEncourues,
      tentative: tentative ?? this.tentative,
      amendeCategory: amendeCategory ?? this.amendeCategory,
      montantAfMin: montantAfMin ?? this.montantAfMin,
      montantAf: montantAf ?? this.montantAf,
      montantAfMaj: montantAfMaj ?? this.montantAfMaj,
      montantAfdMin: montantAfdMin ?? this.montantAfdMin,
      montantAfd: montantAfd ?? this.montantAfd,
      montantAfdMaj: montantAfdMaj ?? this.montantAfdMaj,
      controleAlcoolemie: controleAlcoolemie ?? this.controleAlcoolemie,
      depistageImpregnationAlcoolique:
          depistageImpregnationAlcoolique ??
          this.depistageImpregnationAlcoolique,
      depistageStupefiants: depistageStupefiants ?? this.depistageStupefiants,
      retraitPoints: retraitPoints ?? this.retraitPoints,
      retentionPermisConduire:
          retentionPermisConduire ?? this.retentionPermisConduire,
      immobilisationVehicule:
          immobilisationVehicule ?? this.immobilisationVehicule,
      miseEnFourriere: miseEnFourriere ?? this.miseEnFourriere,
      elementMateriel: elementMateriel ?? this.elementMateriel,
      elementMoral: elementMoral ?? this.elementMoral,
      mesuresComplementaires:
          mesuresComplementaires ?? this.mesuresComplementaires,
      observations: observations ?? this.observations,
      nfiSection: nfiSection ?? this.nfiSection,
      nfiDivision: nfiDivision ?? this.nfiDivision,
      nfiGroupe: nfiGroupe ?? this.nfiGroupe,
      nfiClasse: nfiClasse ?? this.nfiClasse,
      nfiSousClasse: nfiSousClasse ?? this.nfiSousClasse,
    );
  }

  NatinfUpdate copyWithWrapped({
    Wrapped<String>? numeroNatinf,
    Wrapped<String>? changementsCommentaires,
    Wrapped<List<NatinfPenaltyInput>?>? penalties,
    Wrapped<List<int>?>? modesProcesVerbal,
    Wrapped<String?>? sanctionsEncourues,
    Wrapped<bool?>? tentative,
    Wrapped<enums.NatinfUpdateAmendeCategory?>? amendeCategory,
    Wrapped<String?>? montantAfMin,
    Wrapped<String?>? montantAf,
    Wrapped<String?>? montantAfMaj,
    Wrapped<String?>? montantAfdMin,
    Wrapped<String?>? montantAfd,
    Wrapped<String?>? montantAfdMaj,
    Wrapped<enums.NatinfUpdateControleAlcoolemie?>? controleAlcoolemie,
    Wrapped<enums.NatinfUpdateDepistageImpregnationAlcoolique?>?
    depistageImpregnationAlcoolique,
    Wrapped<enums.NatinfUpdateDepistageStupefiants?>? depistageStupefiants,
    Wrapped<int?>? retraitPoints,
    Wrapped<enums.NatinfUpdateRetentionPermisConduire?>?
    retentionPermisConduire,
    Wrapped<enums.NatinfUpdateImmobilisationVehicule?>? immobilisationVehicule,
    Wrapped<enums.NatinfUpdateMiseEnFourriere?>? miseEnFourriere,
    Wrapped<String?>? elementMateriel,
    Wrapped<String?>? elementMoral,
    Wrapped<String?>? mesuresComplementaires,
    Wrapped<String?>? observations,
    Wrapped<String?>? nfiSection,
    Wrapped<String?>? nfiDivision,
    Wrapped<String?>? nfiGroupe,
    Wrapped<String?>? nfiClasse,
    Wrapped<String?>? nfiSousClasse,
  }) {
    return NatinfUpdate(
      numeroNatinf:
          (numeroNatinf != null ? numeroNatinf.value : this.numeroNatinf),
      changementsCommentaires:
          (changementsCommentaires != null
              ? changementsCommentaires.value
              : this.changementsCommentaires),
      penalties: (penalties != null ? penalties.value : this.penalties),
      modesProcesVerbal:
          (modesProcesVerbal != null
              ? modesProcesVerbal.value
              : this.modesProcesVerbal),
      sanctionsEncourues:
          (sanctionsEncourues != null
              ? sanctionsEncourues.value
              : this.sanctionsEncourues),
      tentative: (tentative != null ? tentative.value : this.tentative),
      amendeCategory:
          (amendeCategory != null ? amendeCategory.value : this.amendeCategory),
      montantAfMin:
          (montantAfMin != null ? montantAfMin.value : this.montantAfMin),
      montantAf: (montantAf != null ? montantAf.value : this.montantAf),
      montantAfMaj:
          (montantAfMaj != null ? montantAfMaj.value : this.montantAfMaj),
      montantAfdMin:
          (montantAfdMin != null ? montantAfdMin.value : this.montantAfdMin),
      montantAfd: (montantAfd != null ? montantAfd.value : this.montantAfd),
      montantAfdMaj:
          (montantAfdMaj != null ? montantAfdMaj.value : this.montantAfdMaj),
      controleAlcoolemie:
          (controleAlcoolemie != null
              ? controleAlcoolemie.value
              : this.controleAlcoolemie),
      depistageImpregnationAlcoolique:
          (depistageImpregnationAlcoolique != null
              ? depistageImpregnationAlcoolique.value
              : this.depistageImpregnationAlcoolique),
      depistageStupefiants:
          (depistageStupefiants != null
              ? depistageStupefiants.value
              : this.depistageStupefiants),
      retraitPoints:
          (retraitPoints != null ? retraitPoints.value : this.retraitPoints),
      retentionPermisConduire:
          (retentionPermisConduire != null
              ? retentionPermisConduire.value
              : this.retentionPermisConduire),
      immobilisationVehicule:
          (immobilisationVehicule != null
              ? immobilisationVehicule.value
              : this.immobilisationVehicule),
      miseEnFourriere:
          (miseEnFourriere != null
              ? miseEnFourriere.value
              : this.miseEnFourriere),
      elementMateriel:
          (elementMateriel != null
              ? elementMateriel.value
              : this.elementMateriel),
      elementMoral:
          (elementMoral != null ? elementMoral.value : this.elementMoral),
      mesuresComplementaires:
          (mesuresComplementaires != null
              ? mesuresComplementaires.value
              : this.mesuresComplementaires),
      observations:
          (observations != null ? observations.value : this.observations),
      nfiSection: (nfiSection != null ? nfiSection.value : this.nfiSection),
      nfiDivision: (nfiDivision != null ? nfiDivision.value : this.nfiDivision),
      nfiGroupe: (nfiGroupe != null ? nfiGroupe.value : this.nfiGroupe),
      nfiClasse: (nfiClasse != null ? nfiClasse.value : this.nfiClasse),
      nfiSousClasse:
          (nfiSousClasse != null ? nfiSousClasse.value : this.nfiSousClasse),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfSearch {
  const NatinfSearch({
    this.id,
    this.natureInfraction,
    this.qualificationInfraction,
    this.definiePar,
    this.reprimeePar,
    this.references,
    this.categories,
    this.peinesPrincipales,
    this.peinesComplementaires,
    this.docsProAvailable,
    this.docsPro,
    this.numeroNatinf,
    this.sanctionsEncourues,
    this.tentative,
    this.amendeCategory,
    this.montantAfMin,
    this.montantAf,
    this.montantAfMaj,
    this.montantAfdMin,
    this.montantAfd,
    this.montantAfdMaj,
    this.controleAlcoolemie,
    this.depistageImpregnationAlcoolique,
    this.depistageStupefiants,
    this.retraitPoints,
    this.retentionPermisConduire,
    this.immobilisationVehicule,
    this.miseEnFourriere,
    this.elementMateriel,
    this.elementMoral,
    this.mesuresComplementaires,
    this.observations,
    this.lastEdited,
    this.obsoleteDate,
    required this.dacgSource,
    this.nfiSection,
    this.nfiDivision,
    this.nfiGroupe,
    this.nfiClasse,
    this.nfiSousClasse,
    this.modesProcesVerbal,
  });

  factory NatinfSearch.fromJson(Map<String, dynamic> json) =>
      _$NatinfSearchFromJson(json);

  static const toJsonFactory = _$NatinfSearchToJson;
  Map<String, dynamic> toJson() => _$NatinfSearchToJson(this);

  @JsonKey(name: 'id')
  final int? id;
  @JsonKey(name: 'nature_infraction')
  final String? natureInfraction;
  @JsonKey(name: 'qualification_infraction')
  final String? qualificationInfraction;
  @JsonKey(name: 'definie_par')
  final String? definiePar;
  @JsonKey(name: 'reprimee_par')
  final String? reprimeePar;
  @JsonKey(name: 'references', defaultValue: <NatinfReference>[])
  final List<NatinfReference>? references;
  @JsonKey(name: 'categories', defaultValue: <Category>[])
  final List<Category>? categories;
  @JsonKey(name: 'peines_principales', defaultValue: <NatinfPenalty>[])
  final List<NatinfPenalty>? peinesPrincipales;
  @JsonKey(name: 'peines_complementaires', defaultValue: <NatinfPenalty>[])
  final List<NatinfPenalty>? peinesComplementaires;
  @JsonKey(name: 'docs_pro_available')
  final String? docsProAvailable;
  @JsonKey(name: 'docs_pro')
  final String? docsPro;
  @JsonKey(name: 'numero_natinf')
  final String? numeroNatinf;
  @JsonKey(name: 'sanctions_encourues')
  final String? sanctionsEncourues;
  @JsonKey(name: 'tentative')
  final bool? tentative;
  @JsonKey(
    name: 'amende_category',
    toJson: natinfSearchAmendeCategoryNullableToJson,
    fromJson: natinfSearchAmendeCategoryNullableFromJson,
  )
  final enums.NatinfSearchAmendeCategory? amendeCategory;
  @JsonKey(name: 'montant_af_min')
  final String? montantAfMin;
  @JsonKey(name: 'montant_af')
  final String? montantAf;
  @JsonKey(name: 'montant_af_maj')
  final String? montantAfMaj;
  @JsonKey(name: 'montant_afd_min')
  final String? montantAfdMin;
  @JsonKey(name: 'montant_afd')
  final String? montantAfd;
  @JsonKey(name: 'montant_afd_maj')
  final String? montantAfdMaj;
  @JsonKey(
    name: 'controle_alcoolemie',
    toJson: natinfSearchControleAlcoolemieNullableToJson,
    fromJson: natinfSearchControleAlcoolemieNullableFromJson,
  )
  final enums.NatinfSearchControleAlcoolemie? controleAlcoolemie;
  @JsonKey(
    name: 'depistage_impregnation_alcoolique',
    toJson: natinfSearchDepistageImpregnationAlcooliqueNullableToJson,
    fromJson: natinfSearchDepistageImpregnationAlcooliqueNullableFromJson,
  )
  final enums.NatinfSearchDepistageImpregnationAlcoolique?
  depistageImpregnationAlcoolique;
  @JsonKey(
    name: 'depistage_stupefiants',
    toJson: natinfSearchDepistageStupefiantsNullableToJson,
    fromJson: natinfSearchDepistageStupefiantsNullableFromJson,
  )
  final enums.NatinfSearchDepistageStupefiants? depistageStupefiants;
  @JsonKey(name: 'retrait_points')
  final int? retraitPoints;
  @JsonKey(
    name: 'retention_permis_conduire',
    toJson: natinfSearchRetentionPermisConduireNullableToJson,
    fromJson: natinfSearchRetentionPermisConduireNullableFromJson,
  )
  final enums.NatinfSearchRetentionPermisConduire? retentionPermisConduire;
  @JsonKey(
    name: 'immobilisation_vehicule',
    toJson: natinfSearchImmobilisationVehiculeNullableToJson,
    fromJson: natinfSearchImmobilisationVehiculeNullableFromJson,
  )
  final enums.NatinfSearchImmobilisationVehicule? immobilisationVehicule;
  @JsonKey(
    name: 'mise_en_fourriere',
    toJson: natinfSearchMiseEnFourriereNullableToJson,
    fromJson: natinfSearchMiseEnFourriereNullableFromJson,
  )
  final enums.NatinfSearchMiseEnFourriere? miseEnFourriere;
  @JsonKey(name: 'element_materiel')
  final String? elementMateriel;
  @JsonKey(name: 'element_moral')
  final String? elementMoral;
  @JsonKey(name: 'mesures_complementaires')
  final String? mesuresComplementaires;
  @JsonKey(name: 'observations')
  final String? observations;
  @JsonKey(name: 'last_edited')
  final DateTime? lastEdited;
  @JsonKey(name: 'obsolete_date', toJson: _dateToJson)
  final DateTime? obsoleteDate;
  @JsonKey(name: 'dacg_source')
  final int dacgSource;
  @JsonKey(name: 'nfi_section')
  final String? nfiSection;
  @JsonKey(name: 'nfi_division')
  final String? nfiDivision;
  @JsonKey(name: 'nfi_groupe')
  final String? nfiGroupe;
  @JsonKey(name: 'nfi_classe')
  final String? nfiClasse;
  @JsonKey(name: 'nfi_sous_classe')
  final String? nfiSousClasse;
  @JsonKey(name: 'modes_proces_verbal', defaultValue: <int>[])
  final List<int>? modesProcesVerbal;
  static const fromJsonFactory = _$NatinfSearchFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is NatinfSearch &&
            (identical(other.id, id) ||
                const DeepCollectionEquality().equals(other.id, id)) &&
            (identical(other.natureInfraction, natureInfraction) ||
                const DeepCollectionEquality().equals(
                  other.natureInfraction,
                  natureInfraction,
                )) &&
            (identical(
                  other.qualificationInfraction,
                  qualificationInfraction,
                ) ||
                const DeepCollectionEquality().equals(
                  other.qualificationInfraction,
                  qualificationInfraction,
                )) &&
            (identical(other.definiePar, definiePar) ||
                const DeepCollectionEquality().equals(
                  other.definiePar,
                  definiePar,
                )) &&
            (identical(other.reprimeePar, reprimeePar) ||
                const DeepCollectionEquality().equals(
                  other.reprimeePar,
                  reprimeePar,
                )) &&
            (identical(other.references, references) ||
                const DeepCollectionEquality().equals(
                  other.references,
                  references,
                )) &&
            (identical(other.categories, categories) ||
                const DeepCollectionEquality().equals(
                  other.categories,
                  categories,
                )) &&
            (identical(other.peinesPrincipales, peinesPrincipales) ||
                const DeepCollectionEquality().equals(
                  other.peinesPrincipales,
                  peinesPrincipales,
                )) &&
            (identical(other.peinesComplementaires, peinesComplementaires) ||
                const DeepCollectionEquality().equals(
                  other.peinesComplementaires,
                  peinesComplementaires,
                )) &&
            (identical(other.docsProAvailable, docsProAvailable) ||
                const DeepCollectionEquality().equals(
                  other.docsProAvailable,
                  docsProAvailable,
                )) &&
            (identical(other.docsPro, docsPro) ||
                const DeepCollectionEquality().equals(
                  other.docsPro,
                  docsPro,
                )) &&
            (identical(other.numeroNatinf, numeroNatinf) ||
                const DeepCollectionEquality().equals(
                  other.numeroNatinf,
                  numeroNatinf,
                )) &&
            (identical(other.sanctionsEncourues, sanctionsEncourues) ||
                const DeepCollectionEquality().equals(
                  other.sanctionsEncourues,
                  sanctionsEncourues,
                )) &&
            (identical(other.tentative, tentative) ||
                const DeepCollectionEquality().equals(
                  other.tentative,
                  tentative,
                )) &&
            (identical(other.amendeCategory, amendeCategory) ||
                const DeepCollectionEquality().equals(
                  other.amendeCategory,
                  amendeCategory,
                )) &&
            (identical(other.montantAfMin, montantAfMin) ||
                const DeepCollectionEquality().equals(
                  other.montantAfMin,
                  montantAfMin,
                )) &&
            (identical(other.montantAf, montantAf) ||
                const DeepCollectionEquality().equals(
                  other.montantAf,
                  montantAf,
                )) &&
            (identical(other.montantAfMaj, montantAfMaj) ||
                const DeepCollectionEquality().equals(
                  other.montantAfMaj,
                  montantAfMaj,
                )) &&
            (identical(other.montantAfdMin, montantAfdMin) ||
                const DeepCollectionEquality().equals(
                  other.montantAfdMin,
                  montantAfdMin,
                )) &&
            (identical(other.montantAfd, montantAfd) ||
                const DeepCollectionEquality().equals(
                  other.montantAfd,
                  montantAfd,
                )) &&
            (identical(other.montantAfdMaj, montantAfdMaj) ||
                const DeepCollectionEquality().equals(
                  other.montantAfdMaj,
                  montantAfdMaj,
                )) &&
            (identical(other.controleAlcoolemie, controleAlcoolemie) ||
                const DeepCollectionEquality().equals(
                  other.controleAlcoolemie,
                  controleAlcoolemie,
                )) &&
            (identical(
                  other.depistageImpregnationAlcoolique,
                  depistageImpregnationAlcoolique,
                ) ||
                const DeepCollectionEquality().equals(
                  other.depistageImpregnationAlcoolique,
                  depistageImpregnationAlcoolique,
                )) &&
            (identical(other.depistageStupefiants, depistageStupefiants) ||
                const DeepCollectionEquality().equals(
                  other.depistageStupefiants,
                  depistageStupefiants,
                )) &&
            (identical(other.retraitPoints, retraitPoints) ||
                const DeepCollectionEquality().equals(
                  other.retraitPoints,
                  retraitPoints,
                )) &&
            (identical(
                  other.retentionPermisConduire,
                  retentionPermisConduire,
                ) ||
                const DeepCollectionEquality().equals(
                  other.retentionPermisConduire,
                  retentionPermisConduire,
                )) &&
            (identical(other.immobilisationVehicule, immobilisationVehicule) ||
                const DeepCollectionEquality().equals(
                  other.immobilisationVehicule,
                  immobilisationVehicule,
                )) &&
            (identical(other.miseEnFourriere, miseEnFourriere) ||
                const DeepCollectionEquality().equals(
                  other.miseEnFourriere,
                  miseEnFourriere,
                )) &&
            (identical(other.elementMateriel, elementMateriel) ||
                const DeepCollectionEquality().equals(
                  other.elementMateriel,
                  elementMateriel,
                )) &&
            (identical(other.elementMoral, elementMoral) ||
                const DeepCollectionEquality().equals(
                  other.elementMoral,
                  elementMoral,
                )) &&
            (identical(other.mesuresComplementaires, mesuresComplementaires) ||
                const DeepCollectionEquality().equals(
                  other.mesuresComplementaires,
                  mesuresComplementaires,
                )) &&
            (identical(other.observations, observations) ||
                const DeepCollectionEquality().equals(
                  other.observations,
                  observations,
                )) &&
            (identical(other.lastEdited, lastEdited) ||
                const DeepCollectionEquality().equals(
                  other.lastEdited,
                  lastEdited,
                )) &&
            (identical(other.obsoleteDate, obsoleteDate) ||
                const DeepCollectionEquality().equals(
                  other.obsoleteDate,
                  obsoleteDate,
                )) &&
            (identical(other.dacgSource, dacgSource) ||
                const DeepCollectionEquality().equals(
                  other.dacgSource,
                  dacgSource,
                )) &&
            (identical(other.nfiSection, nfiSection) ||
                const DeepCollectionEquality().equals(
                  other.nfiSection,
                  nfiSection,
                )) &&
            (identical(other.nfiDivision, nfiDivision) ||
                const DeepCollectionEquality().equals(
                  other.nfiDivision,
                  nfiDivision,
                )) &&
            (identical(other.nfiGroupe, nfiGroupe) ||
                const DeepCollectionEquality().equals(
                  other.nfiGroupe,
                  nfiGroupe,
                )) &&
            (identical(other.nfiClasse, nfiClasse) ||
                const DeepCollectionEquality().equals(
                  other.nfiClasse,
                  nfiClasse,
                )) &&
            (identical(other.nfiSousClasse, nfiSousClasse) ||
                const DeepCollectionEquality().equals(
                  other.nfiSousClasse,
                  nfiSousClasse,
                )) &&
            (identical(other.modesProcesVerbal, modesProcesVerbal) ||
                const DeepCollectionEquality().equals(
                  other.modesProcesVerbal,
                  modesProcesVerbal,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(id) ^
      const DeepCollectionEquality().hash(natureInfraction) ^
      const DeepCollectionEquality().hash(qualificationInfraction) ^
      const DeepCollectionEquality().hash(definiePar) ^
      const DeepCollectionEquality().hash(reprimeePar) ^
      const DeepCollectionEquality().hash(references) ^
      const DeepCollectionEquality().hash(categories) ^
      const DeepCollectionEquality().hash(peinesPrincipales) ^
      const DeepCollectionEquality().hash(peinesComplementaires) ^
      const DeepCollectionEquality().hash(docsProAvailable) ^
      const DeepCollectionEquality().hash(docsPro) ^
      const DeepCollectionEquality().hash(numeroNatinf) ^
      const DeepCollectionEquality().hash(sanctionsEncourues) ^
      const DeepCollectionEquality().hash(tentative) ^
      const DeepCollectionEquality().hash(amendeCategory) ^
      const DeepCollectionEquality().hash(montantAfMin) ^
      const DeepCollectionEquality().hash(montantAf) ^
      const DeepCollectionEquality().hash(montantAfMaj) ^
      const DeepCollectionEquality().hash(montantAfdMin) ^
      const DeepCollectionEquality().hash(montantAfd) ^
      const DeepCollectionEquality().hash(montantAfdMaj) ^
      const DeepCollectionEquality().hash(controleAlcoolemie) ^
      const DeepCollectionEquality().hash(depistageImpregnationAlcoolique) ^
      const DeepCollectionEquality().hash(depistageStupefiants) ^
      const DeepCollectionEquality().hash(retraitPoints) ^
      const DeepCollectionEquality().hash(retentionPermisConduire) ^
      const DeepCollectionEquality().hash(immobilisationVehicule) ^
      const DeepCollectionEquality().hash(miseEnFourriere) ^
      const DeepCollectionEquality().hash(elementMateriel) ^
      const DeepCollectionEquality().hash(elementMoral) ^
      const DeepCollectionEquality().hash(mesuresComplementaires) ^
      const DeepCollectionEquality().hash(observations) ^
      const DeepCollectionEquality().hash(lastEdited) ^
      const DeepCollectionEquality().hash(obsoleteDate) ^
      const DeepCollectionEquality().hash(dacgSource) ^
      const DeepCollectionEquality().hash(nfiSection) ^
      const DeepCollectionEquality().hash(nfiDivision) ^
      const DeepCollectionEquality().hash(nfiGroupe) ^
      const DeepCollectionEquality().hash(nfiClasse) ^
      const DeepCollectionEquality().hash(nfiSousClasse) ^
      const DeepCollectionEquality().hash(modesProcesVerbal) ^
      runtimeType.hashCode;
}

extension $NatinfSearchExtension on NatinfSearch {
  NatinfSearch copyWith({
    int? id,
    String? natureInfraction,
    String? qualificationInfraction,
    String? definiePar,
    String? reprimeePar,
    List<NatinfReference>? references,
    List<Category>? categories,
    List<NatinfPenalty>? peinesPrincipales,
    List<NatinfPenalty>? peinesComplementaires,
    String? docsProAvailable,
    String? docsPro,
    String? numeroNatinf,
    String? sanctionsEncourues,
    bool? tentative,
    enums.NatinfSearchAmendeCategory? amendeCategory,
    String? montantAfMin,
    String? montantAf,
    String? montantAfMaj,
    String? montantAfdMin,
    String? montantAfd,
    String? montantAfdMaj,
    enums.NatinfSearchControleAlcoolemie? controleAlcoolemie,
    enums.NatinfSearchDepistageImpregnationAlcoolique?
    depistageImpregnationAlcoolique,
    enums.NatinfSearchDepistageStupefiants? depistageStupefiants,
    int? retraitPoints,
    enums.NatinfSearchRetentionPermisConduire? retentionPermisConduire,
    enums.NatinfSearchImmobilisationVehicule? immobilisationVehicule,
    enums.NatinfSearchMiseEnFourriere? miseEnFourriere,
    String? elementMateriel,
    String? elementMoral,
    String? mesuresComplementaires,
    String? observations,
    DateTime? lastEdited,
    DateTime? obsoleteDate,
    int? dacgSource,
    String? nfiSection,
    String? nfiDivision,
    String? nfiGroupe,
    String? nfiClasse,
    String? nfiSousClasse,
    List<int>? modesProcesVerbal,
  }) {
    return NatinfSearch(
      id: id ?? this.id,
      natureInfraction: natureInfraction ?? this.natureInfraction,
      qualificationInfraction:
          qualificationInfraction ?? this.qualificationInfraction,
      definiePar: definiePar ?? this.definiePar,
      reprimeePar: reprimeePar ?? this.reprimeePar,
      references: references ?? this.references,
      categories: categories ?? this.categories,
      peinesPrincipales: peinesPrincipales ?? this.peinesPrincipales,
      peinesComplementaires:
          peinesComplementaires ?? this.peinesComplementaires,
      docsProAvailable: docsProAvailable ?? this.docsProAvailable,
      docsPro: docsPro ?? this.docsPro,
      numeroNatinf: numeroNatinf ?? this.numeroNatinf,
      sanctionsEncourues: sanctionsEncourues ?? this.sanctionsEncourues,
      tentative: tentative ?? this.tentative,
      amendeCategory: amendeCategory ?? this.amendeCategory,
      montantAfMin: montantAfMin ?? this.montantAfMin,
      montantAf: montantAf ?? this.montantAf,
      montantAfMaj: montantAfMaj ?? this.montantAfMaj,
      montantAfdMin: montantAfdMin ?? this.montantAfdMin,
      montantAfd: montantAfd ?? this.montantAfd,
      montantAfdMaj: montantAfdMaj ?? this.montantAfdMaj,
      controleAlcoolemie: controleAlcoolemie ?? this.controleAlcoolemie,
      depistageImpregnationAlcoolique:
          depistageImpregnationAlcoolique ??
          this.depistageImpregnationAlcoolique,
      depistageStupefiants: depistageStupefiants ?? this.depistageStupefiants,
      retraitPoints: retraitPoints ?? this.retraitPoints,
      retentionPermisConduire:
          retentionPermisConduire ?? this.retentionPermisConduire,
      immobilisationVehicule:
          immobilisationVehicule ?? this.immobilisationVehicule,
      miseEnFourriere: miseEnFourriere ?? this.miseEnFourriere,
      elementMateriel: elementMateriel ?? this.elementMateriel,
      elementMoral: elementMoral ?? this.elementMoral,
      mesuresComplementaires:
          mesuresComplementaires ?? this.mesuresComplementaires,
      observations: observations ?? this.observations,
      lastEdited: lastEdited ?? this.lastEdited,
      obsoleteDate: obsoleteDate ?? this.obsoleteDate,
      dacgSource: dacgSource ?? this.dacgSource,
      nfiSection: nfiSection ?? this.nfiSection,
      nfiDivision: nfiDivision ?? this.nfiDivision,
      nfiGroupe: nfiGroupe ?? this.nfiGroupe,
      nfiClasse: nfiClasse ?? this.nfiClasse,
      nfiSousClasse: nfiSousClasse ?? this.nfiSousClasse,
      modesProcesVerbal: modesProcesVerbal ?? this.modesProcesVerbal,
    );
  }

  NatinfSearch copyWithWrapped({
    Wrapped<int?>? id,
    Wrapped<String?>? natureInfraction,
    Wrapped<String?>? qualificationInfraction,
    Wrapped<String?>? definiePar,
    Wrapped<String?>? reprimeePar,
    Wrapped<List<NatinfReference>?>? references,
    Wrapped<List<Category>?>? categories,
    Wrapped<List<NatinfPenalty>?>? peinesPrincipales,
    Wrapped<List<NatinfPenalty>?>? peinesComplementaires,
    Wrapped<String?>? docsProAvailable,
    Wrapped<String?>? docsPro,
    Wrapped<String?>? numeroNatinf,
    Wrapped<String?>? sanctionsEncourues,
    Wrapped<bool?>? tentative,
    Wrapped<enums.NatinfSearchAmendeCategory?>? amendeCategory,
    Wrapped<String?>? montantAfMin,
    Wrapped<String?>? montantAf,
    Wrapped<String?>? montantAfMaj,
    Wrapped<String?>? montantAfdMin,
    Wrapped<String?>? montantAfd,
    Wrapped<String?>? montantAfdMaj,
    Wrapped<enums.NatinfSearchControleAlcoolemie?>? controleAlcoolemie,
    Wrapped<enums.NatinfSearchDepistageImpregnationAlcoolique?>?
    depistageImpregnationAlcoolique,
    Wrapped<enums.NatinfSearchDepistageStupefiants?>? depistageStupefiants,
    Wrapped<int?>? retraitPoints,
    Wrapped<enums.NatinfSearchRetentionPermisConduire?>?
    retentionPermisConduire,
    Wrapped<enums.NatinfSearchImmobilisationVehicule?>? immobilisationVehicule,
    Wrapped<enums.NatinfSearchMiseEnFourriere?>? miseEnFourriere,
    Wrapped<String?>? elementMateriel,
    Wrapped<String?>? elementMoral,
    Wrapped<String?>? mesuresComplementaires,
    Wrapped<String?>? observations,
    Wrapped<DateTime?>? lastEdited,
    Wrapped<DateTime?>? obsoleteDate,
    Wrapped<int>? dacgSource,
    Wrapped<String?>? nfiSection,
    Wrapped<String?>? nfiDivision,
    Wrapped<String?>? nfiGroupe,
    Wrapped<String?>? nfiClasse,
    Wrapped<String?>? nfiSousClasse,
    Wrapped<List<int>?>? modesProcesVerbal,
  }) {
    return NatinfSearch(
      id: (id != null ? id.value : this.id),
      natureInfraction:
          (natureInfraction != null
              ? natureInfraction.value
              : this.natureInfraction),
      qualificationInfraction:
          (qualificationInfraction != null
              ? qualificationInfraction.value
              : this.qualificationInfraction),
      definiePar: (definiePar != null ? definiePar.value : this.definiePar),
      reprimeePar: (reprimeePar != null ? reprimeePar.value : this.reprimeePar),
      references: (references != null ? references.value : this.references),
      categories: (categories != null ? categories.value : this.categories),
      peinesPrincipales:
          (peinesPrincipales != null
              ? peinesPrincipales.value
              : this.peinesPrincipales),
      peinesComplementaires:
          (peinesComplementaires != null
              ? peinesComplementaires.value
              : this.peinesComplementaires),
      docsProAvailable:
          (docsProAvailable != null
              ? docsProAvailable.value
              : this.docsProAvailable),
      docsPro: (docsPro != null ? docsPro.value : this.docsPro),
      numeroNatinf:
          (numeroNatinf != null ? numeroNatinf.value : this.numeroNatinf),
      sanctionsEncourues:
          (sanctionsEncourues != null
              ? sanctionsEncourues.value
              : this.sanctionsEncourues),
      tentative: (tentative != null ? tentative.value : this.tentative),
      amendeCategory:
          (amendeCategory != null ? amendeCategory.value : this.amendeCategory),
      montantAfMin:
          (montantAfMin != null ? montantAfMin.value : this.montantAfMin),
      montantAf: (montantAf != null ? montantAf.value : this.montantAf),
      montantAfMaj:
          (montantAfMaj != null ? montantAfMaj.value : this.montantAfMaj),
      montantAfdMin:
          (montantAfdMin != null ? montantAfdMin.value : this.montantAfdMin),
      montantAfd: (montantAfd != null ? montantAfd.value : this.montantAfd),
      montantAfdMaj:
          (montantAfdMaj != null ? montantAfdMaj.value : this.montantAfdMaj),
      controleAlcoolemie:
          (controleAlcoolemie != null
              ? controleAlcoolemie.value
              : this.controleAlcoolemie),
      depistageImpregnationAlcoolique:
          (depistageImpregnationAlcoolique != null
              ? depistageImpregnationAlcoolique.value
              : this.depistageImpregnationAlcoolique),
      depistageStupefiants:
          (depistageStupefiants != null
              ? depistageStupefiants.value
              : this.depistageStupefiants),
      retraitPoints:
          (retraitPoints != null ? retraitPoints.value : this.retraitPoints),
      retentionPermisConduire:
          (retentionPermisConduire != null
              ? retentionPermisConduire.value
              : this.retentionPermisConduire),
      immobilisationVehicule:
          (immobilisationVehicule != null
              ? immobilisationVehicule.value
              : this.immobilisationVehicule),
      miseEnFourriere:
          (miseEnFourriere != null
              ? miseEnFourriere.value
              : this.miseEnFourriere),
      elementMateriel:
          (elementMateriel != null
              ? elementMateriel.value
              : this.elementMateriel),
      elementMoral:
          (elementMoral != null ? elementMoral.value : this.elementMoral),
      mesuresComplementaires:
          (mesuresComplementaires != null
              ? mesuresComplementaires.value
              : this.mesuresComplementaires),
      observations:
          (observations != null ? observations.value : this.observations),
      lastEdited: (lastEdited != null ? lastEdited.value : this.lastEdited),
      obsoleteDate:
          (obsoleteDate != null ? obsoleteDate.value : this.obsoleteDate),
      dacgSource: (dacgSource != null ? dacgSource.value : this.dacgSource),
      nfiSection: (nfiSection != null ? nfiSection.value : this.nfiSection),
      nfiDivision: (nfiDivision != null ? nfiDivision.value : this.nfiDivision),
      nfiGroupe: (nfiGroupe != null ? nfiGroupe.value : this.nfiGroupe),
      nfiClasse: (nfiClasse != null ? nfiClasse.value : this.nfiClasse),
      nfiSousClasse:
          (nfiSousClasse != null ? nfiSousClasse.value : this.nfiSousClasse),
      modesProcesVerbal:
          (modesProcesVerbal != null
              ? modesProcesVerbal.value
              : this.modesProcesVerbal),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class PrintSelectionItem {
  const PrintSelectionItem({
    required this.numero,
    required this.nature,
    required this.qualification,
  });

  factory PrintSelectionItem.fromJson(Map<String, dynamic> json) =>
      _$PrintSelectionItemFromJson(json);

  static const toJsonFactory = _$PrintSelectionItemToJson;
  Map<String, dynamic> toJson() => _$PrintSelectionItemToJson(this);

  @JsonKey(name: 'numero')
  final String numero;
  @JsonKey(name: 'nature')
  final String nature;
  @JsonKey(name: 'qualification')
  final String qualification;
  static const fromJsonFactory = _$PrintSelectionItemFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is PrintSelectionItem &&
            (identical(other.numero, numero) ||
                const DeepCollectionEquality().equals(other.numero, numero)) &&
            (identical(other.nature, nature) ||
                const DeepCollectionEquality().equals(other.nature, nature)) &&
            (identical(other.qualification, qualification) ||
                const DeepCollectionEquality().equals(
                  other.qualification,
                  qualification,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(numero) ^
      const DeepCollectionEquality().hash(nature) ^
      const DeepCollectionEquality().hash(qualification) ^
      runtimeType.hashCode;
}

extension $PrintSelectionItemExtension on PrintSelectionItem {
  PrintSelectionItem copyWith({
    String? numero,
    String? nature,
    String? qualification,
  }) {
    return PrintSelectionItem(
      numero: numero ?? this.numero,
      nature: nature ?? this.nature,
      qualification: qualification ?? this.qualification,
    );
  }

  PrintSelectionItem copyWithWrapped({
    Wrapped<String>? numero,
    Wrapped<String>? nature,
    Wrapped<String>? qualification,
  }) {
    return PrintSelectionItem(
      numero: (numero != null ? numero.value : this.numero),
      nature: (nature != null ? nature.value : this.nature),
      qualification:
          (qualification != null ? qualification.value : this.qualification),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class LegifranceArticleGet$Response {
  const LegifranceArticleGet$Response({
    this.id,
    this.idTexte,
    this.type,
    this.texte,
    this.texteHtml,
    this.$num,
    this.origine,
    this.nature,
    this.versionArticle,
    this.etat,
    this.dateDebut,
    this.dateFin,
  });

  factory LegifranceArticleGet$Response.fromJson(Map<String, dynamic> json) =>
      _$LegifranceArticleGet$ResponseFromJson(json);

  static const toJsonFactory = _$LegifranceArticleGet$ResponseToJson;
  Map<String, dynamic> toJson() => _$LegifranceArticleGet$ResponseToJson(this);

  @JsonKey(name: 'id')
  final String? id;
  @JsonKey(name: 'idTexte')
  final String? idTexte;
  @JsonKey(name: 'type')
  final String? type;
  @JsonKey(name: 'texte')
  final String? texte;
  @JsonKey(name: 'texteHtml')
  final String? texteHtml;
  @JsonKey(name: 'num')
  final String? $num;
  @JsonKey(name: 'origine')
  final String? origine;
  @JsonKey(name: 'nature')
  final String? nature;
  @JsonKey(name: 'versionArticle')
  final String? versionArticle;
  @JsonKey(name: 'etat')
  final String? etat;
  @JsonKey(name: 'dateDebut')
  final double? dateDebut;
  @JsonKey(name: 'dateFin')
  final double? dateFin;
  static const fromJsonFactory = _$LegifranceArticleGet$ResponseFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is LegifranceArticleGet$Response &&
            (identical(other.id, id) ||
                const DeepCollectionEquality().equals(other.id, id)) &&
            (identical(other.idTexte, idTexte) ||
                const DeepCollectionEquality().equals(
                  other.idTexte,
                  idTexte,
                )) &&
            (identical(other.type, type) ||
                const DeepCollectionEquality().equals(other.type, type)) &&
            (identical(other.texte, texte) ||
                const DeepCollectionEquality().equals(other.texte, texte)) &&
            (identical(other.texteHtml, texteHtml) ||
                const DeepCollectionEquality().equals(
                  other.texteHtml,
                  texteHtml,
                )) &&
            (identical(other.$num, $num) ||
                const DeepCollectionEquality().equals(other.$num, $num)) &&
            (identical(other.origine, origine) ||
                const DeepCollectionEquality().equals(
                  other.origine,
                  origine,
                )) &&
            (identical(other.nature, nature) ||
                const DeepCollectionEquality().equals(other.nature, nature)) &&
            (identical(other.versionArticle, versionArticle) ||
                const DeepCollectionEquality().equals(
                  other.versionArticle,
                  versionArticle,
                )) &&
            (identical(other.etat, etat) ||
                const DeepCollectionEquality().equals(other.etat, etat)) &&
            (identical(other.dateDebut, dateDebut) ||
                const DeepCollectionEquality().equals(
                  other.dateDebut,
                  dateDebut,
                )) &&
            (identical(other.dateFin, dateFin) ||
                const DeepCollectionEquality().equals(other.dateFin, dateFin)));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(id) ^
      const DeepCollectionEquality().hash(idTexte) ^
      const DeepCollectionEquality().hash(type) ^
      const DeepCollectionEquality().hash(texte) ^
      const DeepCollectionEquality().hash(texteHtml) ^
      const DeepCollectionEquality().hash($num) ^
      const DeepCollectionEquality().hash(origine) ^
      const DeepCollectionEquality().hash(nature) ^
      const DeepCollectionEquality().hash(versionArticle) ^
      const DeepCollectionEquality().hash(etat) ^
      const DeepCollectionEquality().hash(dateDebut) ^
      const DeepCollectionEquality().hash(dateFin) ^
      runtimeType.hashCode;
}

extension $LegifranceArticleGet$ResponseExtension
    on LegifranceArticleGet$Response {
  LegifranceArticleGet$Response copyWith({
    String? id,
    String? idTexte,
    String? type,
    String? texte,
    String? texteHtml,
    String? $num,
    String? origine,
    String? nature,
    String? versionArticle,
    String? etat,
    double? dateDebut,
    double? dateFin,
  }) {
    return LegifranceArticleGet$Response(
      id: id ?? this.id,
      idTexte: idTexte ?? this.idTexte,
      type: type ?? this.type,
      texte: texte ?? this.texte,
      texteHtml: texteHtml ?? this.texteHtml,
      $num: $num ?? this.$num,
      origine: origine ?? this.origine,
      nature: nature ?? this.nature,
      versionArticle: versionArticle ?? this.versionArticle,
      etat: etat ?? this.etat,
      dateDebut: dateDebut ?? this.dateDebut,
      dateFin: dateFin ?? this.dateFin,
    );
  }

  LegifranceArticleGet$Response copyWithWrapped({
    Wrapped<String?>? id,
    Wrapped<String?>? idTexte,
    Wrapped<String?>? type,
    Wrapped<String?>? texte,
    Wrapped<String?>? texteHtml,
    Wrapped<String?>? $num,
    Wrapped<String?>? origine,
    Wrapped<String?>? nature,
    Wrapped<String?>? versionArticle,
    Wrapped<String?>? etat,
    Wrapped<double?>? dateDebut,
    Wrapped<double?>? dateFin,
  }) {
    return LegifranceArticleGet$Response(
      id: (id != null ? id.value : this.id),
      idTexte: (idTexte != null ? idTexte.value : this.idTexte),
      type: (type != null ? type.value : this.type),
      texte: (texte != null ? texte.value : this.texte),
      texteHtml: (texteHtml != null ? texteHtml.value : this.texteHtml),
      $num: ($num != null ? $num.value : this.$num),
      origine: (origine != null ? origine.value : this.origine),
      nature: (nature != null ? nature.value : this.nature),
      versionArticle:
          (versionArticle != null ? versionArticle.value : this.versionArticle),
      etat: (etat != null ? etat.value : this.etat),
      dateDebut: (dateDebut != null ? dateDebut.value : this.dateDebut),
      dateFin: (dateFin != null ? dateFin.value : this.dateFin),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class LegifranceIdGet$Response {
  const LegifranceIdGet$Response({this.articleId});

  factory LegifranceIdGet$Response.fromJson(Map<String, dynamic> json) =>
      _$LegifranceIdGet$ResponseFromJson(json);

  static const toJsonFactory = _$LegifranceIdGet$ResponseToJson;
  Map<String, dynamic> toJson() => _$LegifranceIdGet$ResponseToJson(this);

  @JsonKey(name: 'article_id')
  final String? articleId;
  static const fromJsonFactory = _$LegifranceIdGet$ResponseFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is LegifranceIdGet$Response &&
            (identical(other.articleId, articleId) ||
                const DeepCollectionEquality().equals(
                  other.articleId,
                  articleId,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(articleId) ^ runtimeType.hashCode;
}

extension $LegifranceIdGet$ResponseExtension on LegifranceIdGet$Response {
  LegifranceIdGet$Response copyWith({String? articleId}) {
    return LegifranceIdGet$Response(articleId: articleId ?? this.articleId);
  }

  LegifranceIdGet$Response copyWithWrapped({Wrapped<String?>? articleId}) {
    return LegifranceIdGet$Response(
      articleId: (articleId != null ? articleId.value : this.articleId),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfoNatinfNumeroNatinfArticlesGet$Response {
  const NatinfoNatinfNumeroNatinfArticlesGet$Response({
    this.definieArticlesData,
    this.reprimeeArticlesData,
  });

  factory NatinfoNatinfNumeroNatinfArticlesGet$Response.fromJson(
    Map<String, dynamic> json,
  ) => _$NatinfoNatinfNumeroNatinfArticlesGet$ResponseFromJson(json);

  static const toJsonFactory =
      _$NatinfoNatinfNumeroNatinfArticlesGet$ResponseToJson;
  Map<String, dynamic> toJson() =>
      _$NatinfoNatinfNumeroNatinfArticlesGet$ResponseToJson(this);

  @JsonKey(name: 'definie_articles_data')
  final List<
    NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item
  >?
  definieArticlesData;
  @JsonKey(name: 'reprimee_articles_data')
  final List<
    NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item
  >?
  reprimeeArticlesData;
  static const fromJsonFactory =
      _$NatinfoNatinfNumeroNatinfArticlesGet$ResponseFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is NatinfoNatinfNumeroNatinfArticlesGet$Response &&
            (identical(other.definieArticlesData, definieArticlesData) ||
                const DeepCollectionEquality().equals(
                  other.definieArticlesData,
                  definieArticlesData,
                )) &&
            (identical(other.reprimeeArticlesData, reprimeeArticlesData) ||
                const DeepCollectionEquality().equals(
                  other.reprimeeArticlesData,
                  reprimeeArticlesData,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(definieArticlesData) ^
      const DeepCollectionEquality().hash(reprimeeArticlesData) ^
      runtimeType.hashCode;
}

extension $NatinfoNatinfNumeroNatinfArticlesGet$ResponseExtension
    on NatinfoNatinfNumeroNatinfArticlesGet$Response {
  NatinfoNatinfNumeroNatinfArticlesGet$Response copyWith({
    List<
      NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item
    >?
    definieArticlesData,
    List<
      NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item
    >?
    reprimeeArticlesData,
  }) {
    return NatinfoNatinfNumeroNatinfArticlesGet$Response(
      definieArticlesData: definieArticlesData ?? this.definieArticlesData,
      reprimeeArticlesData: reprimeeArticlesData ?? this.reprimeeArticlesData,
    );
  }

  NatinfoNatinfNumeroNatinfArticlesGet$Response copyWithWrapped({
    Wrapped<
      List<
        NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item
      >?
    >?
    definieArticlesData,
    Wrapped<
      List<
        NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item
      >?
    >?
    reprimeeArticlesData,
  }) {
    return NatinfoNatinfNumeroNatinfArticlesGet$Response(
      definieArticlesData:
          (definieArticlesData != null
              ? definieArticlesData.value
              : this.definieArticlesData),
      reprimeeArticlesData:
          (reprimeeArticlesData != null
              ? reprimeeArticlesData.value
              : this.reprimeeArticlesData),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfoTexteTypeLibelleGet$Response {
  const NatinfoTexteTypeLibelleGet$Response({
    this.abreviation,
    this.libelle,
    this.libelleLegifranceApi,
  });

  factory NatinfoTexteTypeLibelleGet$Response.fromJson(
    Map<String, dynamic> json,
  ) => _$NatinfoTexteTypeLibelleGet$ResponseFromJson(json);

  static const toJsonFactory = _$NatinfoTexteTypeLibelleGet$ResponseToJson;
  Map<String, dynamic> toJson() =>
      _$NatinfoTexteTypeLibelleGet$ResponseToJson(this);

  @JsonKey(name: 'abreviation')
  final String? abreviation;
  @JsonKey(name: 'libelle')
  final String? libelle;
  @JsonKey(name: 'libelle_legifrance_api')
  final String? libelleLegifranceApi;
  static const fromJsonFactory = _$NatinfoTexteTypeLibelleGet$ResponseFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is NatinfoTexteTypeLibelleGet$Response &&
            (identical(other.abreviation, abreviation) ||
                const DeepCollectionEquality().equals(
                  other.abreviation,
                  abreviation,
                )) &&
            (identical(other.libelle, libelle) ||
                const DeepCollectionEquality().equals(
                  other.libelle,
                  libelle,
                )) &&
            (identical(other.libelleLegifranceApi, libelleLegifranceApi) ||
                const DeepCollectionEquality().equals(
                  other.libelleLegifranceApi,
                  libelleLegifranceApi,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(abreviation) ^
      const DeepCollectionEquality().hash(libelle) ^
      const DeepCollectionEquality().hash(libelleLegifranceApi) ^
      runtimeType.hashCode;
}

extension $NatinfoTexteTypeLibelleGet$ResponseExtension
    on NatinfoTexteTypeLibelleGet$Response {
  NatinfoTexteTypeLibelleGet$Response copyWith({
    String? abreviation,
    String? libelle,
    String? libelleLegifranceApi,
  }) {
    return NatinfoTexteTypeLibelleGet$Response(
      abreviation: abreviation ?? this.abreviation,
      libelle: libelle ?? this.libelle,
      libelleLegifranceApi: libelleLegifranceApi ?? this.libelleLegifranceApi,
    );
  }

  NatinfoTexteTypeLibelleGet$Response copyWithWrapped({
    Wrapped<String?>? abreviation,
    Wrapped<String?>? libelle,
    Wrapped<String?>? libelleLegifranceApi,
  }) {
    return NatinfoTexteTypeLibelleGet$Response(
      abreviation: (abreviation != null ? abreviation.value : this.abreviation),
      libelle: (libelle != null ? libelle.value : this.libelle),
      libelleLegifranceApi:
          (libelleLegifranceApi != null
              ? libelleLegifranceApi.value
              : this.libelleLegifranceApi),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfsTexteTypeLibelleGet$Response {
  const NatinfsTexteTypeLibelleGet$Response({
    this.abreviation,
    this.libelle,
    this.libelleLegifranceApi,
  });

  factory NatinfsTexteTypeLibelleGet$Response.fromJson(
    Map<String, dynamic> json,
  ) => _$NatinfsTexteTypeLibelleGet$ResponseFromJson(json);

  static const toJsonFactory = _$NatinfsTexteTypeLibelleGet$ResponseToJson;
  Map<String, dynamic> toJson() =>
      _$NatinfsTexteTypeLibelleGet$ResponseToJson(this);

  @JsonKey(name: 'abreviation')
  final String? abreviation;
  @JsonKey(name: 'libelle')
  final String? libelle;
  @JsonKey(name: 'libelle_legifrance_api')
  final String? libelleLegifranceApi;
  static const fromJsonFactory = _$NatinfsTexteTypeLibelleGet$ResponseFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is NatinfsTexteTypeLibelleGet$Response &&
            (identical(other.abreviation, abreviation) ||
                const DeepCollectionEquality().equals(
                  other.abreviation,
                  abreviation,
                )) &&
            (identical(other.libelle, libelle) ||
                const DeepCollectionEquality().equals(
                  other.libelle,
                  libelle,
                )) &&
            (identical(other.libelleLegifranceApi, libelleLegifranceApi) ||
                const DeepCollectionEquality().equals(
                  other.libelleLegifranceApi,
                  libelleLegifranceApi,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(abreviation) ^
      const DeepCollectionEquality().hash(libelle) ^
      const DeepCollectionEquality().hash(libelleLegifranceApi) ^
      runtimeType.hashCode;
}

extension $NatinfsTexteTypeLibelleGet$ResponseExtension
    on NatinfsTexteTypeLibelleGet$Response {
  NatinfsTexteTypeLibelleGet$Response copyWith({
    String? abreviation,
    String? libelle,
    String? libelleLegifranceApi,
  }) {
    return NatinfsTexteTypeLibelleGet$Response(
      abreviation: abreviation ?? this.abreviation,
      libelle: libelle ?? this.libelle,
      libelleLegifranceApi: libelleLegifranceApi ?? this.libelleLegifranceApi,
    );
  }

  NatinfsTexteTypeLibelleGet$Response copyWithWrapped({
    Wrapped<String?>? abreviation,
    Wrapped<String?>? libelle,
    Wrapped<String?>? libelleLegifranceApi,
  }) {
    return NatinfsTexteTypeLibelleGet$Response(
      abreviation: (abreviation != null ? abreviation.value : this.abreviation),
      libelle: (libelle != null ? libelle.value : this.libelle),
      libelleLegifranceApi:
          (libelleLegifranceApi != null
              ? libelleLegifranceApi.value
              : this.libelleLegifranceApi),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfsNumeroNatinfArticlesGet$Response {
  const NatinfsNumeroNatinfArticlesGet$Response({
    this.definieArticlesData,
    this.reprimeeArticlesData,
  });

  factory NatinfsNumeroNatinfArticlesGet$Response.fromJson(
    Map<String, dynamic> json,
  ) => _$NatinfsNumeroNatinfArticlesGet$ResponseFromJson(json);

  static const toJsonFactory = _$NatinfsNumeroNatinfArticlesGet$ResponseToJson;
  Map<String, dynamic> toJson() =>
      _$NatinfsNumeroNatinfArticlesGet$ResponseToJson(this);

  @JsonKey(name: 'definie_articles_data')
  final List<NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item>?
  definieArticlesData;
  @JsonKey(name: 'reprimee_articles_data')
  final List<NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item>?
  reprimeeArticlesData;
  static const fromJsonFactory =
      _$NatinfsNumeroNatinfArticlesGet$ResponseFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is NatinfsNumeroNatinfArticlesGet$Response &&
            (identical(other.definieArticlesData, definieArticlesData) ||
                const DeepCollectionEquality().equals(
                  other.definieArticlesData,
                  definieArticlesData,
                )) &&
            (identical(other.reprimeeArticlesData, reprimeeArticlesData) ||
                const DeepCollectionEquality().equals(
                  other.reprimeeArticlesData,
                  reprimeeArticlesData,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(definieArticlesData) ^
      const DeepCollectionEquality().hash(reprimeeArticlesData) ^
      runtimeType.hashCode;
}

extension $NatinfsNumeroNatinfArticlesGet$ResponseExtension
    on NatinfsNumeroNatinfArticlesGet$Response {
  NatinfsNumeroNatinfArticlesGet$Response copyWith({
    List<NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item>?
    definieArticlesData,
    List<NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item>?
    reprimeeArticlesData,
  }) {
    return NatinfsNumeroNatinfArticlesGet$Response(
      definieArticlesData: definieArticlesData ?? this.definieArticlesData,
      reprimeeArticlesData: reprimeeArticlesData ?? this.reprimeeArticlesData,
    );
  }

  NatinfsNumeroNatinfArticlesGet$Response copyWithWrapped({
    Wrapped<
      List<NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item>?
    >?
    definieArticlesData,
    Wrapped<
      List<NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item>?
    >?
    reprimeeArticlesData,
  }) {
    return NatinfsNumeroNatinfArticlesGet$Response(
      definieArticlesData:
          (definieArticlesData != null
              ? definieArticlesData.value
              : this.definieArticlesData),
      reprimeeArticlesData:
          (reprimeeArticlesData != null
              ? reprimeeArticlesData.value
              : this.reprimeeArticlesData),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class PrintSelectionsPost$Response {
  const PrintSelectionsPost$Response({this.selectionId});

  factory PrintSelectionsPost$Response.fromJson(Map<String, dynamic> json) =>
      _$PrintSelectionsPost$ResponseFromJson(json);

  static const toJsonFactory = _$PrintSelectionsPost$ResponseToJson;
  Map<String, dynamic> toJson() => _$PrintSelectionsPost$ResponseToJson(this);

  @JsonKey(name: 'selection_id')
  final String? selectionId;
  static const fromJsonFactory = _$PrintSelectionsPost$ResponseFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other is PrintSelectionsPost$Response &&
            (identical(other.selectionId, selectionId) ||
                const DeepCollectionEquality().equals(
                  other.selectionId,
                  selectionId,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(selectionId) ^ runtimeType.hashCode;
}

extension $PrintSelectionsPost$ResponseExtension
    on PrintSelectionsPost$Response {
  PrintSelectionsPost$Response copyWith({String? selectionId}) {
    return PrintSelectionsPost$Response(
      selectionId: selectionId ?? this.selectionId,
    );
  }

  PrintSelectionsPost$Response copyWithWrapped({
    Wrapped<String?>? selectionId,
  }) {
    return PrintSelectionsPost$Response(
      selectionId: (selectionId != null ? selectionId.value : this.selectionId),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item {
  const NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item({
    this.article,
    this.articleNum,
    this.libelle,
    this.legifranceApiLibelle,
  });

  factory NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item.fromJson(
    Map<String, dynamic> json,
  ) =>
      _$NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$ItemFromJson(
        json,
      );

  static const toJsonFactory =
      _$NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$ItemToJson;
  Map<String, dynamic> toJson() =>
      _$NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$ItemToJson(
        this,
      );

  @JsonKey(name: 'article')
  final String? article;
  @JsonKey(name: 'article_num')
  final String? articleNum;
  @JsonKey(name: 'libelle')
  final String? libelle;
  @JsonKey(name: 'legifrance_api_libelle')
  final String? legifranceApiLibelle;
  static const fromJsonFactory =
      _$NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$ItemFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other
                is NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item &&
            (identical(other.article, article) ||
                const DeepCollectionEquality().equals(
                  other.article,
                  article,
                )) &&
            (identical(other.articleNum, articleNum) ||
                const DeepCollectionEquality().equals(
                  other.articleNum,
                  articleNum,
                )) &&
            (identical(other.libelle, libelle) ||
                const DeepCollectionEquality().equals(
                  other.libelle,
                  libelle,
                )) &&
            (identical(other.legifranceApiLibelle, legifranceApiLibelle) ||
                const DeepCollectionEquality().equals(
                  other.legifranceApiLibelle,
                  legifranceApiLibelle,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(article) ^
      const DeepCollectionEquality().hash(articleNum) ^
      const DeepCollectionEquality().hash(libelle) ^
      const DeepCollectionEquality().hash(legifranceApiLibelle) ^
      runtimeType.hashCode;
}

extension $NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$ItemExtension
    on NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item {
  NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item
  copyWith({
    String? article,
    String? articleNum,
    String? libelle,
    String? legifranceApiLibelle,
  }) {
    return NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item(
      article: article ?? this.article,
      articleNum: articleNum ?? this.articleNum,
      libelle: libelle ?? this.libelle,
      legifranceApiLibelle: legifranceApiLibelle ?? this.legifranceApiLibelle,
    );
  }

  NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item
  copyWithWrapped({
    Wrapped<String?>? article,
    Wrapped<String?>? articleNum,
    Wrapped<String?>? libelle,
    Wrapped<String?>? legifranceApiLibelle,
  }) {
    return NatinfoNatinfNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item(
      article: (article != null ? article.value : this.article),
      articleNum: (articleNum != null ? articleNum.value : this.articleNum),
      libelle: (libelle != null ? libelle.value : this.libelle),
      legifranceApiLibelle:
          (legifranceApiLibelle != null
              ? legifranceApiLibelle.value
              : this.legifranceApiLibelle),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item {
  const NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item({
    this.article,
    this.articleNum,
    this.libelle,
    this.legifranceApiLibelle,
  });

  factory NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item.fromJson(
    Map<String, dynamic> json,
  ) =>
      _$NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$ItemFromJson(
        json,
      );

  static const toJsonFactory =
      _$NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$ItemToJson;
  Map<String, dynamic> toJson() =>
      _$NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$ItemToJson(
        this,
      );

  @JsonKey(name: 'article')
  final String? article;
  @JsonKey(name: 'article_num')
  final String? articleNum;
  @JsonKey(name: 'libelle')
  final String? libelle;
  @JsonKey(name: 'legifrance_api_libelle')
  final String? legifranceApiLibelle;
  static const fromJsonFactory =
      _$NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$ItemFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other
                is NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item &&
            (identical(other.article, article) ||
                const DeepCollectionEquality().equals(
                  other.article,
                  article,
                )) &&
            (identical(other.articleNum, articleNum) ||
                const DeepCollectionEquality().equals(
                  other.articleNum,
                  articleNum,
                )) &&
            (identical(other.libelle, libelle) ||
                const DeepCollectionEquality().equals(
                  other.libelle,
                  libelle,
                )) &&
            (identical(other.legifranceApiLibelle, legifranceApiLibelle) ||
                const DeepCollectionEquality().equals(
                  other.legifranceApiLibelle,
                  legifranceApiLibelle,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(article) ^
      const DeepCollectionEquality().hash(articleNum) ^
      const DeepCollectionEquality().hash(libelle) ^
      const DeepCollectionEquality().hash(legifranceApiLibelle) ^
      runtimeType.hashCode;
}

extension $NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$ItemExtension
    on NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item {
  NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item
  copyWith({
    String? article,
    String? articleNum,
    String? libelle,
    String? legifranceApiLibelle,
  }) {
    return NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item(
      article: article ?? this.article,
      articleNum: articleNum ?? this.articleNum,
      libelle: libelle ?? this.libelle,
      legifranceApiLibelle: legifranceApiLibelle ?? this.legifranceApiLibelle,
    );
  }

  NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item
  copyWithWrapped({
    Wrapped<String?>? article,
    Wrapped<String?>? articleNum,
    Wrapped<String?>? libelle,
    Wrapped<String?>? legifranceApiLibelle,
  }) {
    return NatinfoNatinfNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item(
      article: (article != null ? article.value : this.article),
      articleNum: (articleNum != null ? articleNum.value : this.articleNum),
      libelle: (libelle != null ? libelle.value : this.libelle),
      legifranceApiLibelle:
          (legifranceApiLibelle != null
              ? legifranceApiLibelle.value
              : this.legifranceApiLibelle),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item {
  const NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item({
    this.article,
    this.articleNum,
    this.libelle,
    this.legifranceApiLibelle,
  });

  factory NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item.fromJson(
    Map<String, dynamic> json,
  ) =>
      _$NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$ItemFromJson(
        json,
      );

  static const toJsonFactory =
      _$NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$ItemToJson;
  Map<String, dynamic> toJson() =>
      _$NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$ItemToJson(
        this,
      );

  @JsonKey(name: 'article')
  final String? article;
  @JsonKey(name: 'article_num')
  final String? articleNum;
  @JsonKey(name: 'libelle')
  final String? libelle;
  @JsonKey(name: 'legifrance_api_libelle')
  final String? legifranceApiLibelle;
  static const fromJsonFactory =
      _$NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$ItemFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other
                is NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item &&
            (identical(other.article, article) ||
                const DeepCollectionEquality().equals(
                  other.article,
                  article,
                )) &&
            (identical(other.articleNum, articleNum) ||
                const DeepCollectionEquality().equals(
                  other.articleNum,
                  articleNum,
                )) &&
            (identical(other.libelle, libelle) ||
                const DeepCollectionEquality().equals(
                  other.libelle,
                  libelle,
                )) &&
            (identical(other.legifranceApiLibelle, legifranceApiLibelle) ||
                const DeepCollectionEquality().equals(
                  other.legifranceApiLibelle,
                  legifranceApiLibelle,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(article) ^
      const DeepCollectionEquality().hash(articleNum) ^
      const DeepCollectionEquality().hash(libelle) ^
      const DeepCollectionEquality().hash(legifranceApiLibelle) ^
      runtimeType.hashCode;
}

extension $NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$ItemExtension
    on NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item {
  NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item copyWith({
    String? article,
    String? articleNum,
    String? libelle,
    String? legifranceApiLibelle,
  }) {
    return NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item(
      article: article ?? this.article,
      articleNum: articleNum ?? this.articleNum,
      libelle: libelle ?? this.libelle,
      legifranceApiLibelle: legifranceApiLibelle ?? this.legifranceApiLibelle,
    );
  }

  NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item
  copyWithWrapped({
    Wrapped<String?>? article,
    Wrapped<String?>? articleNum,
    Wrapped<String?>? libelle,
    Wrapped<String?>? legifranceApiLibelle,
  }) {
    return NatinfsNumeroNatinfArticlesGet$Response$DefinieArticlesData$Item(
      article: (article != null ? article.value : this.article),
      articleNum: (articleNum != null ? articleNum.value : this.articleNum),
      libelle: (libelle != null ? libelle.value : this.libelle),
      legifranceApiLibelle:
          (legifranceApiLibelle != null
              ? legifranceApiLibelle.value
              : this.legifranceApiLibelle),
    );
  }
}

@JsonSerializable(explicitToJson: true)
class NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item {
  const NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item({
    this.article,
    this.articleNum,
    this.libelle,
    this.legifranceApiLibelle,
  });

  factory NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item.fromJson(
    Map<String, dynamic> json,
  ) =>
      _$NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$ItemFromJson(
        json,
      );

  static const toJsonFactory =
      _$NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$ItemToJson;
  Map<String, dynamic> toJson() =>
      _$NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$ItemToJson(
        this,
      );

  @JsonKey(name: 'article')
  final String? article;
  @JsonKey(name: 'article_num')
  final String? articleNum;
  @JsonKey(name: 'libelle')
  final String? libelle;
  @JsonKey(name: 'legifrance_api_libelle')
  final String? legifranceApiLibelle;
  static const fromJsonFactory =
      _$NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$ItemFromJson;

  @override
  bool operator ==(Object other) {
    return identical(this, other) ||
        (other
                is NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item &&
            (identical(other.article, article) ||
                const DeepCollectionEquality().equals(
                  other.article,
                  article,
                )) &&
            (identical(other.articleNum, articleNum) ||
                const DeepCollectionEquality().equals(
                  other.articleNum,
                  articleNum,
                )) &&
            (identical(other.libelle, libelle) ||
                const DeepCollectionEquality().equals(
                  other.libelle,
                  libelle,
                )) &&
            (identical(other.legifranceApiLibelle, legifranceApiLibelle) ||
                const DeepCollectionEquality().equals(
                  other.legifranceApiLibelle,
                  legifranceApiLibelle,
                )));
  }

  @override
  String toString() => jsonEncode(this);

  @override
  int get hashCode =>
      const DeepCollectionEquality().hash(article) ^
      const DeepCollectionEquality().hash(articleNum) ^
      const DeepCollectionEquality().hash(libelle) ^
      const DeepCollectionEquality().hash(legifranceApiLibelle) ^
      runtimeType.hashCode;
}

extension $NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$ItemExtension
    on NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item {
  NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item copyWith({
    String? article,
    String? articleNum,
    String? libelle,
    String? legifranceApiLibelle,
  }) {
    return NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item(
      article: article ?? this.article,
      articleNum: articleNum ?? this.articleNum,
      libelle: libelle ?? this.libelle,
      legifranceApiLibelle: legifranceApiLibelle ?? this.legifranceApiLibelle,
    );
  }

  NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item
  copyWithWrapped({
    Wrapped<String?>? article,
    Wrapped<String?>? articleNum,
    Wrapped<String?>? libelle,
    Wrapped<String?>? legifranceApiLibelle,
  }) {
    return NatinfsNumeroNatinfArticlesGet$Response$ReprimeeArticlesData$Item(
      article: (article != null ? article.value : this.article),
      articleNum: (articleNum != null ? articleNum.value : this.articleNum),
      libelle: (libelle != null ? libelle.value : this.libelle),
      legifranceApiLibelle:
          (legifranceApiLibelle != null
              ? legifranceApiLibelle.value
              : this.legifranceApiLibelle),
    );
  }
}

String? natinfPenaltyDurationUnitNullableToJson(
  enums.NatinfPenaltyDurationUnit? natinfPenaltyDurationUnit,
) {
  return natinfPenaltyDurationUnit?.value;
}

String? natinfPenaltyDurationUnitToJson(
  enums.NatinfPenaltyDurationUnit natinfPenaltyDurationUnit,
) {
  return natinfPenaltyDurationUnit.value;
}

enums.NatinfPenaltyDurationUnit natinfPenaltyDurationUnitFromJson(
  Object? natinfPenaltyDurationUnit, [
  enums.NatinfPenaltyDurationUnit? defaultValue,
]) {
  return enums.NatinfPenaltyDurationUnit.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyDurationUnit,
      ) ??
      defaultValue ??
      enums.NatinfPenaltyDurationUnit.swaggerGeneratedUnknown;
}

enums.NatinfPenaltyDurationUnit? natinfPenaltyDurationUnitNullableFromJson(
  Object? natinfPenaltyDurationUnit, [
  enums.NatinfPenaltyDurationUnit? defaultValue,
]) {
  if (natinfPenaltyDurationUnit == null) {
    return null;
  }
  return enums.NatinfPenaltyDurationUnit.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyDurationUnit,
      ) ??
      defaultValue;
}

String natinfPenaltyDurationUnitExplodedListToJson(
  List<enums.NatinfPenaltyDurationUnit>? natinfPenaltyDurationUnit,
) {
  return natinfPenaltyDurationUnit?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfPenaltyDurationUnitListToJson(
  List<enums.NatinfPenaltyDurationUnit>? natinfPenaltyDurationUnit,
) {
  if (natinfPenaltyDurationUnit == null) {
    return [];
  }

  return natinfPenaltyDurationUnit.map((e) => e.value!).toList();
}

List<enums.NatinfPenaltyDurationUnit> natinfPenaltyDurationUnitListFromJson(
  List? natinfPenaltyDurationUnit, [
  List<enums.NatinfPenaltyDurationUnit>? defaultValue,
]) {
  if (natinfPenaltyDurationUnit == null) {
    return defaultValue ?? [];
  }

  return natinfPenaltyDurationUnit
      .map((e) => natinfPenaltyDurationUnitFromJson(e.toString()))
      .toList();
}

List<enums.NatinfPenaltyDurationUnit>?
natinfPenaltyDurationUnitNullableListFromJson(
  List? natinfPenaltyDurationUnit, [
  List<enums.NatinfPenaltyDurationUnit>? defaultValue,
]) {
  if (natinfPenaltyDurationUnit == null) {
    return defaultValue;
  }

  return natinfPenaltyDurationUnit
      .map((e) => natinfPenaltyDurationUnitFromJson(e.toString()))
      .toList();
}

String? natinfPenaltyDurationOperatorNullableToJson(
  enums.NatinfPenaltyDurationOperator? natinfPenaltyDurationOperator,
) {
  return natinfPenaltyDurationOperator?.value;
}

String? natinfPenaltyDurationOperatorToJson(
  enums.NatinfPenaltyDurationOperator natinfPenaltyDurationOperator,
) {
  return natinfPenaltyDurationOperator.value;
}

enums.NatinfPenaltyDurationOperator natinfPenaltyDurationOperatorFromJson(
  Object? natinfPenaltyDurationOperator, [
  enums.NatinfPenaltyDurationOperator? defaultValue,
]) {
  return enums.NatinfPenaltyDurationOperator.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyDurationOperator,
      ) ??
      defaultValue ??
      enums.NatinfPenaltyDurationOperator.swaggerGeneratedUnknown;
}

enums.NatinfPenaltyDurationOperator?
natinfPenaltyDurationOperatorNullableFromJson(
  Object? natinfPenaltyDurationOperator, [
  enums.NatinfPenaltyDurationOperator? defaultValue,
]) {
  if (natinfPenaltyDurationOperator == null) {
    return null;
  }
  return enums.NatinfPenaltyDurationOperator.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyDurationOperator,
      ) ??
      defaultValue;
}

String natinfPenaltyDurationOperatorExplodedListToJson(
  List<enums.NatinfPenaltyDurationOperator>? natinfPenaltyDurationOperator,
) {
  return natinfPenaltyDurationOperator?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfPenaltyDurationOperatorListToJson(
  List<enums.NatinfPenaltyDurationOperator>? natinfPenaltyDurationOperator,
) {
  if (natinfPenaltyDurationOperator == null) {
    return [];
  }

  return natinfPenaltyDurationOperator.map((e) => e.value!).toList();
}

List<enums.NatinfPenaltyDurationOperator>
natinfPenaltyDurationOperatorListFromJson(
  List? natinfPenaltyDurationOperator, [
  List<enums.NatinfPenaltyDurationOperator>? defaultValue,
]) {
  if (natinfPenaltyDurationOperator == null) {
    return defaultValue ?? [];
  }

  return natinfPenaltyDurationOperator
      .map((e) => natinfPenaltyDurationOperatorFromJson(e.toString()))
      .toList();
}

List<enums.NatinfPenaltyDurationOperator>?
natinfPenaltyDurationOperatorNullableListFromJson(
  List? natinfPenaltyDurationOperator, [
  List<enums.NatinfPenaltyDurationOperator>? defaultValue,
]) {
  if (natinfPenaltyDurationOperator == null) {
    return defaultValue;
  }

  return natinfPenaltyDurationOperator
      .map((e) => natinfPenaltyDurationOperatorFromJson(e.toString()))
      .toList();
}

String? natinfPenaltyAmountCurrencyNullableToJson(
  enums.NatinfPenaltyAmountCurrency? natinfPenaltyAmountCurrency,
) {
  return natinfPenaltyAmountCurrency?.value;
}

String? natinfPenaltyAmountCurrencyToJson(
  enums.NatinfPenaltyAmountCurrency natinfPenaltyAmountCurrency,
) {
  return natinfPenaltyAmountCurrency.value;
}

enums.NatinfPenaltyAmountCurrency natinfPenaltyAmountCurrencyFromJson(
  Object? natinfPenaltyAmountCurrency, [
  enums.NatinfPenaltyAmountCurrency? defaultValue,
]) {
  return enums.NatinfPenaltyAmountCurrency.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyAmountCurrency,
      ) ??
      defaultValue ??
      enums.NatinfPenaltyAmountCurrency.swaggerGeneratedUnknown;
}

enums.NatinfPenaltyAmountCurrency? natinfPenaltyAmountCurrencyNullableFromJson(
  Object? natinfPenaltyAmountCurrency, [
  enums.NatinfPenaltyAmountCurrency? defaultValue,
]) {
  if (natinfPenaltyAmountCurrency == null) {
    return null;
  }
  return enums.NatinfPenaltyAmountCurrency.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyAmountCurrency,
      ) ??
      defaultValue;
}

String natinfPenaltyAmountCurrencyExplodedListToJson(
  List<enums.NatinfPenaltyAmountCurrency>? natinfPenaltyAmountCurrency,
) {
  return natinfPenaltyAmountCurrency?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfPenaltyAmountCurrencyListToJson(
  List<enums.NatinfPenaltyAmountCurrency>? natinfPenaltyAmountCurrency,
) {
  if (natinfPenaltyAmountCurrency == null) {
    return [];
  }

  return natinfPenaltyAmountCurrency.map((e) => e.value!).toList();
}

List<enums.NatinfPenaltyAmountCurrency> natinfPenaltyAmountCurrencyListFromJson(
  List? natinfPenaltyAmountCurrency, [
  List<enums.NatinfPenaltyAmountCurrency>? defaultValue,
]) {
  if (natinfPenaltyAmountCurrency == null) {
    return defaultValue ?? [];
  }

  return natinfPenaltyAmountCurrency
      .map((e) => natinfPenaltyAmountCurrencyFromJson(e.toString()))
      .toList();
}

List<enums.NatinfPenaltyAmountCurrency>?
natinfPenaltyAmountCurrencyNullableListFromJson(
  List? natinfPenaltyAmountCurrency, [
  List<enums.NatinfPenaltyAmountCurrency>? defaultValue,
]) {
  if (natinfPenaltyAmountCurrency == null) {
    return defaultValue;
  }

  return natinfPenaltyAmountCurrency
      .map((e) => natinfPenaltyAmountCurrencyFromJson(e.toString()))
      .toList();
}

String? natinfTentativeNullableToJson(enums.NatinfTentative? natinfTentative) {
  return natinfTentative?.value;
}

String? natinfTentativeToJson(enums.NatinfTentative natinfTentative) {
  return natinfTentative.value;
}

enums.NatinfTentative natinfTentativeFromJson(
  Object? natinfTentative, [
  enums.NatinfTentative? defaultValue,
]) {
  return enums.NatinfTentative.values.firstWhereOrNull(
        (e) => e.value == natinfTentative,
      ) ??
      defaultValue ??
      enums.NatinfTentative.swaggerGeneratedUnknown;
}

enums.NatinfTentative? natinfTentativeNullableFromJson(
  Object? natinfTentative, [
  enums.NatinfTentative? defaultValue,
]) {
  if (natinfTentative == null) {
    return null;
  }
  return enums.NatinfTentative.values.firstWhereOrNull(
        (e) => e.value == natinfTentative,
      ) ??
      defaultValue;
}

String natinfTentativeExplodedListToJson(
  List<enums.NatinfTentative>? natinfTentative,
) {
  return natinfTentative?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfTentativeListToJson(
  List<enums.NatinfTentative>? natinfTentative,
) {
  if (natinfTentative == null) {
    return [];
  }

  return natinfTentative.map((e) => e.value!).toList();
}

List<enums.NatinfTentative> natinfTentativeListFromJson(
  List? natinfTentative, [
  List<enums.NatinfTentative>? defaultValue,
]) {
  if (natinfTentative == null) {
    return defaultValue ?? [];
  }

  return natinfTentative
      .map((e) => natinfTentativeFromJson(e.toString()))
      .toList();
}

List<enums.NatinfTentative>? natinfTentativeNullableListFromJson(
  List? natinfTentative, [
  List<enums.NatinfTentative>? defaultValue,
]) {
  if (natinfTentative == null) {
    return defaultValue;
  }

  return natinfTentative
      .map((e) => natinfTentativeFromJson(e.toString()))
      .toList();
}

String? natinfAmendeCategoryNullableToJson(
  enums.NatinfAmendeCategory? natinfAmendeCategory,
) {
  return natinfAmendeCategory?.value;
}

String? natinfAmendeCategoryToJson(
  enums.NatinfAmendeCategory natinfAmendeCategory,
) {
  return natinfAmendeCategory.value;
}

enums.NatinfAmendeCategory natinfAmendeCategoryFromJson(
  Object? natinfAmendeCategory, [
  enums.NatinfAmendeCategory? defaultValue,
]) {
  return enums.NatinfAmendeCategory.values.firstWhereOrNull(
        (e) => e.value == natinfAmendeCategory,
      ) ??
      defaultValue ??
      enums.NatinfAmendeCategory.swaggerGeneratedUnknown;
}

enums.NatinfAmendeCategory? natinfAmendeCategoryNullableFromJson(
  Object? natinfAmendeCategory, [
  enums.NatinfAmendeCategory? defaultValue,
]) {
  if (natinfAmendeCategory == null) {
    return null;
  }
  return enums.NatinfAmendeCategory.values.firstWhereOrNull(
        (e) => e.value == natinfAmendeCategory,
      ) ??
      defaultValue;
}

String natinfAmendeCategoryExplodedListToJson(
  List<enums.NatinfAmendeCategory>? natinfAmendeCategory,
) {
  return natinfAmendeCategory?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfAmendeCategoryListToJson(
  List<enums.NatinfAmendeCategory>? natinfAmendeCategory,
) {
  if (natinfAmendeCategory == null) {
    return [];
  }

  return natinfAmendeCategory.map((e) => e.value!).toList();
}

List<enums.NatinfAmendeCategory> natinfAmendeCategoryListFromJson(
  List? natinfAmendeCategory, [
  List<enums.NatinfAmendeCategory>? defaultValue,
]) {
  if (natinfAmendeCategory == null) {
    return defaultValue ?? [];
  }

  return natinfAmendeCategory
      .map((e) => natinfAmendeCategoryFromJson(e.toString()))
      .toList();
}

List<enums.NatinfAmendeCategory>? natinfAmendeCategoryNullableListFromJson(
  List? natinfAmendeCategory, [
  List<enums.NatinfAmendeCategory>? defaultValue,
]) {
  if (natinfAmendeCategory == null) {
    return defaultValue;
  }

  return natinfAmendeCategory
      .map((e) => natinfAmendeCategoryFromJson(e.toString()))
      .toList();
}

String? natinfControleAlcoolemieNullableToJson(
  enums.NatinfControleAlcoolemie? natinfControleAlcoolemie,
) {
  return natinfControleAlcoolemie?.value;
}

String? natinfControleAlcoolemieToJson(
  enums.NatinfControleAlcoolemie natinfControleAlcoolemie,
) {
  return natinfControleAlcoolemie.value;
}

enums.NatinfControleAlcoolemie natinfControleAlcoolemieFromJson(
  Object? natinfControleAlcoolemie, [
  enums.NatinfControleAlcoolemie? defaultValue,
]) {
  return enums.NatinfControleAlcoolemie.values.firstWhereOrNull(
        (e) => e.value == natinfControleAlcoolemie,
      ) ??
      defaultValue ??
      enums.NatinfControleAlcoolemie.swaggerGeneratedUnknown;
}

enums.NatinfControleAlcoolemie? natinfControleAlcoolemieNullableFromJson(
  Object? natinfControleAlcoolemie, [
  enums.NatinfControleAlcoolemie? defaultValue,
]) {
  if (natinfControleAlcoolemie == null) {
    return null;
  }
  return enums.NatinfControleAlcoolemie.values.firstWhereOrNull(
        (e) => e.value == natinfControleAlcoolemie,
      ) ??
      defaultValue;
}

String natinfControleAlcoolemieExplodedListToJson(
  List<enums.NatinfControleAlcoolemie>? natinfControleAlcoolemie,
) {
  return natinfControleAlcoolemie?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfControleAlcoolemieListToJson(
  List<enums.NatinfControleAlcoolemie>? natinfControleAlcoolemie,
) {
  if (natinfControleAlcoolemie == null) {
    return [];
  }

  return natinfControleAlcoolemie.map((e) => e.value!).toList();
}

List<enums.NatinfControleAlcoolemie> natinfControleAlcoolemieListFromJson(
  List? natinfControleAlcoolemie, [
  List<enums.NatinfControleAlcoolemie>? defaultValue,
]) {
  if (natinfControleAlcoolemie == null) {
    return defaultValue ?? [];
  }

  return natinfControleAlcoolemie
      .map((e) => natinfControleAlcoolemieFromJson(e.toString()))
      .toList();
}

List<enums.NatinfControleAlcoolemie>?
natinfControleAlcoolemieNullableListFromJson(
  List? natinfControleAlcoolemie, [
  List<enums.NatinfControleAlcoolemie>? defaultValue,
]) {
  if (natinfControleAlcoolemie == null) {
    return defaultValue;
  }

  return natinfControleAlcoolemie
      .map((e) => natinfControleAlcoolemieFromJson(e.toString()))
      .toList();
}

String? natinfDepistageImpregnationAlcooliqueNullableToJson(
  enums.NatinfDepistageImpregnationAlcoolique?
  natinfDepistageImpregnationAlcoolique,
) {
  return natinfDepistageImpregnationAlcoolique?.value;
}

String? natinfDepistageImpregnationAlcooliqueToJson(
  enums.NatinfDepistageImpregnationAlcoolique
  natinfDepistageImpregnationAlcoolique,
) {
  return natinfDepistageImpregnationAlcoolique.value;
}

enums.NatinfDepistageImpregnationAlcoolique
natinfDepistageImpregnationAlcooliqueFromJson(
  Object? natinfDepistageImpregnationAlcoolique, [
  enums.NatinfDepistageImpregnationAlcoolique? defaultValue,
]) {
  return enums.NatinfDepistageImpregnationAlcoolique.values.firstWhereOrNull(
        (e) => e.value == natinfDepistageImpregnationAlcoolique,
      ) ??
      defaultValue ??
      enums.NatinfDepistageImpregnationAlcoolique.swaggerGeneratedUnknown;
}

enums.NatinfDepistageImpregnationAlcoolique?
natinfDepistageImpregnationAlcooliqueNullableFromJson(
  Object? natinfDepistageImpregnationAlcoolique, [
  enums.NatinfDepistageImpregnationAlcoolique? defaultValue,
]) {
  if (natinfDepistageImpregnationAlcoolique == null) {
    return null;
  }
  return enums.NatinfDepistageImpregnationAlcoolique.values.firstWhereOrNull(
        (e) => e.value == natinfDepistageImpregnationAlcoolique,
      ) ??
      defaultValue;
}

String natinfDepistageImpregnationAlcooliqueExplodedListToJson(
  List<enums.NatinfDepistageImpregnationAlcoolique>?
  natinfDepistageImpregnationAlcoolique,
) {
  return natinfDepistageImpregnationAlcoolique
          ?.map((e) => e.value!)
          .join(',') ??
      '';
}

List<String> natinfDepistageImpregnationAlcooliqueListToJson(
  List<enums.NatinfDepistageImpregnationAlcoolique>?
  natinfDepistageImpregnationAlcoolique,
) {
  if (natinfDepistageImpregnationAlcoolique == null) {
    return [];
  }

  return natinfDepistageImpregnationAlcoolique.map((e) => e.value!).toList();
}

List<enums.NatinfDepistageImpregnationAlcoolique>
natinfDepistageImpregnationAlcooliqueListFromJson(
  List? natinfDepistageImpregnationAlcoolique, [
  List<enums.NatinfDepistageImpregnationAlcoolique>? defaultValue,
]) {
  if (natinfDepistageImpregnationAlcoolique == null) {
    return defaultValue ?? [];
  }

  return natinfDepistageImpregnationAlcoolique
      .map((e) => natinfDepistageImpregnationAlcooliqueFromJson(e.toString()))
      .toList();
}

List<enums.NatinfDepistageImpregnationAlcoolique>?
natinfDepistageImpregnationAlcooliqueNullableListFromJson(
  List? natinfDepistageImpregnationAlcoolique, [
  List<enums.NatinfDepistageImpregnationAlcoolique>? defaultValue,
]) {
  if (natinfDepistageImpregnationAlcoolique == null) {
    return defaultValue;
  }

  return natinfDepistageImpregnationAlcoolique
      .map((e) => natinfDepistageImpregnationAlcooliqueFromJson(e.toString()))
      .toList();
}

String? natinfDepistageStupefiantsNullableToJson(
  enums.NatinfDepistageStupefiants? natinfDepistageStupefiants,
) {
  return natinfDepistageStupefiants?.value;
}

String? natinfDepistageStupefiantsToJson(
  enums.NatinfDepistageStupefiants natinfDepistageStupefiants,
) {
  return natinfDepistageStupefiants.value;
}

enums.NatinfDepistageStupefiants natinfDepistageStupefiantsFromJson(
  Object? natinfDepistageStupefiants, [
  enums.NatinfDepistageStupefiants? defaultValue,
]) {
  return enums.NatinfDepistageStupefiants.values.firstWhereOrNull(
        (e) => e.value == natinfDepistageStupefiants,
      ) ??
      defaultValue ??
      enums.NatinfDepistageStupefiants.swaggerGeneratedUnknown;
}

enums.NatinfDepistageStupefiants? natinfDepistageStupefiantsNullableFromJson(
  Object? natinfDepistageStupefiants, [
  enums.NatinfDepistageStupefiants? defaultValue,
]) {
  if (natinfDepistageStupefiants == null) {
    return null;
  }
  return enums.NatinfDepistageStupefiants.values.firstWhereOrNull(
        (e) => e.value == natinfDepistageStupefiants,
      ) ??
      defaultValue;
}

String natinfDepistageStupefiantsExplodedListToJson(
  List<enums.NatinfDepistageStupefiants>? natinfDepistageStupefiants,
) {
  return natinfDepistageStupefiants?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfDepistageStupefiantsListToJson(
  List<enums.NatinfDepistageStupefiants>? natinfDepistageStupefiants,
) {
  if (natinfDepistageStupefiants == null) {
    return [];
  }

  return natinfDepistageStupefiants.map((e) => e.value!).toList();
}

List<enums.NatinfDepistageStupefiants> natinfDepistageStupefiantsListFromJson(
  List? natinfDepistageStupefiants, [
  List<enums.NatinfDepistageStupefiants>? defaultValue,
]) {
  if (natinfDepistageStupefiants == null) {
    return defaultValue ?? [];
  }

  return natinfDepistageStupefiants
      .map((e) => natinfDepistageStupefiantsFromJson(e.toString()))
      .toList();
}

List<enums.NatinfDepistageStupefiants>?
natinfDepistageStupefiantsNullableListFromJson(
  List? natinfDepistageStupefiants, [
  List<enums.NatinfDepistageStupefiants>? defaultValue,
]) {
  if (natinfDepistageStupefiants == null) {
    return defaultValue;
  }

  return natinfDepistageStupefiants
      .map((e) => natinfDepistageStupefiantsFromJson(e.toString()))
      .toList();
}

int? natinfRetraitPointsNullableToJson(
  enums.NatinfRetraitPoints? natinfRetraitPoints,
) {
  return natinfRetraitPoints?.value;
}

int? natinfRetraitPointsToJson(enums.NatinfRetraitPoints natinfRetraitPoints) {
  return natinfRetraitPoints.value;
}

enums.NatinfRetraitPoints natinfRetraitPointsFromJson(
  Object? natinfRetraitPoints, [
  enums.NatinfRetraitPoints? defaultValue,
]) {
  return enums.NatinfRetraitPoints.values.firstWhereOrNull(
        (e) => e.value == natinfRetraitPoints,
      ) ??
      defaultValue ??
      enums.NatinfRetraitPoints.swaggerGeneratedUnknown;
}

enums.NatinfRetraitPoints? natinfRetraitPointsNullableFromJson(
  Object? natinfRetraitPoints, [
  enums.NatinfRetraitPoints? defaultValue,
]) {
  if (natinfRetraitPoints == null) {
    return null;
  }
  return enums.NatinfRetraitPoints.values.firstWhereOrNull(
        (e) => e.value == natinfRetraitPoints,
      ) ??
      defaultValue;
}

String natinfRetraitPointsExplodedListToJson(
  List<enums.NatinfRetraitPoints>? natinfRetraitPoints,
) {
  return natinfRetraitPoints?.map((e) => e.value!).join(',') ?? '';
}

List<int> natinfRetraitPointsListToJson(
  List<enums.NatinfRetraitPoints>? natinfRetraitPoints,
) {
  if (natinfRetraitPoints == null) {
    return [];
  }

  return natinfRetraitPoints.map((e) => e.value!).toList();
}

List<enums.NatinfRetraitPoints> natinfRetraitPointsListFromJson(
  List? natinfRetraitPoints, [
  List<enums.NatinfRetraitPoints>? defaultValue,
]) {
  if (natinfRetraitPoints == null) {
    return defaultValue ?? [];
  }

  return natinfRetraitPoints
      .map((e) => natinfRetraitPointsFromJson(e.toString()))
      .toList();
}

List<enums.NatinfRetraitPoints>? natinfRetraitPointsNullableListFromJson(
  List? natinfRetraitPoints, [
  List<enums.NatinfRetraitPoints>? defaultValue,
]) {
  if (natinfRetraitPoints == null) {
    return defaultValue;
  }

  return natinfRetraitPoints
      .map((e) => natinfRetraitPointsFromJson(e.toString()))
      .toList();
}

String? natinfRetentionPermisConduireNullableToJson(
  enums.NatinfRetentionPermisConduire? natinfRetentionPermisConduire,
) {
  return natinfRetentionPermisConduire?.value;
}

String? natinfRetentionPermisConduireToJson(
  enums.NatinfRetentionPermisConduire natinfRetentionPermisConduire,
) {
  return natinfRetentionPermisConduire.value;
}

enums.NatinfRetentionPermisConduire natinfRetentionPermisConduireFromJson(
  Object? natinfRetentionPermisConduire, [
  enums.NatinfRetentionPermisConduire? defaultValue,
]) {
  return enums.NatinfRetentionPermisConduire.values.firstWhereOrNull(
        (e) => e.value == natinfRetentionPermisConduire,
      ) ??
      defaultValue ??
      enums.NatinfRetentionPermisConduire.swaggerGeneratedUnknown;
}

enums.NatinfRetentionPermisConduire?
natinfRetentionPermisConduireNullableFromJson(
  Object? natinfRetentionPermisConduire, [
  enums.NatinfRetentionPermisConduire? defaultValue,
]) {
  if (natinfRetentionPermisConduire == null) {
    return null;
  }
  return enums.NatinfRetentionPermisConduire.values.firstWhereOrNull(
        (e) => e.value == natinfRetentionPermisConduire,
      ) ??
      defaultValue;
}

String natinfRetentionPermisConduireExplodedListToJson(
  List<enums.NatinfRetentionPermisConduire>? natinfRetentionPermisConduire,
) {
  return natinfRetentionPermisConduire?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfRetentionPermisConduireListToJson(
  List<enums.NatinfRetentionPermisConduire>? natinfRetentionPermisConduire,
) {
  if (natinfRetentionPermisConduire == null) {
    return [];
  }

  return natinfRetentionPermisConduire.map((e) => e.value!).toList();
}

List<enums.NatinfRetentionPermisConduire>
natinfRetentionPermisConduireListFromJson(
  List? natinfRetentionPermisConduire, [
  List<enums.NatinfRetentionPermisConduire>? defaultValue,
]) {
  if (natinfRetentionPermisConduire == null) {
    return defaultValue ?? [];
  }

  return natinfRetentionPermisConduire
      .map((e) => natinfRetentionPermisConduireFromJson(e.toString()))
      .toList();
}

List<enums.NatinfRetentionPermisConduire>?
natinfRetentionPermisConduireNullableListFromJson(
  List? natinfRetentionPermisConduire, [
  List<enums.NatinfRetentionPermisConduire>? defaultValue,
]) {
  if (natinfRetentionPermisConduire == null) {
    return defaultValue;
  }

  return natinfRetentionPermisConduire
      .map((e) => natinfRetentionPermisConduireFromJson(e.toString()))
      .toList();
}

String? natinfImmobilisationVehiculeNullableToJson(
  enums.NatinfImmobilisationVehicule? natinfImmobilisationVehicule,
) {
  return natinfImmobilisationVehicule?.value;
}

String? natinfImmobilisationVehiculeToJson(
  enums.NatinfImmobilisationVehicule natinfImmobilisationVehicule,
) {
  return natinfImmobilisationVehicule.value;
}

enums.NatinfImmobilisationVehicule natinfImmobilisationVehiculeFromJson(
  Object? natinfImmobilisationVehicule, [
  enums.NatinfImmobilisationVehicule? defaultValue,
]) {
  return enums.NatinfImmobilisationVehicule.values.firstWhereOrNull(
        (e) => e.value == natinfImmobilisationVehicule,
      ) ??
      defaultValue ??
      enums.NatinfImmobilisationVehicule.swaggerGeneratedUnknown;
}

enums.NatinfImmobilisationVehicule?
natinfImmobilisationVehiculeNullableFromJson(
  Object? natinfImmobilisationVehicule, [
  enums.NatinfImmobilisationVehicule? defaultValue,
]) {
  if (natinfImmobilisationVehicule == null) {
    return null;
  }
  return enums.NatinfImmobilisationVehicule.values.firstWhereOrNull(
        (e) => e.value == natinfImmobilisationVehicule,
      ) ??
      defaultValue;
}

String natinfImmobilisationVehiculeExplodedListToJson(
  List<enums.NatinfImmobilisationVehicule>? natinfImmobilisationVehicule,
) {
  return natinfImmobilisationVehicule?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfImmobilisationVehiculeListToJson(
  List<enums.NatinfImmobilisationVehicule>? natinfImmobilisationVehicule,
) {
  if (natinfImmobilisationVehicule == null) {
    return [];
  }

  return natinfImmobilisationVehicule.map((e) => e.value!).toList();
}

List<enums.NatinfImmobilisationVehicule>
natinfImmobilisationVehiculeListFromJson(
  List? natinfImmobilisationVehicule, [
  List<enums.NatinfImmobilisationVehicule>? defaultValue,
]) {
  if (natinfImmobilisationVehicule == null) {
    return defaultValue ?? [];
  }

  return natinfImmobilisationVehicule
      .map((e) => natinfImmobilisationVehiculeFromJson(e.toString()))
      .toList();
}

List<enums.NatinfImmobilisationVehicule>?
natinfImmobilisationVehiculeNullableListFromJson(
  List? natinfImmobilisationVehicule, [
  List<enums.NatinfImmobilisationVehicule>? defaultValue,
]) {
  if (natinfImmobilisationVehicule == null) {
    return defaultValue;
  }

  return natinfImmobilisationVehicule
      .map((e) => natinfImmobilisationVehiculeFromJson(e.toString()))
      .toList();
}

String? natinfMiseEnFourriereNullableToJson(
  enums.NatinfMiseEnFourriere? natinfMiseEnFourriere,
) {
  return natinfMiseEnFourriere?.value;
}

String? natinfMiseEnFourriereToJson(
  enums.NatinfMiseEnFourriere natinfMiseEnFourriere,
) {
  return natinfMiseEnFourriere.value;
}

enums.NatinfMiseEnFourriere natinfMiseEnFourriereFromJson(
  Object? natinfMiseEnFourriere, [
  enums.NatinfMiseEnFourriere? defaultValue,
]) {
  return enums.NatinfMiseEnFourriere.values.firstWhereOrNull(
        (e) => e.value == natinfMiseEnFourriere,
      ) ??
      defaultValue ??
      enums.NatinfMiseEnFourriere.swaggerGeneratedUnknown;
}

enums.NatinfMiseEnFourriere? natinfMiseEnFourriereNullableFromJson(
  Object? natinfMiseEnFourriere, [
  enums.NatinfMiseEnFourriere? defaultValue,
]) {
  if (natinfMiseEnFourriere == null) {
    return null;
  }
  return enums.NatinfMiseEnFourriere.values.firstWhereOrNull(
        (e) => e.value == natinfMiseEnFourriere,
      ) ??
      defaultValue;
}

String natinfMiseEnFourriereExplodedListToJson(
  List<enums.NatinfMiseEnFourriere>? natinfMiseEnFourriere,
) {
  return natinfMiseEnFourriere?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfMiseEnFourriereListToJson(
  List<enums.NatinfMiseEnFourriere>? natinfMiseEnFourriere,
) {
  if (natinfMiseEnFourriere == null) {
    return [];
  }

  return natinfMiseEnFourriere.map((e) => e.value!).toList();
}

List<enums.NatinfMiseEnFourriere> natinfMiseEnFourriereListFromJson(
  List? natinfMiseEnFourriere, [
  List<enums.NatinfMiseEnFourriere>? defaultValue,
]) {
  if (natinfMiseEnFourriere == null) {
    return defaultValue ?? [];
  }

  return natinfMiseEnFourriere
      .map((e) => natinfMiseEnFourriereFromJson(e.toString()))
      .toList();
}

List<enums.NatinfMiseEnFourriere>? natinfMiseEnFourriereNullableListFromJson(
  List? natinfMiseEnFourriere, [
  List<enums.NatinfMiseEnFourriere>? defaultValue,
]) {
  if (natinfMiseEnFourriere == null) {
    return defaultValue;
  }

  return natinfMiseEnFourriere
      .map((e) => natinfMiseEnFourriereFromJson(e.toString()))
      .toList();
}

String? natinfPenaltyInputDurationUnitNullableToJson(
  enums.NatinfPenaltyInputDurationUnit? natinfPenaltyInputDurationUnit,
) {
  return natinfPenaltyInputDurationUnit?.value;
}

String? natinfPenaltyInputDurationUnitToJson(
  enums.NatinfPenaltyInputDurationUnit natinfPenaltyInputDurationUnit,
) {
  return natinfPenaltyInputDurationUnit.value;
}

enums.NatinfPenaltyInputDurationUnit natinfPenaltyInputDurationUnitFromJson(
  Object? natinfPenaltyInputDurationUnit, [
  enums.NatinfPenaltyInputDurationUnit? defaultValue,
]) {
  return enums.NatinfPenaltyInputDurationUnit.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyInputDurationUnit,
      ) ??
      defaultValue ??
      enums.NatinfPenaltyInputDurationUnit.swaggerGeneratedUnknown;
}

enums.NatinfPenaltyInputDurationUnit?
natinfPenaltyInputDurationUnitNullableFromJson(
  Object? natinfPenaltyInputDurationUnit, [
  enums.NatinfPenaltyInputDurationUnit? defaultValue,
]) {
  if (natinfPenaltyInputDurationUnit == null) {
    return null;
  }
  return enums.NatinfPenaltyInputDurationUnit.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyInputDurationUnit,
      ) ??
      defaultValue;
}

String natinfPenaltyInputDurationUnitExplodedListToJson(
  List<enums.NatinfPenaltyInputDurationUnit>? natinfPenaltyInputDurationUnit,
) {
  return natinfPenaltyInputDurationUnit?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfPenaltyInputDurationUnitListToJson(
  List<enums.NatinfPenaltyInputDurationUnit>? natinfPenaltyInputDurationUnit,
) {
  if (natinfPenaltyInputDurationUnit == null) {
    return [];
  }

  return natinfPenaltyInputDurationUnit.map((e) => e.value!).toList();
}

List<enums.NatinfPenaltyInputDurationUnit>
natinfPenaltyInputDurationUnitListFromJson(
  List? natinfPenaltyInputDurationUnit, [
  List<enums.NatinfPenaltyInputDurationUnit>? defaultValue,
]) {
  if (natinfPenaltyInputDurationUnit == null) {
    return defaultValue ?? [];
  }

  return natinfPenaltyInputDurationUnit
      .map((e) => natinfPenaltyInputDurationUnitFromJson(e.toString()))
      .toList();
}

List<enums.NatinfPenaltyInputDurationUnit>?
natinfPenaltyInputDurationUnitNullableListFromJson(
  List? natinfPenaltyInputDurationUnit, [
  List<enums.NatinfPenaltyInputDurationUnit>? defaultValue,
]) {
  if (natinfPenaltyInputDurationUnit == null) {
    return defaultValue;
  }

  return natinfPenaltyInputDurationUnit
      .map((e) => natinfPenaltyInputDurationUnitFromJson(e.toString()))
      .toList();
}

String? natinfPenaltyInputDurationOperatorNullableToJson(
  enums.NatinfPenaltyInputDurationOperator? natinfPenaltyInputDurationOperator,
) {
  return natinfPenaltyInputDurationOperator?.value;
}

String? natinfPenaltyInputDurationOperatorToJson(
  enums.NatinfPenaltyInputDurationOperator natinfPenaltyInputDurationOperator,
) {
  return natinfPenaltyInputDurationOperator.value;
}

enums.NatinfPenaltyInputDurationOperator
natinfPenaltyInputDurationOperatorFromJson(
  Object? natinfPenaltyInputDurationOperator, [
  enums.NatinfPenaltyInputDurationOperator? defaultValue,
]) {
  return enums.NatinfPenaltyInputDurationOperator.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyInputDurationOperator,
      ) ??
      defaultValue ??
      enums.NatinfPenaltyInputDurationOperator.swaggerGeneratedUnknown;
}

enums.NatinfPenaltyInputDurationOperator?
natinfPenaltyInputDurationOperatorNullableFromJson(
  Object? natinfPenaltyInputDurationOperator, [
  enums.NatinfPenaltyInputDurationOperator? defaultValue,
]) {
  if (natinfPenaltyInputDurationOperator == null) {
    return null;
  }
  return enums.NatinfPenaltyInputDurationOperator.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyInputDurationOperator,
      ) ??
      defaultValue;
}

String natinfPenaltyInputDurationOperatorExplodedListToJson(
  List<enums.NatinfPenaltyInputDurationOperator>?
  natinfPenaltyInputDurationOperator,
) {
  return natinfPenaltyInputDurationOperator?.map((e) => e.value!).join(',') ??
      '';
}

List<String> natinfPenaltyInputDurationOperatorListToJson(
  List<enums.NatinfPenaltyInputDurationOperator>?
  natinfPenaltyInputDurationOperator,
) {
  if (natinfPenaltyInputDurationOperator == null) {
    return [];
  }

  return natinfPenaltyInputDurationOperator.map((e) => e.value!).toList();
}

List<enums.NatinfPenaltyInputDurationOperator>
natinfPenaltyInputDurationOperatorListFromJson(
  List? natinfPenaltyInputDurationOperator, [
  List<enums.NatinfPenaltyInputDurationOperator>? defaultValue,
]) {
  if (natinfPenaltyInputDurationOperator == null) {
    return defaultValue ?? [];
  }

  return natinfPenaltyInputDurationOperator
      .map((e) => natinfPenaltyInputDurationOperatorFromJson(e.toString()))
      .toList();
}

List<enums.NatinfPenaltyInputDurationOperator>?
natinfPenaltyInputDurationOperatorNullableListFromJson(
  List? natinfPenaltyInputDurationOperator, [
  List<enums.NatinfPenaltyInputDurationOperator>? defaultValue,
]) {
  if (natinfPenaltyInputDurationOperator == null) {
    return defaultValue;
  }

  return natinfPenaltyInputDurationOperator
      .map((e) => natinfPenaltyInputDurationOperatorFromJson(e.toString()))
      .toList();
}

String? natinfPenaltyInputAmountCurrencyNullableToJson(
  enums.NatinfPenaltyInputAmountCurrency? natinfPenaltyInputAmountCurrency,
) {
  return natinfPenaltyInputAmountCurrency?.value;
}

String? natinfPenaltyInputAmountCurrencyToJson(
  enums.NatinfPenaltyInputAmountCurrency natinfPenaltyInputAmountCurrency,
) {
  return natinfPenaltyInputAmountCurrency.value;
}

enums.NatinfPenaltyInputAmountCurrency natinfPenaltyInputAmountCurrencyFromJson(
  Object? natinfPenaltyInputAmountCurrency, [
  enums.NatinfPenaltyInputAmountCurrency? defaultValue,
]) {
  return enums.NatinfPenaltyInputAmountCurrency.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyInputAmountCurrency,
      ) ??
      defaultValue ??
      enums.NatinfPenaltyInputAmountCurrency.swaggerGeneratedUnknown;
}

enums.NatinfPenaltyInputAmountCurrency?
natinfPenaltyInputAmountCurrencyNullableFromJson(
  Object? natinfPenaltyInputAmountCurrency, [
  enums.NatinfPenaltyInputAmountCurrency? defaultValue,
]) {
  if (natinfPenaltyInputAmountCurrency == null) {
    return null;
  }
  return enums.NatinfPenaltyInputAmountCurrency.values.firstWhereOrNull(
        (e) => e.value == natinfPenaltyInputAmountCurrency,
      ) ??
      defaultValue;
}

String natinfPenaltyInputAmountCurrencyExplodedListToJson(
  List<enums.NatinfPenaltyInputAmountCurrency>?
  natinfPenaltyInputAmountCurrency,
) {
  return natinfPenaltyInputAmountCurrency?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfPenaltyInputAmountCurrencyListToJson(
  List<enums.NatinfPenaltyInputAmountCurrency>?
  natinfPenaltyInputAmountCurrency,
) {
  if (natinfPenaltyInputAmountCurrency == null) {
    return [];
  }

  return natinfPenaltyInputAmountCurrency.map((e) => e.value!).toList();
}

List<enums.NatinfPenaltyInputAmountCurrency>
natinfPenaltyInputAmountCurrencyListFromJson(
  List? natinfPenaltyInputAmountCurrency, [
  List<enums.NatinfPenaltyInputAmountCurrency>? defaultValue,
]) {
  if (natinfPenaltyInputAmountCurrency == null) {
    return defaultValue ?? [];
  }

  return natinfPenaltyInputAmountCurrency
      .map((e) => natinfPenaltyInputAmountCurrencyFromJson(e.toString()))
      .toList();
}

List<enums.NatinfPenaltyInputAmountCurrency>?
natinfPenaltyInputAmountCurrencyNullableListFromJson(
  List? natinfPenaltyInputAmountCurrency, [
  List<enums.NatinfPenaltyInputAmountCurrency>? defaultValue,
]) {
  if (natinfPenaltyInputAmountCurrency == null) {
    return defaultValue;
  }

  return natinfPenaltyInputAmountCurrency
      .map((e) => natinfPenaltyInputAmountCurrencyFromJson(e.toString()))
      .toList();
}

String? natinfUpdateTentativeNullableToJson(
  enums.NatinfUpdateTentative? natinfUpdateTentative,
) {
  return natinfUpdateTentative?.value;
}

String? natinfUpdateTentativeToJson(
  enums.NatinfUpdateTentative natinfUpdateTentative,
) {
  return natinfUpdateTentative.value;
}

enums.NatinfUpdateTentative natinfUpdateTentativeFromJson(
  Object? natinfUpdateTentative, [
  enums.NatinfUpdateTentative? defaultValue,
]) {
  return enums.NatinfUpdateTentative.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateTentative,
      ) ??
      defaultValue ??
      enums.NatinfUpdateTentative.swaggerGeneratedUnknown;
}

enums.NatinfUpdateTentative? natinfUpdateTentativeNullableFromJson(
  Object? natinfUpdateTentative, [
  enums.NatinfUpdateTentative? defaultValue,
]) {
  if (natinfUpdateTentative == null) {
    return null;
  }
  return enums.NatinfUpdateTentative.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateTentative,
      ) ??
      defaultValue;
}

String natinfUpdateTentativeExplodedListToJson(
  List<enums.NatinfUpdateTentative>? natinfUpdateTentative,
) {
  return natinfUpdateTentative?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfUpdateTentativeListToJson(
  List<enums.NatinfUpdateTentative>? natinfUpdateTentative,
) {
  if (natinfUpdateTentative == null) {
    return [];
  }

  return natinfUpdateTentative.map((e) => e.value!).toList();
}

List<enums.NatinfUpdateTentative> natinfUpdateTentativeListFromJson(
  List? natinfUpdateTentative, [
  List<enums.NatinfUpdateTentative>? defaultValue,
]) {
  if (natinfUpdateTentative == null) {
    return defaultValue ?? [];
  }

  return natinfUpdateTentative
      .map((e) => natinfUpdateTentativeFromJson(e.toString()))
      .toList();
}

List<enums.NatinfUpdateTentative>? natinfUpdateTentativeNullableListFromJson(
  List? natinfUpdateTentative, [
  List<enums.NatinfUpdateTentative>? defaultValue,
]) {
  if (natinfUpdateTentative == null) {
    return defaultValue;
  }

  return natinfUpdateTentative
      .map((e) => natinfUpdateTentativeFromJson(e.toString()))
      .toList();
}

String? natinfUpdateAmendeCategoryNullableToJson(
  enums.NatinfUpdateAmendeCategory? natinfUpdateAmendeCategory,
) {
  return natinfUpdateAmendeCategory?.value;
}

String? natinfUpdateAmendeCategoryToJson(
  enums.NatinfUpdateAmendeCategory natinfUpdateAmendeCategory,
) {
  return natinfUpdateAmendeCategory.value;
}

enums.NatinfUpdateAmendeCategory natinfUpdateAmendeCategoryFromJson(
  Object? natinfUpdateAmendeCategory, [
  enums.NatinfUpdateAmendeCategory? defaultValue,
]) {
  return enums.NatinfUpdateAmendeCategory.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateAmendeCategory,
      ) ??
      defaultValue ??
      enums.NatinfUpdateAmendeCategory.swaggerGeneratedUnknown;
}

enums.NatinfUpdateAmendeCategory? natinfUpdateAmendeCategoryNullableFromJson(
  Object? natinfUpdateAmendeCategory, [
  enums.NatinfUpdateAmendeCategory? defaultValue,
]) {
  if (natinfUpdateAmendeCategory == null) {
    return null;
  }
  return enums.NatinfUpdateAmendeCategory.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateAmendeCategory,
      ) ??
      defaultValue;
}

String natinfUpdateAmendeCategoryExplodedListToJson(
  List<enums.NatinfUpdateAmendeCategory>? natinfUpdateAmendeCategory,
) {
  return natinfUpdateAmendeCategory?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfUpdateAmendeCategoryListToJson(
  List<enums.NatinfUpdateAmendeCategory>? natinfUpdateAmendeCategory,
) {
  if (natinfUpdateAmendeCategory == null) {
    return [];
  }

  return natinfUpdateAmendeCategory.map((e) => e.value!).toList();
}

List<enums.NatinfUpdateAmendeCategory> natinfUpdateAmendeCategoryListFromJson(
  List? natinfUpdateAmendeCategory, [
  List<enums.NatinfUpdateAmendeCategory>? defaultValue,
]) {
  if (natinfUpdateAmendeCategory == null) {
    return defaultValue ?? [];
  }

  return natinfUpdateAmendeCategory
      .map((e) => natinfUpdateAmendeCategoryFromJson(e.toString()))
      .toList();
}

List<enums.NatinfUpdateAmendeCategory>?
natinfUpdateAmendeCategoryNullableListFromJson(
  List? natinfUpdateAmendeCategory, [
  List<enums.NatinfUpdateAmendeCategory>? defaultValue,
]) {
  if (natinfUpdateAmendeCategory == null) {
    return defaultValue;
  }

  return natinfUpdateAmendeCategory
      .map((e) => natinfUpdateAmendeCategoryFromJson(e.toString()))
      .toList();
}

String? natinfUpdateControleAlcoolemieNullableToJson(
  enums.NatinfUpdateControleAlcoolemie? natinfUpdateControleAlcoolemie,
) {
  return natinfUpdateControleAlcoolemie?.value;
}

String? natinfUpdateControleAlcoolemieToJson(
  enums.NatinfUpdateControleAlcoolemie natinfUpdateControleAlcoolemie,
) {
  return natinfUpdateControleAlcoolemie.value;
}

enums.NatinfUpdateControleAlcoolemie natinfUpdateControleAlcoolemieFromJson(
  Object? natinfUpdateControleAlcoolemie, [
  enums.NatinfUpdateControleAlcoolemie? defaultValue,
]) {
  return enums.NatinfUpdateControleAlcoolemie.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateControleAlcoolemie,
      ) ??
      defaultValue ??
      enums.NatinfUpdateControleAlcoolemie.swaggerGeneratedUnknown;
}

enums.NatinfUpdateControleAlcoolemie?
natinfUpdateControleAlcoolemieNullableFromJson(
  Object? natinfUpdateControleAlcoolemie, [
  enums.NatinfUpdateControleAlcoolemie? defaultValue,
]) {
  if (natinfUpdateControleAlcoolemie == null) {
    return null;
  }
  return enums.NatinfUpdateControleAlcoolemie.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateControleAlcoolemie,
      ) ??
      defaultValue;
}

String natinfUpdateControleAlcoolemieExplodedListToJson(
  List<enums.NatinfUpdateControleAlcoolemie>? natinfUpdateControleAlcoolemie,
) {
  return natinfUpdateControleAlcoolemie?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfUpdateControleAlcoolemieListToJson(
  List<enums.NatinfUpdateControleAlcoolemie>? natinfUpdateControleAlcoolemie,
) {
  if (natinfUpdateControleAlcoolemie == null) {
    return [];
  }

  return natinfUpdateControleAlcoolemie.map((e) => e.value!).toList();
}

List<enums.NatinfUpdateControleAlcoolemie>
natinfUpdateControleAlcoolemieListFromJson(
  List? natinfUpdateControleAlcoolemie, [
  List<enums.NatinfUpdateControleAlcoolemie>? defaultValue,
]) {
  if (natinfUpdateControleAlcoolemie == null) {
    return defaultValue ?? [];
  }

  return natinfUpdateControleAlcoolemie
      .map((e) => natinfUpdateControleAlcoolemieFromJson(e.toString()))
      .toList();
}

List<enums.NatinfUpdateControleAlcoolemie>?
natinfUpdateControleAlcoolemieNullableListFromJson(
  List? natinfUpdateControleAlcoolemie, [
  List<enums.NatinfUpdateControleAlcoolemie>? defaultValue,
]) {
  if (natinfUpdateControleAlcoolemie == null) {
    return defaultValue;
  }

  return natinfUpdateControleAlcoolemie
      .map((e) => natinfUpdateControleAlcoolemieFromJson(e.toString()))
      .toList();
}

String? natinfUpdateDepistageImpregnationAlcooliqueNullableToJson(
  enums.NatinfUpdateDepistageImpregnationAlcoolique?
  natinfUpdateDepistageImpregnationAlcoolique,
) {
  return natinfUpdateDepistageImpregnationAlcoolique?.value;
}

String? natinfUpdateDepistageImpregnationAlcooliqueToJson(
  enums.NatinfUpdateDepistageImpregnationAlcoolique
  natinfUpdateDepistageImpregnationAlcoolique,
) {
  return natinfUpdateDepistageImpregnationAlcoolique.value;
}

enums.NatinfUpdateDepistageImpregnationAlcoolique
natinfUpdateDepistageImpregnationAlcooliqueFromJson(
  Object? natinfUpdateDepistageImpregnationAlcoolique, [
  enums.NatinfUpdateDepistageImpregnationAlcoolique? defaultValue,
]) {
  return enums.NatinfUpdateDepistageImpregnationAlcoolique.values
          .firstWhereOrNull(
            (e) => e.value == natinfUpdateDepistageImpregnationAlcoolique,
          ) ??
      defaultValue ??
      enums.NatinfUpdateDepistageImpregnationAlcoolique.swaggerGeneratedUnknown;
}

enums.NatinfUpdateDepistageImpregnationAlcoolique?
natinfUpdateDepistageImpregnationAlcooliqueNullableFromJson(
  Object? natinfUpdateDepistageImpregnationAlcoolique, [
  enums.NatinfUpdateDepistageImpregnationAlcoolique? defaultValue,
]) {
  if (natinfUpdateDepistageImpregnationAlcoolique == null) {
    return null;
  }
  return enums.NatinfUpdateDepistageImpregnationAlcoolique.values
          .firstWhereOrNull(
            (e) => e.value == natinfUpdateDepistageImpregnationAlcoolique,
          ) ??
      defaultValue;
}

String natinfUpdateDepistageImpregnationAlcooliqueExplodedListToJson(
  List<enums.NatinfUpdateDepistageImpregnationAlcoolique>?
  natinfUpdateDepistageImpregnationAlcoolique,
) {
  return natinfUpdateDepistageImpregnationAlcoolique
          ?.map((e) => e.value!)
          .join(',') ??
      '';
}

List<String> natinfUpdateDepistageImpregnationAlcooliqueListToJson(
  List<enums.NatinfUpdateDepistageImpregnationAlcoolique>?
  natinfUpdateDepistageImpregnationAlcoolique,
) {
  if (natinfUpdateDepistageImpregnationAlcoolique == null) {
    return [];
  }

  return natinfUpdateDepistageImpregnationAlcoolique
      .map((e) => e.value!)
      .toList();
}

List<enums.NatinfUpdateDepistageImpregnationAlcoolique>
natinfUpdateDepistageImpregnationAlcooliqueListFromJson(
  List? natinfUpdateDepistageImpregnationAlcoolique, [
  List<enums.NatinfUpdateDepistageImpregnationAlcoolique>? defaultValue,
]) {
  if (natinfUpdateDepistageImpregnationAlcoolique == null) {
    return defaultValue ?? [];
  }

  return natinfUpdateDepistageImpregnationAlcoolique
      .map(
        (e) =>
            natinfUpdateDepistageImpregnationAlcooliqueFromJson(e.toString()),
      )
      .toList();
}

List<enums.NatinfUpdateDepistageImpregnationAlcoolique>?
natinfUpdateDepistageImpregnationAlcooliqueNullableListFromJson(
  List? natinfUpdateDepistageImpregnationAlcoolique, [
  List<enums.NatinfUpdateDepistageImpregnationAlcoolique>? defaultValue,
]) {
  if (natinfUpdateDepistageImpregnationAlcoolique == null) {
    return defaultValue;
  }

  return natinfUpdateDepistageImpregnationAlcoolique
      .map(
        (e) =>
            natinfUpdateDepistageImpregnationAlcooliqueFromJson(e.toString()),
      )
      .toList();
}

String? natinfUpdateDepistageStupefiantsNullableToJson(
  enums.NatinfUpdateDepistageStupefiants? natinfUpdateDepistageStupefiants,
) {
  return natinfUpdateDepistageStupefiants?.value;
}

String? natinfUpdateDepistageStupefiantsToJson(
  enums.NatinfUpdateDepistageStupefiants natinfUpdateDepistageStupefiants,
) {
  return natinfUpdateDepistageStupefiants.value;
}

enums.NatinfUpdateDepistageStupefiants natinfUpdateDepistageStupefiantsFromJson(
  Object? natinfUpdateDepistageStupefiants, [
  enums.NatinfUpdateDepistageStupefiants? defaultValue,
]) {
  return enums.NatinfUpdateDepistageStupefiants.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateDepistageStupefiants,
      ) ??
      defaultValue ??
      enums.NatinfUpdateDepistageStupefiants.swaggerGeneratedUnknown;
}

enums.NatinfUpdateDepistageStupefiants?
natinfUpdateDepistageStupefiantsNullableFromJson(
  Object? natinfUpdateDepistageStupefiants, [
  enums.NatinfUpdateDepistageStupefiants? defaultValue,
]) {
  if (natinfUpdateDepistageStupefiants == null) {
    return null;
  }
  return enums.NatinfUpdateDepistageStupefiants.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateDepistageStupefiants,
      ) ??
      defaultValue;
}

String natinfUpdateDepistageStupefiantsExplodedListToJson(
  List<enums.NatinfUpdateDepistageStupefiants>?
  natinfUpdateDepistageStupefiants,
) {
  return natinfUpdateDepistageStupefiants?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfUpdateDepistageStupefiantsListToJson(
  List<enums.NatinfUpdateDepistageStupefiants>?
  natinfUpdateDepistageStupefiants,
) {
  if (natinfUpdateDepistageStupefiants == null) {
    return [];
  }

  return natinfUpdateDepistageStupefiants.map((e) => e.value!).toList();
}

List<enums.NatinfUpdateDepistageStupefiants>
natinfUpdateDepistageStupefiantsListFromJson(
  List? natinfUpdateDepistageStupefiants, [
  List<enums.NatinfUpdateDepistageStupefiants>? defaultValue,
]) {
  if (natinfUpdateDepistageStupefiants == null) {
    return defaultValue ?? [];
  }

  return natinfUpdateDepistageStupefiants
      .map((e) => natinfUpdateDepistageStupefiantsFromJson(e.toString()))
      .toList();
}

List<enums.NatinfUpdateDepistageStupefiants>?
natinfUpdateDepistageStupefiantsNullableListFromJson(
  List? natinfUpdateDepistageStupefiants, [
  List<enums.NatinfUpdateDepistageStupefiants>? defaultValue,
]) {
  if (natinfUpdateDepistageStupefiants == null) {
    return defaultValue;
  }

  return natinfUpdateDepistageStupefiants
      .map((e) => natinfUpdateDepistageStupefiantsFromJson(e.toString()))
      .toList();
}

int? natinfUpdateRetraitPointsNullableToJson(
  enums.NatinfUpdateRetraitPoints? natinfUpdateRetraitPoints,
) {
  return natinfUpdateRetraitPoints?.value;
}

int? natinfUpdateRetraitPointsToJson(
  enums.NatinfUpdateRetraitPoints natinfUpdateRetraitPoints,
) {
  return natinfUpdateRetraitPoints.value;
}

enums.NatinfUpdateRetraitPoints natinfUpdateRetraitPointsFromJson(
  Object? natinfUpdateRetraitPoints, [
  enums.NatinfUpdateRetraitPoints? defaultValue,
]) {
  return enums.NatinfUpdateRetraitPoints.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateRetraitPoints,
      ) ??
      defaultValue ??
      enums.NatinfUpdateRetraitPoints.swaggerGeneratedUnknown;
}

enums.NatinfUpdateRetraitPoints? natinfUpdateRetraitPointsNullableFromJson(
  Object? natinfUpdateRetraitPoints, [
  enums.NatinfUpdateRetraitPoints? defaultValue,
]) {
  if (natinfUpdateRetraitPoints == null) {
    return null;
  }
  return enums.NatinfUpdateRetraitPoints.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateRetraitPoints,
      ) ??
      defaultValue;
}

String natinfUpdateRetraitPointsExplodedListToJson(
  List<enums.NatinfUpdateRetraitPoints>? natinfUpdateRetraitPoints,
) {
  return natinfUpdateRetraitPoints?.map((e) => e.value!).join(',') ?? '';
}

List<int> natinfUpdateRetraitPointsListToJson(
  List<enums.NatinfUpdateRetraitPoints>? natinfUpdateRetraitPoints,
) {
  if (natinfUpdateRetraitPoints == null) {
    return [];
  }

  return natinfUpdateRetraitPoints.map((e) => e.value!).toList();
}

List<enums.NatinfUpdateRetraitPoints> natinfUpdateRetraitPointsListFromJson(
  List? natinfUpdateRetraitPoints, [
  List<enums.NatinfUpdateRetraitPoints>? defaultValue,
]) {
  if (natinfUpdateRetraitPoints == null) {
    return defaultValue ?? [];
  }

  return natinfUpdateRetraitPoints
      .map((e) => natinfUpdateRetraitPointsFromJson(e.toString()))
      .toList();
}

List<enums.NatinfUpdateRetraitPoints>?
natinfUpdateRetraitPointsNullableListFromJson(
  List? natinfUpdateRetraitPoints, [
  List<enums.NatinfUpdateRetraitPoints>? defaultValue,
]) {
  if (natinfUpdateRetraitPoints == null) {
    return defaultValue;
  }

  return natinfUpdateRetraitPoints
      .map((e) => natinfUpdateRetraitPointsFromJson(e.toString()))
      .toList();
}

String? natinfUpdateRetentionPermisConduireNullableToJson(
  enums.NatinfUpdateRetentionPermisConduire?
  natinfUpdateRetentionPermisConduire,
) {
  return natinfUpdateRetentionPermisConduire?.value;
}

String? natinfUpdateRetentionPermisConduireToJson(
  enums.NatinfUpdateRetentionPermisConduire natinfUpdateRetentionPermisConduire,
) {
  return natinfUpdateRetentionPermisConduire.value;
}

enums.NatinfUpdateRetentionPermisConduire
natinfUpdateRetentionPermisConduireFromJson(
  Object? natinfUpdateRetentionPermisConduire, [
  enums.NatinfUpdateRetentionPermisConduire? defaultValue,
]) {
  return enums.NatinfUpdateRetentionPermisConduire.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateRetentionPermisConduire,
      ) ??
      defaultValue ??
      enums.NatinfUpdateRetentionPermisConduire.swaggerGeneratedUnknown;
}

enums.NatinfUpdateRetentionPermisConduire?
natinfUpdateRetentionPermisConduireNullableFromJson(
  Object? natinfUpdateRetentionPermisConduire, [
  enums.NatinfUpdateRetentionPermisConduire? defaultValue,
]) {
  if (natinfUpdateRetentionPermisConduire == null) {
    return null;
  }
  return enums.NatinfUpdateRetentionPermisConduire.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateRetentionPermisConduire,
      ) ??
      defaultValue;
}

String natinfUpdateRetentionPermisConduireExplodedListToJson(
  List<enums.NatinfUpdateRetentionPermisConduire>?
  natinfUpdateRetentionPermisConduire,
) {
  return natinfUpdateRetentionPermisConduire?.map((e) => e.value!).join(',') ??
      '';
}

List<String> natinfUpdateRetentionPermisConduireListToJson(
  List<enums.NatinfUpdateRetentionPermisConduire>?
  natinfUpdateRetentionPermisConduire,
) {
  if (natinfUpdateRetentionPermisConduire == null) {
    return [];
  }

  return natinfUpdateRetentionPermisConduire.map((e) => e.value!).toList();
}

List<enums.NatinfUpdateRetentionPermisConduire>
natinfUpdateRetentionPermisConduireListFromJson(
  List? natinfUpdateRetentionPermisConduire, [
  List<enums.NatinfUpdateRetentionPermisConduire>? defaultValue,
]) {
  if (natinfUpdateRetentionPermisConduire == null) {
    return defaultValue ?? [];
  }

  return natinfUpdateRetentionPermisConduire
      .map((e) => natinfUpdateRetentionPermisConduireFromJson(e.toString()))
      .toList();
}

List<enums.NatinfUpdateRetentionPermisConduire>?
natinfUpdateRetentionPermisConduireNullableListFromJson(
  List? natinfUpdateRetentionPermisConduire, [
  List<enums.NatinfUpdateRetentionPermisConduire>? defaultValue,
]) {
  if (natinfUpdateRetentionPermisConduire == null) {
    return defaultValue;
  }

  return natinfUpdateRetentionPermisConduire
      .map((e) => natinfUpdateRetentionPermisConduireFromJson(e.toString()))
      .toList();
}

String? natinfUpdateImmobilisationVehiculeNullableToJson(
  enums.NatinfUpdateImmobilisationVehicule? natinfUpdateImmobilisationVehicule,
) {
  return natinfUpdateImmobilisationVehicule?.value;
}

String? natinfUpdateImmobilisationVehiculeToJson(
  enums.NatinfUpdateImmobilisationVehicule natinfUpdateImmobilisationVehicule,
) {
  return natinfUpdateImmobilisationVehicule.value;
}

enums.NatinfUpdateImmobilisationVehicule
natinfUpdateImmobilisationVehiculeFromJson(
  Object? natinfUpdateImmobilisationVehicule, [
  enums.NatinfUpdateImmobilisationVehicule? defaultValue,
]) {
  return enums.NatinfUpdateImmobilisationVehicule.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateImmobilisationVehicule,
      ) ??
      defaultValue ??
      enums.NatinfUpdateImmobilisationVehicule.swaggerGeneratedUnknown;
}

enums.NatinfUpdateImmobilisationVehicule?
natinfUpdateImmobilisationVehiculeNullableFromJson(
  Object? natinfUpdateImmobilisationVehicule, [
  enums.NatinfUpdateImmobilisationVehicule? defaultValue,
]) {
  if (natinfUpdateImmobilisationVehicule == null) {
    return null;
  }
  return enums.NatinfUpdateImmobilisationVehicule.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateImmobilisationVehicule,
      ) ??
      defaultValue;
}

String natinfUpdateImmobilisationVehiculeExplodedListToJson(
  List<enums.NatinfUpdateImmobilisationVehicule>?
  natinfUpdateImmobilisationVehicule,
) {
  return natinfUpdateImmobilisationVehicule?.map((e) => e.value!).join(',') ??
      '';
}

List<String> natinfUpdateImmobilisationVehiculeListToJson(
  List<enums.NatinfUpdateImmobilisationVehicule>?
  natinfUpdateImmobilisationVehicule,
) {
  if (natinfUpdateImmobilisationVehicule == null) {
    return [];
  }

  return natinfUpdateImmobilisationVehicule.map((e) => e.value!).toList();
}

List<enums.NatinfUpdateImmobilisationVehicule>
natinfUpdateImmobilisationVehiculeListFromJson(
  List? natinfUpdateImmobilisationVehicule, [
  List<enums.NatinfUpdateImmobilisationVehicule>? defaultValue,
]) {
  if (natinfUpdateImmobilisationVehicule == null) {
    return defaultValue ?? [];
  }

  return natinfUpdateImmobilisationVehicule
      .map((e) => natinfUpdateImmobilisationVehiculeFromJson(e.toString()))
      .toList();
}

List<enums.NatinfUpdateImmobilisationVehicule>?
natinfUpdateImmobilisationVehiculeNullableListFromJson(
  List? natinfUpdateImmobilisationVehicule, [
  List<enums.NatinfUpdateImmobilisationVehicule>? defaultValue,
]) {
  if (natinfUpdateImmobilisationVehicule == null) {
    return defaultValue;
  }

  return natinfUpdateImmobilisationVehicule
      .map((e) => natinfUpdateImmobilisationVehiculeFromJson(e.toString()))
      .toList();
}

String? natinfUpdateMiseEnFourriereNullableToJson(
  enums.NatinfUpdateMiseEnFourriere? natinfUpdateMiseEnFourriere,
) {
  return natinfUpdateMiseEnFourriere?.value;
}

String? natinfUpdateMiseEnFourriereToJson(
  enums.NatinfUpdateMiseEnFourriere natinfUpdateMiseEnFourriere,
) {
  return natinfUpdateMiseEnFourriere.value;
}

enums.NatinfUpdateMiseEnFourriere natinfUpdateMiseEnFourriereFromJson(
  Object? natinfUpdateMiseEnFourriere, [
  enums.NatinfUpdateMiseEnFourriere? defaultValue,
]) {
  return enums.NatinfUpdateMiseEnFourriere.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateMiseEnFourriere,
      ) ??
      defaultValue ??
      enums.NatinfUpdateMiseEnFourriere.swaggerGeneratedUnknown;
}

enums.NatinfUpdateMiseEnFourriere? natinfUpdateMiseEnFourriereNullableFromJson(
  Object? natinfUpdateMiseEnFourriere, [
  enums.NatinfUpdateMiseEnFourriere? defaultValue,
]) {
  if (natinfUpdateMiseEnFourriere == null) {
    return null;
  }
  return enums.NatinfUpdateMiseEnFourriere.values.firstWhereOrNull(
        (e) => e.value == natinfUpdateMiseEnFourriere,
      ) ??
      defaultValue;
}

String natinfUpdateMiseEnFourriereExplodedListToJson(
  List<enums.NatinfUpdateMiseEnFourriere>? natinfUpdateMiseEnFourriere,
) {
  return natinfUpdateMiseEnFourriere?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfUpdateMiseEnFourriereListToJson(
  List<enums.NatinfUpdateMiseEnFourriere>? natinfUpdateMiseEnFourriere,
) {
  if (natinfUpdateMiseEnFourriere == null) {
    return [];
  }

  return natinfUpdateMiseEnFourriere.map((e) => e.value!).toList();
}

List<enums.NatinfUpdateMiseEnFourriere> natinfUpdateMiseEnFourriereListFromJson(
  List? natinfUpdateMiseEnFourriere, [
  List<enums.NatinfUpdateMiseEnFourriere>? defaultValue,
]) {
  if (natinfUpdateMiseEnFourriere == null) {
    return defaultValue ?? [];
  }

  return natinfUpdateMiseEnFourriere
      .map((e) => natinfUpdateMiseEnFourriereFromJson(e.toString()))
      .toList();
}

List<enums.NatinfUpdateMiseEnFourriere>?
natinfUpdateMiseEnFourriereNullableListFromJson(
  List? natinfUpdateMiseEnFourriere, [
  List<enums.NatinfUpdateMiseEnFourriere>? defaultValue,
]) {
  if (natinfUpdateMiseEnFourriere == null) {
    return defaultValue;
  }

  return natinfUpdateMiseEnFourriere
      .map((e) => natinfUpdateMiseEnFourriereFromJson(e.toString()))
      .toList();
}

String? natinfSearchTentativeNullableToJson(
  enums.NatinfSearchTentative? natinfSearchTentative,
) {
  return natinfSearchTentative?.value;
}

String? natinfSearchTentativeToJson(
  enums.NatinfSearchTentative natinfSearchTentative,
) {
  return natinfSearchTentative.value;
}

enums.NatinfSearchTentative natinfSearchTentativeFromJson(
  Object? natinfSearchTentative, [
  enums.NatinfSearchTentative? defaultValue,
]) {
  return enums.NatinfSearchTentative.values.firstWhereOrNull(
        (e) => e.value == natinfSearchTentative,
      ) ??
      defaultValue ??
      enums.NatinfSearchTentative.swaggerGeneratedUnknown;
}

enums.NatinfSearchTentative? natinfSearchTentativeNullableFromJson(
  Object? natinfSearchTentative, [
  enums.NatinfSearchTentative? defaultValue,
]) {
  if (natinfSearchTentative == null) {
    return null;
  }
  return enums.NatinfSearchTentative.values.firstWhereOrNull(
        (e) => e.value == natinfSearchTentative,
      ) ??
      defaultValue;
}

String natinfSearchTentativeExplodedListToJson(
  List<enums.NatinfSearchTentative>? natinfSearchTentative,
) {
  return natinfSearchTentative?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfSearchTentativeListToJson(
  List<enums.NatinfSearchTentative>? natinfSearchTentative,
) {
  if (natinfSearchTentative == null) {
    return [];
  }

  return natinfSearchTentative.map((e) => e.value!).toList();
}

List<enums.NatinfSearchTentative> natinfSearchTentativeListFromJson(
  List? natinfSearchTentative, [
  List<enums.NatinfSearchTentative>? defaultValue,
]) {
  if (natinfSearchTentative == null) {
    return defaultValue ?? [];
  }

  return natinfSearchTentative
      .map((e) => natinfSearchTentativeFromJson(e.toString()))
      .toList();
}

List<enums.NatinfSearchTentative>? natinfSearchTentativeNullableListFromJson(
  List? natinfSearchTentative, [
  List<enums.NatinfSearchTentative>? defaultValue,
]) {
  if (natinfSearchTentative == null) {
    return defaultValue;
  }

  return natinfSearchTentative
      .map((e) => natinfSearchTentativeFromJson(e.toString()))
      .toList();
}

String? natinfSearchAmendeCategoryNullableToJson(
  enums.NatinfSearchAmendeCategory? natinfSearchAmendeCategory,
) {
  return natinfSearchAmendeCategory?.value;
}

String? natinfSearchAmendeCategoryToJson(
  enums.NatinfSearchAmendeCategory natinfSearchAmendeCategory,
) {
  return natinfSearchAmendeCategory.value;
}

enums.NatinfSearchAmendeCategory natinfSearchAmendeCategoryFromJson(
  Object? natinfSearchAmendeCategory, [
  enums.NatinfSearchAmendeCategory? defaultValue,
]) {
  return enums.NatinfSearchAmendeCategory.values.firstWhereOrNull(
        (e) => e.value == natinfSearchAmendeCategory,
      ) ??
      defaultValue ??
      enums.NatinfSearchAmendeCategory.swaggerGeneratedUnknown;
}

enums.NatinfSearchAmendeCategory? natinfSearchAmendeCategoryNullableFromJson(
  Object? natinfSearchAmendeCategory, [
  enums.NatinfSearchAmendeCategory? defaultValue,
]) {
  if (natinfSearchAmendeCategory == null) {
    return null;
  }
  return enums.NatinfSearchAmendeCategory.values.firstWhereOrNull(
        (e) => e.value == natinfSearchAmendeCategory,
      ) ??
      defaultValue;
}

String natinfSearchAmendeCategoryExplodedListToJson(
  List<enums.NatinfSearchAmendeCategory>? natinfSearchAmendeCategory,
) {
  return natinfSearchAmendeCategory?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfSearchAmendeCategoryListToJson(
  List<enums.NatinfSearchAmendeCategory>? natinfSearchAmendeCategory,
) {
  if (natinfSearchAmendeCategory == null) {
    return [];
  }

  return natinfSearchAmendeCategory.map((e) => e.value!).toList();
}

List<enums.NatinfSearchAmendeCategory> natinfSearchAmendeCategoryListFromJson(
  List? natinfSearchAmendeCategory, [
  List<enums.NatinfSearchAmendeCategory>? defaultValue,
]) {
  if (natinfSearchAmendeCategory == null) {
    return defaultValue ?? [];
  }

  return natinfSearchAmendeCategory
      .map((e) => natinfSearchAmendeCategoryFromJson(e.toString()))
      .toList();
}

List<enums.NatinfSearchAmendeCategory>?
natinfSearchAmendeCategoryNullableListFromJson(
  List? natinfSearchAmendeCategory, [
  List<enums.NatinfSearchAmendeCategory>? defaultValue,
]) {
  if (natinfSearchAmendeCategory == null) {
    return defaultValue;
  }

  return natinfSearchAmendeCategory
      .map((e) => natinfSearchAmendeCategoryFromJson(e.toString()))
      .toList();
}

String? natinfSearchControleAlcoolemieNullableToJson(
  enums.NatinfSearchControleAlcoolemie? natinfSearchControleAlcoolemie,
) {
  return natinfSearchControleAlcoolemie?.value;
}

String? natinfSearchControleAlcoolemieToJson(
  enums.NatinfSearchControleAlcoolemie natinfSearchControleAlcoolemie,
) {
  return natinfSearchControleAlcoolemie.value;
}

enums.NatinfSearchControleAlcoolemie natinfSearchControleAlcoolemieFromJson(
  Object? natinfSearchControleAlcoolemie, [
  enums.NatinfSearchControleAlcoolemie? defaultValue,
]) {
  return enums.NatinfSearchControleAlcoolemie.values.firstWhereOrNull(
        (e) => e.value == natinfSearchControleAlcoolemie,
      ) ??
      defaultValue ??
      enums.NatinfSearchControleAlcoolemie.swaggerGeneratedUnknown;
}

enums.NatinfSearchControleAlcoolemie?
natinfSearchControleAlcoolemieNullableFromJson(
  Object? natinfSearchControleAlcoolemie, [
  enums.NatinfSearchControleAlcoolemie? defaultValue,
]) {
  if (natinfSearchControleAlcoolemie == null) {
    return null;
  }
  return enums.NatinfSearchControleAlcoolemie.values.firstWhereOrNull(
        (e) => e.value == natinfSearchControleAlcoolemie,
      ) ??
      defaultValue;
}

String natinfSearchControleAlcoolemieExplodedListToJson(
  List<enums.NatinfSearchControleAlcoolemie>? natinfSearchControleAlcoolemie,
) {
  return natinfSearchControleAlcoolemie?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfSearchControleAlcoolemieListToJson(
  List<enums.NatinfSearchControleAlcoolemie>? natinfSearchControleAlcoolemie,
) {
  if (natinfSearchControleAlcoolemie == null) {
    return [];
  }

  return natinfSearchControleAlcoolemie.map((e) => e.value!).toList();
}

List<enums.NatinfSearchControleAlcoolemie>
natinfSearchControleAlcoolemieListFromJson(
  List? natinfSearchControleAlcoolemie, [
  List<enums.NatinfSearchControleAlcoolemie>? defaultValue,
]) {
  if (natinfSearchControleAlcoolemie == null) {
    return defaultValue ?? [];
  }

  return natinfSearchControleAlcoolemie
      .map((e) => natinfSearchControleAlcoolemieFromJson(e.toString()))
      .toList();
}

List<enums.NatinfSearchControleAlcoolemie>?
natinfSearchControleAlcoolemieNullableListFromJson(
  List? natinfSearchControleAlcoolemie, [
  List<enums.NatinfSearchControleAlcoolemie>? defaultValue,
]) {
  if (natinfSearchControleAlcoolemie == null) {
    return defaultValue;
  }

  return natinfSearchControleAlcoolemie
      .map((e) => natinfSearchControleAlcoolemieFromJson(e.toString()))
      .toList();
}

String? natinfSearchDepistageImpregnationAlcooliqueNullableToJson(
  enums.NatinfSearchDepistageImpregnationAlcoolique?
  natinfSearchDepistageImpregnationAlcoolique,
) {
  return natinfSearchDepistageImpregnationAlcoolique?.value;
}

String? natinfSearchDepistageImpregnationAlcooliqueToJson(
  enums.NatinfSearchDepistageImpregnationAlcoolique
  natinfSearchDepistageImpregnationAlcoolique,
) {
  return natinfSearchDepistageImpregnationAlcoolique.value;
}

enums.NatinfSearchDepistageImpregnationAlcoolique
natinfSearchDepistageImpregnationAlcooliqueFromJson(
  Object? natinfSearchDepistageImpregnationAlcoolique, [
  enums.NatinfSearchDepistageImpregnationAlcoolique? defaultValue,
]) {
  return enums.NatinfSearchDepistageImpregnationAlcoolique.values
          .firstWhereOrNull(
            (e) => e.value == natinfSearchDepistageImpregnationAlcoolique,
          ) ??
      defaultValue ??
      enums.NatinfSearchDepistageImpregnationAlcoolique.swaggerGeneratedUnknown;
}

enums.NatinfSearchDepistageImpregnationAlcoolique?
natinfSearchDepistageImpregnationAlcooliqueNullableFromJson(
  Object? natinfSearchDepistageImpregnationAlcoolique, [
  enums.NatinfSearchDepistageImpregnationAlcoolique? defaultValue,
]) {
  if (natinfSearchDepistageImpregnationAlcoolique == null) {
    return null;
  }
  return enums.NatinfSearchDepistageImpregnationAlcoolique.values
          .firstWhereOrNull(
            (e) => e.value == natinfSearchDepistageImpregnationAlcoolique,
          ) ??
      defaultValue;
}

String natinfSearchDepistageImpregnationAlcooliqueExplodedListToJson(
  List<enums.NatinfSearchDepistageImpregnationAlcoolique>?
  natinfSearchDepistageImpregnationAlcoolique,
) {
  return natinfSearchDepistageImpregnationAlcoolique
          ?.map((e) => e.value!)
          .join(',') ??
      '';
}

List<String> natinfSearchDepistageImpregnationAlcooliqueListToJson(
  List<enums.NatinfSearchDepistageImpregnationAlcoolique>?
  natinfSearchDepistageImpregnationAlcoolique,
) {
  if (natinfSearchDepistageImpregnationAlcoolique == null) {
    return [];
  }

  return natinfSearchDepistageImpregnationAlcoolique
      .map((e) => e.value!)
      .toList();
}

List<enums.NatinfSearchDepistageImpregnationAlcoolique>
natinfSearchDepistageImpregnationAlcooliqueListFromJson(
  List? natinfSearchDepistageImpregnationAlcoolique, [
  List<enums.NatinfSearchDepistageImpregnationAlcoolique>? defaultValue,
]) {
  if (natinfSearchDepistageImpregnationAlcoolique == null) {
    return defaultValue ?? [];
  }

  return natinfSearchDepistageImpregnationAlcoolique
      .map(
        (e) =>
            natinfSearchDepistageImpregnationAlcooliqueFromJson(e.toString()),
      )
      .toList();
}

List<enums.NatinfSearchDepistageImpregnationAlcoolique>?
natinfSearchDepistageImpregnationAlcooliqueNullableListFromJson(
  List? natinfSearchDepistageImpregnationAlcoolique, [
  List<enums.NatinfSearchDepistageImpregnationAlcoolique>? defaultValue,
]) {
  if (natinfSearchDepistageImpregnationAlcoolique == null) {
    return defaultValue;
  }

  return natinfSearchDepistageImpregnationAlcoolique
      .map(
        (e) =>
            natinfSearchDepistageImpregnationAlcooliqueFromJson(e.toString()),
      )
      .toList();
}

String? natinfSearchDepistageStupefiantsNullableToJson(
  enums.NatinfSearchDepistageStupefiants? natinfSearchDepistageStupefiants,
) {
  return natinfSearchDepistageStupefiants?.value;
}

String? natinfSearchDepistageStupefiantsToJson(
  enums.NatinfSearchDepistageStupefiants natinfSearchDepistageStupefiants,
) {
  return natinfSearchDepistageStupefiants.value;
}

enums.NatinfSearchDepistageStupefiants natinfSearchDepistageStupefiantsFromJson(
  Object? natinfSearchDepistageStupefiants, [
  enums.NatinfSearchDepistageStupefiants? defaultValue,
]) {
  return enums.NatinfSearchDepistageStupefiants.values.firstWhereOrNull(
        (e) => e.value == natinfSearchDepistageStupefiants,
      ) ??
      defaultValue ??
      enums.NatinfSearchDepistageStupefiants.swaggerGeneratedUnknown;
}

enums.NatinfSearchDepistageStupefiants?
natinfSearchDepistageStupefiantsNullableFromJson(
  Object? natinfSearchDepistageStupefiants, [
  enums.NatinfSearchDepistageStupefiants? defaultValue,
]) {
  if (natinfSearchDepistageStupefiants == null) {
    return null;
  }
  return enums.NatinfSearchDepistageStupefiants.values.firstWhereOrNull(
        (e) => e.value == natinfSearchDepistageStupefiants,
      ) ??
      defaultValue;
}

String natinfSearchDepistageStupefiantsExplodedListToJson(
  List<enums.NatinfSearchDepistageStupefiants>?
  natinfSearchDepistageStupefiants,
) {
  return natinfSearchDepistageStupefiants?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfSearchDepistageStupefiantsListToJson(
  List<enums.NatinfSearchDepistageStupefiants>?
  natinfSearchDepistageStupefiants,
) {
  if (natinfSearchDepistageStupefiants == null) {
    return [];
  }

  return natinfSearchDepistageStupefiants.map((e) => e.value!).toList();
}

List<enums.NatinfSearchDepistageStupefiants>
natinfSearchDepistageStupefiantsListFromJson(
  List? natinfSearchDepistageStupefiants, [
  List<enums.NatinfSearchDepistageStupefiants>? defaultValue,
]) {
  if (natinfSearchDepistageStupefiants == null) {
    return defaultValue ?? [];
  }

  return natinfSearchDepistageStupefiants
      .map((e) => natinfSearchDepistageStupefiantsFromJson(e.toString()))
      .toList();
}

List<enums.NatinfSearchDepistageStupefiants>?
natinfSearchDepistageStupefiantsNullableListFromJson(
  List? natinfSearchDepistageStupefiants, [
  List<enums.NatinfSearchDepistageStupefiants>? defaultValue,
]) {
  if (natinfSearchDepistageStupefiants == null) {
    return defaultValue;
  }

  return natinfSearchDepistageStupefiants
      .map((e) => natinfSearchDepistageStupefiantsFromJson(e.toString()))
      .toList();
}

int? natinfSearchRetraitPointsNullableToJson(
  enums.NatinfSearchRetraitPoints? natinfSearchRetraitPoints,
) {
  return natinfSearchRetraitPoints?.value;
}

int? natinfSearchRetraitPointsToJson(
  enums.NatinfSearchRetraitPoints natinfSearchRetraitPoints,
) {
  return natinfSearchRetraitPoints.value;
}

enums.NatinfSearchRetraitPoints natinfSearchRetraitPointsFromJson(
  Object? natinfSearchRetraitPoints, [
  enums.NatinfSearchRetraitPoints? defaultValue,
]) {
  return enums.NatinfSearchRetraitPoints.values.firstWhereOrNull(
        (e) => e.value == natinfSearchRetraitPoints,
      ) ??
      defaultValue ??
      enums.NatinfSearchRetraitPoints.swaggerGeneratedUnknown;
}

enums.NatinfSearchRetraitPoints? natinfSearchRetraitPointsNullableFromJson(
  Object? natinfSearchRetraitPoints, [
  enums.NatinfSearchRetraitPoints? defaultValue,
]) {
  if (natinfSearchRetraitPoints == null) {
    return null;
  }
  return enums.NatinfSearchRetraitPoints.values.firstWhereOrNull(
        (e) => e.value == natinfSearchRetraitPoints,
      ) ??
      defaultValue;
}

String natinfSearchRetraitPointsExplodedListToJson(
  List<enums.NatinfSearchRetraitPoints>? natinfSearchRetraitPoints,
) {
  return natinfSearchRetraitPoints?.map((e) => e.value!).join(',') ?? '';
}

List<int> natinfSearchRetraitPointsListToJson(
  List<enums.NatinfSearchRetraitPoints>? natinfSearchRetraitPoints,
) {
  if (natinfSearchRetraitPoints == null) {
    return [];
  }

  return natinfSearchRetraitPoints.map((e) => e.value!).toList();
}

List<enums.NatinfSearchRetraitPoints> natinfSearchRetraitPointsListFromJson(
  List? natinfSearchRetraitPoints, [
  List<enums.NatinfSearchRetraitPoints>? defaultValue,
]) {
  if (natinfSearchRetraitPoints == null) {
    return defaultValue ?? [];
  }

  return natinfSearchRetraitPoints
      .map((e) => natinfSearchRetraitPointsFromJson(e.toString()))
      .toList();
}

List<enums.NatinfSearchRetraitPoints>?
natinfSearchRetraitPointsNullableListFromJson(
  List? natinfSearchRetraitPoints, [
  List<enums.NatinfSearchRetraitPoints>? defaultValue,
]) {
  if (natinfSearchRetraitPoints == null) {
    return defaultValue;
  }

  return natinfSearchRetraitPoints
      .map((e) => natinfSearchRetraitPointsFromJson(e.toString()))
      .toList();
}

String? natinfSearchRetentionPermisConduireNullableToJson(
  enums.NatinfSearchRetentionPermisConduire?
  natinfSearchRetentionPermisConduire,
) {
  return natinfSearchRetentionPermisConduire?.value;
}

String? natinfSearchRetentionPermisConduireToJson(
  enums.NatinfSearchRetentionPermisConduire natinfSearchRetentionPermisConduire,
) {
  return natinfSearchRetentionPermisConduire.value;
}

enums.NatinfSearchRetentionPermisConduire
natinfSearchRetentionPermisConduireFromJson(
  Object? natinfSearchRetentionPermisConduire, [
  enums.NatinfSearchRetentionPermisConduire? defaultValue,
]) {
  return enums.NatinfSearchRetentionPermisConduire.values.firstWhereOrNull(
        (e) => e.value == natinfSearchRetentionPermisConduire,
      ) ??
      defaultValue ??
      enums.NatinfSearchRetentionPermisConduire.swaggerGeneratedUnknown;
}

enums.NatinfSearchRetentionPermisConduire?
natinfSearchRetentionPermisConduireNullableFromJson(
  Object? natinfSearchRetentionPermisConduire, [
  enums.NatinfSearchRetentionPermisConduire? defaultValue,
]) {
  if (natinfSearchRetentionPermisConduire == null) {
    return null;
  }
  return enums.NatinfSearchRetentionPermisConduire.values.firstWhereOrNull(
        (e) => e.value == natinfSearchRetentionPermisConduire,
      ) ??
      defaultValue;
}

String natinfSearchRetentionPermisConduireExplodedListToJson(
  List<enums.NatinfSearchRetentionPermisConduire>?
  natinfSearchRetentionPermisConduire,
) {
  return natinfSearchRetentionPermisConduire?.map((e) => e.value!).join(',') ??
      '';
}

List<String> natinfSearchRetentionPermisConduireListToJson(
  List<enums.NatinfSearchRetentionPermisConduire>?
  natinfSearchRetentionPermisConduire,
) {
  if (natinfSearchRetentionPermisConduire == null) {
    return [];
  }

  return natinfSearchRetentionPermisConduire.map((e) => e.value!).toList();
}

List<enums.NatinfSearchRetentionPermisConduire>
natinfSearchRetentionPermisConduireListFromJson(
  List? natinfSearchRetentionPermisConduire, [
  List<enums.NatinfSearchRetentionPermisConduire>? defaultValue,
]) {
  if (natinfSearchRetentionPermisConduire == null) {
    return defaultValue ?? [];
  }

  return natinfSearchRetentionPermisConduire
      .map((e) => natinfSearchRetentionPermisConduireFromJson(e.toString()))
      .toList();
}

List<enums.NatinfSearchRetentionPermisConduire>?
natinfSearchRetentionPermisConduireNullableListFromJson(
  List? natinfSearchRetentionPermisConduire, [
  List<enums.NatinfSearchRetentionPermisConduire>? defaultValue,
]) {
  if (natinfSearchRetentionPermisConduire == null) {
    return defaultValue;
  }

  return natinfSearchRetentionPermisConduire
      .map((e) => natinfSearchRetentionPermisConduireFromJson(e.toString()))
      .toList();
}

String? natinfSearchImmobilisationVehiculeNullableToJson(
  enums.NatinfSearchImmobilisationVehicule? natinfSearchImmobilisationVehicule,
) {
  return natinfSearchImmobilisationVehicule?.value;
}

String? natinfSearchImmobilisationVehiculeToJson(
  enums.NatinfSearchImmobilisationVehicule natinfSearchImmobilisationVehicule,
) {
  return natinfSearchImmobilisationVehicule.value;
}

enums.NatinfSearchImmobilisationVehicule
natinfSearchImmobilisationVehiculeFromJson(
  Object? natinfSearchImmobilisationVehicule, [
  enums.NatinfSearchImmobilisationVehicule? defaultValue,
]) {
  return enums.NatinfSearchImmobilisationVehicule.values.firstWhereOrNull(
        (e) => e.value == natinfSearchImmobilisationVehicule,
      ) ??
      defaultValue ??
      enums.NatinfSearchImmobilisationVehicule.swaggerGeneratedUnknown;
}

enums.NatinfSearchImmobilisationVehicule?
natinfSearchImmobilisationVehiculeNullableFromJson(
  Object? natinfSearchImmobilisationVehicule, [
  enums.NatinfSearchImmobilisationVehicule? defaultValue,
]) {
  if (natinfSearchImmobilisationVehicule == null) {
    return null;
  }
  return enums.NatinfSearchImmobilisationVehicule.values.firstWhereOrNull(
        (e) => e.value == natinfSearchImmobilisationVehicule,
      ) ??
      defaultValue;
}

String natinfSearchImmobilisationVehiculeExplodedListToJson(
  List<enums.NatinfSearchImmobilisationVehicule>?
  natinfSearchImmobilisationVehicule,
) {
  return natinfSearchImmobilisationVehicule?.map((e) => e.value!).join(',') ??
      '';
}

List<String> natinfSearchImmobilisationVehiculeListToJson(
  List<enums.NatinfSearchImmobilisationVehicule>?
  natinfSearchImmobilisationVehicule,
) {
  if (natinfSearchImmobilisationVehicule == null) {
    return [];
  }

  return natinfSearchImmobilisationVehicule.map((e) => e.value!).toList();
}

List<enums.NatinfSearchImmobilisationVehicule>
natinfSearchImmobilisationVehiculeListFromJson(
  List? natinfSearchImmobilisationVehicule, [
  List<enums.NatinfSearchImmobilisationVehicule>? defaultValue,
]) {
  if (natinfSearchImmobilisationVehicule == null) {
    return defaultValue ?? [];
  }

  return natinfSearchImmobilisationVehicule
      .map((e) => natinfSearchImmobilisationVehiculeFromJson(e.toString()))
      .toList();
}

List<enums.NatinfSearchImmobilisationVehicule>?
natinfSearchImmobilisationVehiculeNullableListFromJson(
  List? natinfSearchImmobilisationVehicule, [
  List<enums.NatinfSearchImmobilisationVehicule>? defaultValue,
]) {
  if (natinfSearchImmobilisationVehicule == null) {
    return defaultValue;
  }

  return natinfSearchImmobilisationVehicule
      .map((e) => natinfSearchImmobilisationVehiculeFromJson(e.toString()))
      .toList();
}

String? natinfSearchMiseEnFourriereNullableToJson(
  enums.NatinfSearchMiseEnFourriere? natinfSearchMiseEnFourriere,
) {
  return natinfSearchMiseEnFourriere?.value;
}

String? natinfSearchMiseEnFourriereToJson(
  enums.NatinfSearchMiseEnFourriere natinfSearchMiseEnFourriere,
) {
  return natinfSearchMiseEnFourriere.value;
}

enums.NatinfSearchMiseEnFourriere natinfSearchMiseEnFourriereFromJson(
  Object? natinfSearchMiseEnFourriere, [
  enums.NatinfSearchMiseEnFourriere? defaultValue,
]) {
  return enums.NatinfSearchMiseEnFourriere.values.firstWhereOrNull(
        (e) => e.value == natinfSearchMiseEnFourriere,
      ) ??
      defaultValue ??
      enums.NatinfSearchMiseEnFourriere.swaggerGeneratedUnknown;
}

enums.NatinfSearchMiseEnFourriere? natinfSearchMiseEnFourriereNullableFromJson(
  Object? natinfSearchMiseEnFourriere, [
  enums.NatinfSearchMiseEnFourriere? defaultValue,
]) {
  if (natinfSearchMiseEnFourriere == null) {
    return null;
  }
  return enums.NatinfSearchMiseEnFourriere.values.firstWhereOrNull(
        (e) => e.value == natinfSearchMiseEnFourriere,
      ) ??
      defaultValue;
}

String natinfSearchMiseEnFourriereExplodedListToJson(
  List<enums.NatinfSearchMiseEnFourriere>? natinfSearchMiseEnFourriere,
) {
  return natinfSearchMiseEnFourriere?.map((e) => e.value!).join(',') ?? '';
}

List<String> natinfSearchMiseEnFourriereListToJson(
  List<enums.NatinfSearchMiseEnFourriere>? natinfSearchMiseEnFourriere,
) {
  if (natinfSearchMiseEnFourriere == null) {
    return [];
  }

  return natinfSearchMiseEnFourriere.map((e) => e.value!).toList();
}

List<enums.NatinfSearchMiseEnFourriere> natinfSearchMiseEnFourriereListFromJson(
  List? natinfSearchMiseEnFourriere, [
  List<enums.NatinfSearchMiseEnFourriere>? defaultValue,
]) {
  if (natinfSearchMiseEnFourriere == null) {
    return defaultValue ?? [];
  }

  return natinfSearchMiseEnFourriere
      .map((e) => natinfSearchMiseEnFourriereFromJson(e.toString()))
      .toList();
}

List<enums.NatinfSearchMiseEnFourriere>?
natinfSearchMiseEnFourriereNullableListFromJson(
  List? natinfSearchMiseEnFourriere, [
  List<enums.NatinfSearchMiseEnFourriere>? defaultValue,
]) {
  if (natinfSearchMiseEnFourriere == null) {
    return defaultValue;
  }

  return natinfSearchMiseEnFourriere
      .map((e) => natinfSearchMiseEnFourriereFromJson(e.toString()))
      .toList();
}

typedef $JsonFactory<T> = T Function(Map<String, dynamic> json);

class $CustomJsonDecoder {
  $CustomJsonDecoder(this.factories);

  final Map<Type, $JsonFactory> factories;

  dynamic decode<T>(dynamic entity) {
    if (entity is Iterable) {
      return _decodeList<T>(entity);
    }

    if (entity is T) {
      return entity;
    }

    if (isTypeOf<T, Map>()) {
      return entity;
    }

    if (isTypeOf<T, Iterable>()) {
      return entity;
    }

    if (entity is Map<String, dynamic>) {
      return _decodeMap<T>(entity);
    }

    return entity;
  }

  T _decodeMap<T>(Map<String, dynamic> values) {
    final jsonFactory = factories[T];
    if (jsonFactory == null || jsonFactory is! $JsonFactory<T>) {
      return throw "Could not find factory for type $T. Is '$T: $T.fromJsonFactory' included in the CustomJsonDecoder instance creation in bootstrapper.dart?";
    }

    return jsonFactory(values);
  }

  List<T> _decodeList<T>(Iterable values) =>
      values.where((v) => v != null).map<T>((v) => decode<T>(v) as T).toList();
}

class $JsonSerializableConverter extends chopper.JsonConverter {
  @override
  FutureOr<chopper.Response<ResultType>> convertResponse<ResultType, Item>(
    chopper.Response response,
  ) async {
    if (response.bodyString.isEmpty) {
      // In rare cases, when let's say 204 (no content) is returned -
      // we cannot decode the missing json with the result type specified
      return chopper.Response(response.base, null, error: response.error);
    }

    if (ResultType == String) {
      return response.copyWith();
    }

    if (ResultType == DateTime) {
      return response.copyWith(
        body:
            DateTime.parse((response.body as String).replaceAll('"', ''))
                as ResultType,
      );
    }

    final jsonRes = await super.convertResponse(response);
    return jsonRes.copyWith<ResultType>(
      body: $jsonDecoder.decode<Item>(jsonRes.body) as ResultType,
    );
  }
}

final $jsonDecoder = $CustomJsonDecoder(generatedMapping);

// ignore: unused_element
String? _dateToJson(DateTime? date) {
  if (date == null) {
    return null;
  }

  final year = date.year.toString();
  final month = date.month < 10 ? '0${date.month}' : date.month.toString();
  final day = date.day < 10 ? '0${date.day}' : date.day.toString();

  return '$year-$month-$day';
}

class Wrapped<T> {
  final T value;
  const Wrapped.value(this.value);
}
