import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/features/natinf/data/api/swagger.swagger.dart';
import 'package:natinfo_flutter/features/natinf/presentation/pages/category_view_helpers.dart';

void main() {
  test('sortCategoryBriefs ignores diacritics', () {
    final sorted = sortCategoryBriefs(const [
      CategoryBrief(id: 1, name: 'Établissements'),
      CategoryBrief(id: 2, name: 'Avions'),
    ]);

    expect(sorted.first.name, 'Avions');
    expect(sorted.last.name, 'Établissements');
  });

  test('buildCategoryViewSnapshot maps category content', () {
    final snapshot = buildCategoryViewSnapshot(
      Category(
        id: 10,
        name: 'Root',
        description: 'Desc',
        children: const [
          CategoryBrief(id: 2, name: 'B'),
          CategoryBrief(id: 1, name: 'A'),
        ],
        natinfs: const [
          Natinf(id: 1, numeroNatinf: '100', dacgSource: 0),
          Natinf(id: 2, numeroNatinf: '200', dacgSource: 0),
        ],
      ),
    );

    expect(snapshot.description, 'Desc');
    expect(snapshot.subCategories.map((c) => c.id), [1, 2]);
    expect(snapshot.natinfs.map((n) => n.numeroNatinf), ['100', '200']);
  });
}
