# NATINFo+

NATINFo+ est un exemple d'application cliente permettant de rechercher et de consulter les infractions en vigueur de la nomenclature NATINF via l’API de [NATINFo](https://codeberg.org/retiolus/natinfo).

<a href="https://f-droid.org/packages/net.retiolus.natinfo/" alt="Get it on F-Droid" target="_blank"><img src="https://i.ibb.co/39FwZhCY/fdroid.png" height="64"></a>
<a href="https://apps.apple.com/app/natinfo/id6745878875" alt="Get it on Google Play" target="_blank"><img src="https://i.ibb.co/JWCVWqM3/appstore.png" height="64"></a>
<a href="https://play.google.com/store/apps/details?id=net.retiolus.natinfo" alt="Get it on Google Play" target="_blank"><img src="https://i.ibb.co/4g3KBKfN/google.png" height="64"></a>

> **Google Play :** l’application est pour l’instant distribuée sur invitation.  
> Pour obtenir l’accès, [écris-moi](https://retiolus.net/contact) et je t’ajouterai dès que possible.

## Que veut dire "NATINF" ?

"NATINF est la nomenclature des natures d’infraction (NATure d’INFraction). Cette nomenclature est définie par le ministère de la Justice. Elle est utilisée par l’ensemble des services judiciaires et des administrations notamment pour enregistrer une procédure, assurer le suivi statistique, etc." - [justice.gouv.fr](https://www.justice.gouv.fr/documentation/ressources/liste-infractions-vigueur-nomenclature-natinf)

## Fonctionnalités

L’application permet de rechercher une infraction par numéro NATINF, intitulé, article de loi, code, etc., et d’en consulter toutes les informations grâce à l’API de [NATINFo](https://codeberg.org/retiolus/natinfo).

Son principal avantage par rapport au site [natinfo.app](https://natinfo.app) est qu’elle télécharge, dès le premier lancement, l’ensemble des données disponibles pour les stocker localement. Vous pouvez ainsi les consulter hors ligne ― avec, en prime, des temps d’affichage plus rapides. Les données sont ensuite mises à jour automatiquement à chaque recherche lorsque la connexion est active.

L’application est également personnalisable : thème clair ou sombre, couleur des badges (contravention / délit / crime), elle offre un historique des NATINF consultés et la gestion des favoris pour les retrouver plus rapidement, et propose des outils pratiques (taux d’alcoolémie retenu, calcul de vitesse, localisation de points routiers, glossaire des sigles, qualification des chiens dangereux).

Un gestionnaire de téléchargements permet de vérifier ou relancer les mises à jour des jeux de données (infractions, catégories, points de repère) et, si nécessaire, de saisir des sources personnalisées.

Grâce à `assets/source_registry.json`, l’application peut être configurée et construite avec d’autres sources de données que celles de natinfo.app (points de repère, infractions, etc.) afin de fonctionner de façon indépendante si besoin.

## Licences et conditions d’utilisation

NATINFo+ est développée par [retiolus](https://retiolus.net) et est distribuée sous licence [GNU GPL v3 ou ultérieure](https://www.gnu.org/licenses/gpl-3.0.html).

Votre utilisation de NATINFo+ est soumise aux conditions d’utilisation mentionnées sur [natinfo.app/legal](https://natinfo.app/legal).

### Autres Licences :

- [API de NATINFo](https://natinfo.app/swagger) sous licence [GNU GPL v3 ou ultérieure](https://www.gnu.org/licenses/gpl-3.0.html)
- Liste des infractions en vigueur de la nomenclature NATINF : données issues de [data.gouv.fr](https://www.data.gouv.fr/fr/datasets/liste-des-infractions-en-vigueur-de-la-nomenclature-natinf/), sous [Licence Ouverte / Open Licence version 2.0](https://www.etalab.gouv.fr/licence-ouverte-open-licence/), à travers l'[API de NATINFo](https://natinfo.app/swagger/).
- Données juridiques officielles : données issues de [Legifrance](https://www.legifrance.gouv.fr/contenu/pied-de-page/open-data-et-api), sous [Licence Ouverte / Open Licence version 2.0](https://www.etalab.gouv.fr/licence-ouverte-open-licence/), à travers l'[API de NATINFo](https://natinfo.app/swagger/).
- Icônes (logo) : [OpenMoji](https://openmoji.org/), sous licence [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/). 
