import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/features/natinf/data/api/swagger.swagger.dart';
import 'package:natinfo_flutter/features/natinf/domain/entities/favourite_folder.dart';
import 'package:natinfo_flutter/features/natinf/data/favourite_folder_service.dart';

void main() {
  group('FavouriteFolderService', () {
    test('buildTree ordonne les dossiers et NATINF', () {
      final folders = [
        FavouriteFolder(
          id: 1,
          name: 'B dossier',
          parentId: null,
          createdAt: DateTime(2024, 1, 1),
        ),
        FavouriteFolder(
          id: 2,
          name: 'a dossier',
          parentId: null,
          createdAt: DateTime(2024, 1, 2),
        ),
        FavouriteFolder(
          id: 3,
          name: 'Sous dossier',
          parentId: 2,
          createdAt: DateTime(2024, 1, 3),
        ),
      ];

      final contents = <int, List<Natinf>>{
        2: [
          const Natinf(numeroNatinf: '200', dacgSource: 0),
          const Natinf(numeroNatinf: '150', dacgSource: 0),
        ],
        3: [
          const Natinf(numeroNatinf: '310', dacgSource: 0),
          const Natinf(numeroNatinf: '300', dacgSource: 0),
        ],
      };

      final result = FavouriteFolderService.buildTree(
        folders: folders,
        folderContents: contents,
      );

      expect(result.map((node) => node.folder.name).toList(), [
        'a dossier',
        'B dossier',
      ]);
      final firstRoot = result.first;
      expect(firstRoot.natinfs.map((n) => n.numeroNatinf).toList(), [
        '150',
        '200',
      ]);
      expect(firstRoot.children, hasLength(1));
      final child = firstRoot.children.single;
      expect(child.folder.name, 'Sous dossier');
      expect(child.natinfs.map((n) => n.numeroNatinf).toList(), ['300', '310']);
    });

    test('findNodeById retrouve le bon nœud', () {
      final root = FavouriteFolderNode(
        folder: FavouriteFolder(
          id: 1,
          name: 'Parent',
          parentId: null,
          createdAt: DateTime(2024, 1, 1),
        ),
        children: [
          FavouriteFolderNode(
            folder: FavouriteFolder(
              id: 2,
              name: 'Enfant',
              parentId: 1,
              createdAt: DateTime(2024, 1, 2),
            ),
          ),
        ],
      );

      final match = FavouriteFolderService.findNodeById([root], 2);
      expect(match, isNotNull);
      expect(match!.folder.name, 'Enfant');
      expect(FavouriteFolderService.findNodeById([root], 99), isNull);
    });
  });
}
