import 'package:latlong2/latlong.dart';

/// Représente un point routier (PR).
class PrPoint {
  final String route;
  final String pr;
  final double lat;
  final double lon;

  const PrPoint({
    required this.route,
    required this.pr,
    required this.lat,
    required this.lon,
  });

  /// Crée un PrPoint à partir d'une ligne CSV.
  factory PrPoint.fromCsv(List<String> header, List<dynamic> row) {
    final iX = header.indexOf('X');
    final iY = header.indexOf('Y');
    final iRoute = header.indexOf('route');
    final iNumero = header.indexOf('numero');
    final iType = header.indexOf('type_de_pr');

    if (row[iType] != 'PR') {
      throw ArgumentError('Ligne CSV non-PR');
    }

    return PrPoint(
      route: row[iRoute].toString(),
      pr: row[iNumero].toString(),
      lat: double.tryParse(row[iY].toString()) ?? 0.0,
      lon: double.tryParse(row[iX].toString()) ?? 0.0,
    );
  }
}
