import 'dart:convert';
import 'package:flutter/services.dart' show rootBundle;
import 'package:natinfo_flutter/features/glossary/domain/entities/acronym.dart';

class AcronymService {
  List<Acronym>? _acronyms;

  Future<void> _loadData() async {
    final jsonStr = await rootBundle.loadString('assets/acronyms.json');
    final List<dynamic> list = jsonDecode(jsonStr);
    _acronyms =
        list
            .map((e) => Acronym.fromJson(Map<String, dynamic>.from(e as Map)))
            .toList();
  }

  Future<List<Acronym>> search(String query) async {
    query = query.toLowerCase();
    if (_acronyms == null) {
      await _loadData();
    }
    if (query.isEmpty) return _acronyms!;
    return _acronyms!.where((a) {
      final acronym = a.acronym.toLowerCase();
      final meaning = a.meaning.toLowerCase();
      return acronym.contains(query) || meaning.contains(query);
    }).toList();
  }
}
