import 'package:natinfo_flutter/shared/data_sources/source_spec.dart';

/// Thrown when no suitable source can be resolved for a dataset.
class SourceUnavailableException implements Exception {
  SourceUnavailableException(
    this.message, {
    this.dataset,
    this.requiredSourceIds = const [],
  });

  /// Human-readable error message.
  final String message;

  /// Dataset identifier for which the failure occurred.
  final String? dataset;

  /// IDs of the sources marked as required that could not be used.
  final List<String> requiredSourceIds;

  @override
  String toString() => 'SourceUnavailableException: $message';
}

/// Wraps a failure that occurred while loading a specific source.
class SourceLoadException implements Exception {
  SourceLoadException(this.spec, this.error, [this.stackTrace]);

  /// Source that failed.
  final SourceSpec spec;

  /// Underlying error.
  final Object error;

  /// Optional stack trace captured when the error occurred.
  final StackTrace? stackTrace;

  @override
  String toString() => 'Failed to load source "${spec.id}": $error';
}
