import 'package:flutter/material.dart';

/// Affiche une boîte de dialogue pour saisir le nom d'un dossier de favoris.
Future<String?> showFolderNameInputDialog({
  required BuildContext context,
  required String title,
  required String confirmLabel,
  String? initialValue,
}) {
  var currentValue = initialValue ?? '';

  return showDialog<String>(
    context: context,
    builder: (context) {
      return StatefulBuilder(
        builder: (context, setState) {
          final isValid = currentValue.trim().isNotEmpty;
          return AlertDialog(
            title: Text(title),
            content: TextFormField(
              autofocus: true,
              initialValue: currentValue,
              decoration: const InputDecoration(labelText: 'Nom du dossier'),
              onChanged: (value) {
                setState(() {
                  currentValue = value;
                });
              },
            ),
            actions: [
              TextButton(
                onPressed: () => Navigator.of(context).pop(),
                child: const Text('Annuler'),
              ),
              TextButton(
                onPressed:
                    isValid
                        ? () => Navigator.of(context).pop(currentValue.trim())
                        : null,
                child: Text(confirmLabel),
              ),
            ],
          );
        },
      );
    },
  );
}
