import 'package:flutter/material.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/features/downloads/presentation/widgets/download_screen.dart';

void main() {
  testWidgets('shows skip action on error and triggers callback', (
    WidgetTester tester,
  ) async {
    var skipped = false;

    await tester.pumpWidget(
      MaterialApp(
        home: DownloadScreen(
          status: 'Erreur lors du téléchargement',
          progress: 0,
          phase: 0,
          onRetry: () {},
          onSkip: () {
            skipped = true;
          },
        ),
      ),
    );

    await tester.pump();

    expect(find.text('Réessayer'), findsOneWidget);
    expect(find.text('Continuer avec la recherche en ligne'), findsOneWidget);

    await tester.tap(find.text('Continuer avec la recherche en ligne'));
    await tester.pump();

    expect(skipped, isTrue);
  });
}
