import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:natinfo_flutter/features/pr_locator/presentation/viewmodels/pr_locator_viewmodel.dart';

class ActionBar extends StatelessWidget {
  final VoidCallback onReset;
  final void Function(String) onSearchAddress;

  const ActionBar({
    required this.onReset,
    required this.onSearchAddress,
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    final vm = context.watch<PrLocatorViewModel>();
    return Wrap(
      spacing: 8,
      runSpacing: 8,
      alignment: WrapAlignment.center,
      children: [
        SizedBox(
          width: 240,
          child: DropdownButton<String>(
            value: vm.selectedDataset,
            isExpanded: true,
            items:
                vm.datasets.keys
                    .map(
                      (ds) => DropdownMenuItem(
                        value: ds,
                        child: Text(vm.datasetLabel(ds)),
                      ),
                    )
                    .toList(),
            onChanged: (String? selectedValue) {
              if (selectedValue != null) {
                vm.selectDataset(selectedValue);
              }
            },
          ),
        ),

        // GROUPE D'ICÔNES - toujours ensemble
        LayoutBuilder(
          builder: (context, constraints) {
            return IntrinsicWidth(
              child: Row(
                mainAxisSize: MainAxisSize.min,
                children: [
                  IconButton(
                    tooltip: 'Localiser ma position',
                    icon: const Icon(Icons.my_location),
                    onPressed: () async {
                      vm.locateMe();
                    },
                  ),
                  IconButton(
                    tooltip: "Saisir une adresse à localiser",
                    icon: const Icon(Icons.search),
                    onPressed: () {
                      showDialog(
                        context: context,
                        builder: (_) {
                          final ctrl = TextEditingController();
                          return AlertDialog(
                            title: const Text('Saisir une adresse à localiser'),
                            content: TextField(
                              controller: ctrl,
                              decoration: const InputDecoration(
                                hintText: "Adresse...",
                              ),
                              autofocus: true,
                              onSubmitted: (_) {
                                Navigator.pop(context);
                                onSearchAddress(ctrl.text.trim());
                              },
                            ),
                            actions: [
                              TextButton(
                                onPressed: () => Navigator.pop(context),
                                child: const Text('Annuler'),
                              ),
                              TextButton(
                                onPressed: () {
                                  Navigator.pop(context);
                                  onSearchAddress(ctrl.text.trim());
                                },
                                child: const Text('OK'),
                              ),
                            ],
                          );
                        },
                      );
                    },
                  ),
                  IconButton(
                    tooltip: "Réinitialiser",
                    onPressed: onReset,
                    icon: const Icon(Icons.refresh),
                  ),
                ],
              ),
            );
          },
        ),
      ],
    );
  }
}
