import 'package:diacritic/diacritic.dart';
import 'package:natinfo_flutter/features/natinf/data/api/swagger.swagger.dart';

class CategoryViewSnapshot {
  const CategoryViewSnapshot({
    required this.subCategories,
    required this.natinfs,
    required this.description,
  });

  final List<CategoryBrief> subCategories;
  final List<Natinf> natinfs;
  final String? description;
}

/// Returns a new list of [CategoryBrief] sorted alphabetically while ignoring
/// diacritics so that \"É\" and \"E\" are treated equally.
List<CategoryBrief> sortCategoryBriefs(List<CategoryBrief> categories) {
  final list = List<CategoryBrief>.from(categories);
  list.sort(
    (a, b) => removeDiacritics(a.name).compareTo(removeDiacritics(b.name)),
  );
  return list;
}

/// Builds a [CategoryViewSnapshot] from a loaded [Category], ensuring the
/// children and NATINF entries are ready for presentation.
CategoryViewSnapshot buildCategoryViewSnapshot(Category category) {
  final children = sortCategoryBriefs(category.children ?? const []);
  final natinfs = List<Natinf>.from(category.natinfs ?? const <Natinf>[]);
  return CategoryViewSnapshot(
    subCategories: children,
    natinfs: natinfs,
    description: category.description,
  );
}
