import 'package:flutter/material.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/shared/utils/mounted_set_state_mixin.dart';

void main() {
  testWidgets('safeSetState updates when mounted and ignores after dispose', (
    tester,
  ) async {
    _TestWidgetState? state;
    await tester.pumpWidget(
      MaterialApp(home: _TestWidget(onReady: (value) => state = value)),
    );
    expect(state, isNotNull);
    expect(state!.counter, 0);

    state!.increment();
    await tester.pump();
    expect(state!.counter, 1);

    await tester.pumpWidget(const SizedBox.shrink());

    expect(() => state!.increment(), returnsNormally);
    expect(state!.counter, 1);
  });
}

class _TestWidget extends StatefulWidget {
  const _TestWidget({required this.onReady});

  final void Function(_TestWidgetState state) onReady;

  @override
  State<_TestWidget> createState() => _TestWidgetState();
}

class _TestWidgetState extends State<_TestWidget>
    with MountedSetStateMixin<_TestWidget> {
  int counter = 0;

  void increment() {
    safeSetState(() {
      counter += 1;
    });
  }

  @override
  void initState() {
    super.initState();
    widget.onReady(this);
  }

  @override
  Widget build(BuildContext context) => const SizedBox();
}
