import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/shared/data_sources/source_registry.dart';
import 'package:natinfo_flutter/shared/data_sources/source_resolver.dart';

void main() {
  group('SourceResolver', () {
    const specJson = '''
    {
      "sources": [
        {
          "id": "network",
          "dataset": "natinf",
          "name": "Infractions NATINFo",
          "type": "api",
          "uri": "https://example.com",
          "scope": "natinf",
          "priority": 1,
          "requiredAtBuild": false,
          "requiresNetwork": true,
          "schemaVersion": 1,
          "checksum": null,
          "checksumAlgo": null
        },
        {
          "id": "asset",
          "dataset": "natinf",
          "name": "Infractions NATINFo",
          "type": "asset",
          "uri": "asset://natinf.json",
          "scope": "natinf",
          "priority": 2,
          "requiredAtBuild": false,
          "requiresNetwork": false,
          "schemaVersion": 1,
          "checksum": null,
          "checksumAlgo": null
        }
      ]
    }
''';

    test('prefers network source when allowed', () {
      final registry = SourceRegistry.fromJsonString(specJson);
      final resolver = SourceResolver(registry);
      final source = resolver.resolve('natinf');
      expect(source.id, 'network');
    });

    test('falls back to offline source when network is disabled', () {
      final registry = SourceRegistry.fromJsonString(specJson);
      final resolver = SourceResolver(registry);
      final source = resolver.resolve('natinf', allowNetwork: false);
      expect(source.id, 'asset');
    });

    test('honors preferred source when available', () {
      final registry = SourceRegistry.fromJsonString(specJson);
      final resolver = SourceResolver(registry);
      final candidates = resolver.resolveCandidates(
        'natinf',
        preferredSourceId: 'asset',
      );
      expect(candidates.first.id, 'asset');
    });
  });
}
