import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/shared/data_sources/source_preferences.dart';
import 'package:shared_preferences/shared_preferences.dart';

void main() {
  TestWidgetsFlutterBinding.ensureInitialized();

  setUp(() async {
    SharedPreferences.setMockInitialValues({});
  });

  group('SourcePreferences', () {
    test('allows network by default when build permits it', () async {
      final prefs = await SharedPreferences.getInstance();
      final sourcePrefs = SourcePreferences(prefs, globalNetworkAllowed: true);

      expect(sourcePrefs.isNetworkAllowed('dataset'), isTrue);
    });

    test('persists user toggle when allowed', () async {
      final prefs = await SharedPreferences.getInstance();
      final sourcePrefs = SourcePreferences(prefs, globalNetworkAllowed: true);

      await sourcePrefs.setNetworkAllowed('dataset', false);
      expect(sourcePrefs.isNetworkAllowed('dataset'), isFalse);
    });

    test('forces network off when build policy forbids downloads', () async {
      final prefs = await SharedPreferences.getInstance();
      final sourcePrefs = SourcePreferences(prefs, globalNetworkAllowed: false);

      await sourcePrefs.setNetworkAllowed('dataset', true);
      expect(sourcePrefs.isNetworkAllowed('dataset'), isFalse);
      expect(sourcePrefs.isNetworkPolicyLocked, isTrue);
    });
  });
}
