import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/shared/data_sources/source_override_store.dart';
import 'package:shared_preferences/shared_preferences.dart';

void main() {
  TestWidgetsFlutterBinding.ensureInitialized();

  setUp(() async {
    SharedPreferences.setMockInitialValues({});
  });

  test('reads overrides with trimming and prefix filtering', () async {
    SharedPreferences.setMockInitialValues({
      SourceOverrideStore.keyFor('natinf'): ' https://custom.example ',
      SourceOverrideStore.keyFor('pr-national-autoroutes'): 'https://pr.test',
      'unrelated': 'ignored',
      SourceOverrideStore.keyFor('empty'): '   ',
    });
    final prefs = await SharedPreferences.getInstance();
    final store = SourceOverrideStore(prefs);

    final overrides = store.loadOverrides();

    expect(overrides, hasLength(2));
    expect(overrides['natinf']!.toString(), 'https://custom.example');
    expect(overrides['pr-national-autoroutes']!.toString(), 'https://pr.test');
    expect(overrides.containsKey('empty'), isFalse);
  });
}
