import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/features/natinf/data/api/swagger.swagger.dart';
import 'package:natinfo_flutter/features/natinf/presentation/pages/natinf_sorter.dart';

const sampleNatinfs = [
  Natinf(
    numeroNatinf: '200',
    qualificationInfraction: 'Vol',
    natureInfraction: 'Grave',
    dacgSource: 0,
  ),
  Natinf(
    numeroNatinf: '150',
    qualificationInfraction: 'Arme',
    natureInfraction: 'Mineur',
    dacgSource: 0,
  ),
  Natinf(
    numeroNatinf: 'abc',
    qualificationInfraction: 'Équipement',
    natureInfraction: 'Élément',
    dacgSource: 0,
  ),
];

void main() {
  NatinfSorter sorter() => const NatinfSorter(sampleNatinfs);

  test('apiOrder preserves original order and reverses when descending', () {
    final ascending = sorter().sort(NatinfSortKey.apiOrder, ascending: true);
    expect(ascending.map((n) => n.numeroNatinf), ['200', '150', 'abc']);

    final descending = sorter().sort(NatinfSortKey.apiOrder, ascending: false);
    expect(descending.map((n) => n.numeroNatinf), ['abc', '150', '200']);
  });

  test('natinf sort handles numeric parsing and fallbacks', () {
    final result = sorter().sort(NatinfSortKey.natinf, ascending: true);
    expect(result.map((n) => n.numeroNatinf), ['150', '200', 'abc']);
  });

  test('alphabetical sort ignores case and diacritics fallback', () {
    final result = sorter().sort(NatinfSortKey.alphabetical, ascending: true);
    expect(result.first.qualificationInfraction, 'Arme');
  });

  test('nature sort uses alphabetical fallback', () {
    final result = sorter().sort(NatinfSortKey.nature, ascending: true);
    expect(result.first.natureInfraction, 'Élément');
  });
}
