import 'package:flutter/foundation.dart';

/// Signature for custom log handlers.
typedef SourceLogHandler = void Function(String message);

/// Simple tagged logger for data source operations.
class SourceLogger {
  SourceLogger({this.tag = 'Sources', SourceLogHandler? handler})
    : _handler = handler ?? debugPrint;

  /// Shared logger used across the data source layer.
  static final SourceLogger shared = SourceLogger();

  /// Tag prepended to each log line.
  final String tag;

  final SourceLogHandler _handler;

  /// Logs an informational message.
  void info(String message) => _handler('[$tag] $message');

  /// Logs a warning message.
  void warn(String message) => _handler('[$tag][WARN] $message');
}
