import 'package:flutter/material.dart';
import 'package:natinfo_flutter/features/about/presentation/about_page.dart';
import 'package:natinfo_flutter/features/auth/presentation/account_page.dart';
import 'package:natinfo_flutter/features/auth/presentation/auth_provider.dart';
import 'package:natinfo_flutter/features/auth/presentation/login_page.dart';
import 'package:natinfo_flutter/features/natinf/presentation/pages/categories_page.dart';
import 'package:natinfo_flutter/features/natinf/presentation/pages/favourites_page.dart';
import 'package:natinfo_flutter/features/natinf/presentation/pages/history_page.dart';
import 'package:natinfo_flutter/features/settings/presentation/settings_page.dart';
import 'package:natinfo_flutter/features/tools/presentation/tools_page.dart';
import 'package:provider/provider.dart';

class AppDrawer extends StatelessWidget {
  const AppDrawer({super.key});

  @override
  Widget build(BuildContext context) {
    final auth = context.watch<AuthProvider>();
    final session = auth.session;
    return Drawer(
      child: ListView(
        children: [
          DrawerHeader(
            decoration: BoxDecoration(color: Theme.of(context).primaryColor),
            child: Align(
              alignment: Alignment.bottomLeft,
              child: Text(
                session == null
                    ? 'Menu'
                    : 'Connecté en tant que ${session.username ?? 'utilisateur'}',
                style: const TextStyle(color: Colors.white, fontSize: 20),
              ),
            ),
          ),
          ListTile(
            leading: const Icon(Icons.star),
            title: const Text("Favoris"),
            onTap: () {
              Navigator.pop(context);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => const FavouritesPage()),
              );
            },
          ),
          ListTile(
            leading: const Icon(Icons.history),
            title: const Text("Historique"),
            onTap: () {
              Navigator.pop(context);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => const HistoriquePage()),
              );
            },
          ),
          ListTile(
            leading: const Icon(Icons.category),
            title: const Text("Catégories"),
            onTap: () {
              Navigator.pop(context);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => const CategoriesPage()),
              );
            },
          ),
          ListTile(
            leading: const Icon(Icons.home_repair_service),
            title: const Text("Outils"),
            onTap: () {
              Navigator.pop(context);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => const ToolsPage()),
              );
            },
          ),
          ListTile(
            leading: const Icon(Icons.settings),
            title: const Text("Réglages"),
            onTap: () {
              Navigator.pop(context);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => const SettingsPage()),
              );
            },
          ),
          ListTile(
            leading: const Icon(Icons.info),
            title: const Text("À propos"),
            onTap: () {
              Navigator.pop(context);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => const AboutPage()),
              );
            },
          ),
          const Divider(),
          if (session == null)
            ListTile(
              leading: const Icon(Icons.login),
              title: const Text('Connexion'),
              onTap: () async {
                Navigator.pop(context);
                await Navigator.push(
                  context,
                  MaterialPageRoute(builder: (_) => const LoginPage()),
                );
              },
            )
          else ...[
            ListTile(
              leading: const Icon(Icons.person),
              title: const Text('Mon compte'),
              onTap: () {
                Navigator.pop(context);
                Navigator.push(
                  context,
                  MaterialPageRoute(builder: (_) => const AccountPage()),
                );
              },
            ),
            ListTile(
              leading: const Icon(Icons.logout),
              title: const Text('Déconnexion'),
              onTap: () async {
                Navigator.pop(context);
                await context.read<AuthProvider>().logout();
                ScaffoldMessenger.of(
                  context,
                ).showSnackBar(const SnackBar(content: Text('Déconnecté')));
              },
            ),
          ],
        ],
      ),
    );
  }
}
