import 'package:flutter/material.dart';
import 'package:flutter_test/flutter_test.dart';

import 'package:natinfo_flutter/features/natinf/presentation/widgets/favourite_folder_dialogs.dart';

void main() {
  testWidgets(
    'showFolderNameInputDialog returns trimmed value without throwing',
    (tester) async {
      late BuildContext dialogContext;

      await tester.pumpWidget(
        MaterialApp(
          home: Builder(
            builder: (context) {
              dialogContext = context;
              return const SizedBox.shrink();
            },
          ),
        ),
      );

      final future = showFolderNameInputDialog(
        context: dialogContext,
        title: 'Créer un dossier',
        confirmLabel: 'Créer',
      );

      await tester.pumpAndSettle();

      await tester.enterText(find.byType(TextFormField), '  Nouveau dossier  ');
      await tester.pump();

      await tester.tap(find.widgetWithText(TextButton, 'Créer'));
      await tester.pumpAndSettle();

      final result = await future;

      expect(result, 'Nouveau dossier');
      expect(tester.takeException(), isNull);
    },
  );
}
