import 'dart:io';

import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/shared/data_sources/file_source_adapter.dart';
import 'package:natinfo_flutter/shared/data_sources/source_adapter.dart';
import 'package:natinfo_flutter/shared/data_sources/source_spec.dart';

void main() {
  group('FileSourceAdapter', () {
    test('reads bytes from filesystem', () async {
      final tempFile = await File(
        '${Directory.systemTemp.path}/data.json',
      ).create(recursive: true);
      await tempFile.writeAsString('local');
      final adapter = FileSourceAdapter();
      final spec = SourceSpec(
        id: 'file',
        dataset: 'natinf',
        name: 'Infractions NATINFo',
        type: SourceType.file,
        uri: tempFile.uri,
        scope: 'natinf',
        priority: 1,
        requiredAtBuild: false,
        requiresNetwork: false,
        schemaVersion: 1,
        checksum: 'f5ddaf0ca7929578b408c909429f68f2',
        checksumAlgo: 'md5',
      );

      final result = await adapter.load(spec);
      expect(result.bytes, 'local'.codeUnits);
      expect(result.integrity.status, ChecksumStatus.match);
    });

    test('throws if file does not exist', () async {
      final adapter = FileSourceAdapter();
      final spec = SourceSpec(
        id: 'file',
        dataset: 'natinf',
        name: 'Infractions NATINFo',
        type: SourceType.file,
        uri: Uri.file('/non-existent/file.json'),
        scope: 'natinf',
        priority: 1,
        requiredAtBuild: false,
        requiresNetwork: false,
        schemaVersion: 1,
      );

      expect(() => adapter.load(spec), throwsA(isA<FileSystemException>()));
    });
  });
}
