import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/shared/data_sources/default_source_adapters.dart';
import 'package:natinfo_flutter/shared/data_sources/source_adapter.dart';
import 'package:natinfo_flutter/shared/data_sources/source_spec.dart';

class _StubAdapter extends SourceAdapter {
  _StubAdapter(this._type);

  final SourceType _type;

  @override
  SourceType get type => _type;

  @override
  Future<SourceLoadResult> load(SourceSpec spec) {
    throw UnimplementedError();
  }
}

void main() {
  group('DefaultSourceAdapters', () {
    test('provides defaults for all supported types', () {
      final map = DefaultSourceAdapters.buildMap();

      expect(map.keys, containsAll(SourceType.values));
    });

    test('overrides defaults when provided', () {
      final override = _StubAdapter(SourceType.api);
      final list = DefaultSourceAdapters.buildList(overrides: [override]);

      expect(list.where((a) => a.type == SourceType.api).single, override);
    });
  });
}
