import 'package:flutter/material.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/app/config/app_config.dart';
import 'package:natinfo_flutter/app/state/operational_mode_provider.dart';
import 'package:natinfo_flutter/app/theme/theme_provider.dart';
import 'package:natinfo_flutter/features/settings/presentation/settings_page.dart';
import 'package:provider/provider.dart';
import 'package:shared_preferences/shared_preferences.dart';

void main() {
  TestWidgetsFlutterBinding.ensureInitialized();

  setUp(() {
    SharedPreferences.setMockInitialValues({});
    AppConfig.forceOffline = true;
  });

  Widget buildHost() {
    return MultiProvider(
      providers: [
        ChangeNotifierProvider(create: (_) => ThemeProvider()),
        ChangeNotifierProvider(create: (_) => OperationalModeProvider()),
      ],
      child: const MaterialApp(home: SettingsPage()),
    );
  }

  testWidgets('shows quick navigation and all sections', (tester) async {
    await tester.pumpWidget(buildHost());
    await tester.pumpAndSettle();

    expect(find.text('Accès rapide'), findsOneWidget);
    expect(find.text('Connectivité'), findsNWidgets(2));
    expect(find.text('Apparence'), findsNWidgets(2));
    expect(find.text('Couleurs des infractions'), findsNWidgets(2));
    expect(find.text('Données téléchargées'), findsNWidgets(2));
    expect(find.text('Confidentialité'), findsNWidgets(2));
  });

  testWidgets('quick navigation scrolls to section', (tester) async {
    final view = tester.view;
    view.physicalSize = const Size(400, 520);
    view.devicePixelRatio = 1.0;
    addTearDown(() {
      view.resetPhysicalSize();
      view.resetDevicePixelRatio();
    });

    await tester.pumpWidget(buildHost());
    await tester.pumpAndSettle();

    final cardFinder = find.descendant(
      of: find.byType(Card),
      matching: find.text('Données téléchargées'),
    );
    final before = tester.getRect(cardFinder).top;

    final chipFinder = find.text('Données téléchargées').first;
    await tester.scrollUntilVisible(
      chipFinder,
      80,
      scrollable: find.byType(Scrollable).first,
    );
    await tester.tap(chipFinder, warnIfMissed: false);
    await tester.pumpAndSettle();

    final after = tester.getRect(cardFinder).top;
    final viewHeight = view.physicalSize.height / view.devicePixelRatio;

    expect(after, lessThan(before));
    expect(after, lessThan(viewHeight));
  });
}
