import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/features/natinf/data/api/swagger.swagger.dart';
import 'package:natinfo_flutter/features/natinf/data/natinf_search_fallback.dart';

Future<List<Natinf>> _mockSearch(String query, List<Natinf> results) async {
  expect(query, 'abc');
  return results;
}

void main() {
  test('fallbackToLocalSearch notifies only when results exist', () async {
    var statusMessage = '';
    final empty = await fallbackToLocalSearch(
      'abc',
      localSearch: (query) => _mockSearch(query, const []),
      onStatus: (msg) => statusMessage = msg,
      successStatus: 'success',
    );
    expect(empty, isEmpty);
    expect(statusMessage, isEmpty);

    final populated = await fallbackToLocalSearch(
      'abc',
      localSearch:
          (query) => _mockSearch(query, const [
            Natinf(id: 1, numeroNatinf: '1', dacgSource: 0),
          ]),
      onStatus: (msg) => statusMessage = msg,
      successStatus: 'success',
    );
    expect(populated, isNotEmpty);
    expect(statusMessage, 'success');
  });

  group('resolveOfflineMode', () {
    test(
      'returns forced when offline is forced without checking connectivity',
      () async {
        var called = false;
        final mode = await resolveOfflineMode(
          forceOffline: true,
          connectivityLookup: () async {
            called = true;
            return ConnectivityResult.wifi;
          },
        );
        expect(mode, OfflineMode.forced);
        expect(called, isFalse);
      },
    );

    test(
      'returns noConnectivity when connectivity lookup reports none',
      () async {
        final mode = await resolveOfflineMode(
          forceOffline: false,
          connectivityLookup: () async => ConnectivityResult.none,
        );
        expect(mode, OfflineMode.noConnectivity);
      },
    );

    test('returns none when connectivity is available', () async {
      final mode = await resolveOfflineMode(
        forceOffline: false,
        connectivityLookup: () async => ConnectivityResult.mobile,
      );
      expect(mode, OfflineMode.none);
    });
  });
}
