import 'package:flutter/material.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/app/config/app_config.dart';
import 'package:natinfo_flutter/features/about/presentation/about_page.dart';
import 'package:package_info_plus/package_info_plus.dart';
import 'package:shared_preferences/shared_preferences.dart';

void main() {
  TestWidgetsFlutterBinding.ensureInitialized();

  setUp(() {
    AppConfig.forceOffline = true;
    SharedPreferences.setMockInitialValues({'matomoTrackingEnabled': false});
    PackageInfo.setMockInitialValues(
      appName: 'NATINFo+',
      packageName: 'natinfo_flutter',
      version: '1.2.3',
      buildNumber: '456',
      buildSignature: '',
    );
  });

  tearDown(() {
    AppConfig.forceOffline = false;
  });

  testWidgets('shows version with build number', (tester) async {
    await tester.pumpWidget(const MaterialApp(home: AboutPage()));
    await tester.pumpAndSettle();

    expect(find.text('Version\u00a0: 1.2.3 (456)'), findsOneWidget);
  });
}
