import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/app/config/repository_bootstrap.dart';
import 'package:natinfo_flutter/features/natinf/data/natinf_repository.dart';
import 'package:shared_preferences/shared_preferences.dart';

class _StubRepository extends NatinfRepository {
  @override
  Future<void> init() async {}
}

class _FailingRepository extends NatinfRepository {
  @override
  Future<void> init() async {
    throw Exception('fail');
  }
}

void main() {
  TestWidgetsFlutterBinding.ensureInitialized();

  test('falls back to mock preferences when loader fails', () async {
    bool loaderCalled = false;

    final bootstrap = await RepositoryBootstrap.initialize(
      preferencesLoader: () {
        loaderCalled = true;
        throw Exception('prefs fail');
      },
      repositoryBuilder: () => _StubRepository(),
    );

    expect(loaderCalled, isTrue);
    await bootstrap.preferences.setBool('foo', true);
    expect(bootstrap.preferences.getBool('foo'), isTrue);
  });

  test('uses fallback repository when initialization throws', () async {
    SharedPreferences.setMockInitialValues(const {});

    final bootstrap = await RepositoryBootstrap.initialize(
      preferencesLoader: SharedPreferences.getInstance,
      repositoryBuilder: () => _FailingRepository(),
    );

    expect(
      bootstrap.repository.searchNatinf('query'),
      throwsA(isA<RepositoryUnavailableException>()),
    );
    expect(
      bootstrap.repository.fetchInitialData(),
      throwsA(isA<RepositoryUnavailableException>()),
    );
  });
}
